import { NgModule } from '@angular/core';
import { QUILL_CONFIG_TOKEN } from './quill-editor.interfaces';
import * as i0 from "@angular/core";
/**
 * This `NgModule` provides a global Quill config on the root level, e.g., in `AppModule`.
 * But this eliminates the need to import the entire `ngx-quill` library into the main bundle.
 * The `quill-editor` itself may be rendered in any lazy-loaded module, but importing `QuillModule`
 * into the `AppModule` will bundle the `ngx-quill` into the vendor.
 */
class QuillConfigModule {
    static forRoot(config) {
        return {
            ngModule: QuillConfigModule,
            providers: [{ provide: QUILL_CONFIG_TOKEN, useValue: config }],
        };
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.2.8", ngImport: i0, type: QuillConfigModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule }); }
    static { this.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "16.2.8", ngImport: i0, type: QuillConfigModule }); }
    static { this.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "16.2.8", ngImport: i0, type: QuillConfigModule }); }
}
export { QuillConfigModule };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.2.8", ngImport: i0, type: QuillConfigModule, decorators: [{
            type: NgModule
        }] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVpbGwtY29uZmlnLm1vZHVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3Byb2plY3RzL25neC1xdWlsbC9jb25maWcvc3JjL3F1aWxsLWNvbmZpZy5tb2R1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUF1QixRQUFRLEVBQUUsTUFBTSxlQUFlLENBQUE7QUFFN0QsT0FBTyxFQUFlLGtCQUFrQixFQUFFLE1BQU0sMkJBQTJCLENBQUE7O0FBRTNFOzs7OztHQUtHO0FBQ0gsTUFDYSxpQkFBaUI7SUFDNUIsTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFtQjtRQUNoQyxPQUFPO1lBQ0wsUUFBUSxFQUFFLGlCQUFpQjtZQUMzQixTQUFTLEVBQUUsQ0FBQyxFQUFFLE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxRQUFRLEVBQUUsTUFBTSxFQUFFLENBQUM7U0FDL0QsQ0FBQTtJQUNILENBQUM7OEdBTlUsaUJBQWlCOytHQUFqQixpQkFBaUI7K0dBQWpCLGlCQUFpQjs7U0FBakIsaUJBQWlCOzJGQUFqQixpQkFBaUI7a0JBRDdCLFFBQVEiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBNb2R1bGVXaXRoUHJvdmlkZXJzLCBOZ01vZHVsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnXG5cbmltcG9ydCB7IFF1aWxsQ29uZmlnLCBRVUlMTF9DT05GSUdfVE9LRU4gfSBmcm9tICcuL3F1aWxsLWVkaXRvci5pbnRlcmZhY2VzJ1xuXG4vKipcbiAqIFRoaXMgYE5nTW9kdWxlYCBwcm92aWRlcyBhIGdsb2JhbCBRdWlsbCBjb25maWcgb24gdGhlIHJvb3QgbGV2ZWwsIGUuZy4sIGluIGBBcHBNb2R1bGVgLlxuICogQnV0IHRoaXMgZWxpbWluYXRlcyB0aGUgbmVlZCB0byBpbXBvcnQgdGhlIGVudGlyZSBgbmd4LXF1aWxsYCBsaWJyYXJ5IGludG8gdGhlIG1haW4gYnVuZGxlLlxuICogVGhlIGBxdWlsbC1lZGl0b3JgIGl0c2VsZiBtYXkgYmUgcmVuZGVyZWQgaW4gYW55IGxhenktbG9hZGVkIG1vZHVsZSwgYnV0IGltcG9ydGluZyBgUXVpbGxNb2R1bGVgXG4gKiBpbnRvIHRoZSBgQXBwTW9kdWxlYCB3aWxsIGJ1bmRsZSB0aGUgYG5neC1xdWlsbGAgaW50byB0aGUgdmVuZG9yLlxuICovXG5ATmdNb2R1bGUoKVxuZXhwb3J0IGNsYXNzIFF1aWxsQ29uZmlnTW9kdWxlIHtcbiAgc3RhdGljIGZvclJvb3QoY29uZmlnOiBRdWlsbENvbmZpZyk6IE1vZHVsZVdpdGhQcm92aWRlcnM8UXVpbGxDb25maWdNb2R1bGU+IHtcbiAgICByZXR1cm4ge1xuICAgICAgbmdNb2R1bGU6IFF1aWxsQ29uZmlnTW9kdWxlLFxuICAgICAgcHJvdmlkZXJzOiBbeyBwcm92aWRlOiBRVUlMTF9DT05GSUdfVE9LRU4sIHVzZVZhbHVlOiBjb25maWcgfV0sXG4gICAgfVxuICB9XG59XG4iXX0=