import { makeEnvironmentProviders } from '@angular/core';
import { QUILL_CONFIG_TOKEN } from './quill-editor.interfaces';
/**
 * Provides Quill configuration at the root level:
 * ```ts
 * bootstrapApplication(AppComponent, {
 *   providers: [provideQuillConfig(...)]
 * });
 * ```
 */
export const provideQuillConfig = (config) => makeEnvironmentProviders([{ provide: QUILL_CONFIG_TOKEN, useValue: config }]);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvdmlkZS1xdWlsbC1jb25maWcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9wcm9qZWN0cy9uZ3gtcXVpbGwvY29uZmlnL3NyYy9wcm92aWRlLXF1aWxsLWNvbmZpZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQXdCLHdCQUF3QixFQUFFLE1BQU0sZUFBZSxDQUFBO0FBRTlFLE9BQU8sRUFBRSxrQkFBa0IsRUFBZSxNQUFNLDJCQUEyQixDQUFBO0FBRTNFOzs7Ozs7O0dBT0c7QUFDSCxNQUFNLENBQUMsTUFBTSxrQkFBa0IsR0FBRyxDQUFDLE1BQW1CLEVBQXdCLEVBQUUsQ0FDOUUsd0JBQXdCLENBQUMsQ0FBQyxFQUFFLE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxRQUFRLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQyxDQUFBIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRW52aXJvbm1lbnRQcm92aWRlcnMsIG1ha2VFbnZpcm9ubWVudFByb3ZpZGVycyB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnXG5cbmltcG9ydCB7IFFVSUxMX0NPTkZJR19UT0tFTiwgUXVpbGxDb25maWcgfSBmcm9tICcuL3F1aWxsLWVkaXRvci5pbnRlcmZhY2VzJ1xuXG4vKipcbiAqIFByb3ZpZGVzIFF1aWxsIGNvbmZpZ3VyYXRpb24gYXQgdGhlIHJvb3QgbGV2ZWw6XG4gKiBgYGB0c1xuICogYm9vdHN0cmFwQXBwbGljYXRpb24oQXBwQ29tcG9uZW50LCB7XG4gKiAgIHByb3ZpZGVyczogW3Byb3ZpZGVRdWlsbENvbmZpZyguLi4pXVxuICogfSk7XG4gKiBgYGBcbiAqL1xuZXhwb3J0IGNvbnN0IHByb3ZpZGVRdWlsbENvbmZpZyA9IChjb25maWc6IFF1aWxsQ29uZmlnKTogRW52aXJvbm1lbnRQcm92aWRlcnMgPT5cbiAgbWFrZUVudmlyb25tZW50UHJvdmlkZXJzKFt7IHByb3ZpZGU6IFFVSUxMX0NPTkZJR19UT0tFTiwgdXNlVmFsdWU6IGNvbmZpZyB9XSlcbiJdfQ==