import { EventEmitter, TemplateRef } from '@angular/core';
import { Subject } from 'rxjs';
import { NgxMaterialTimepickerEventService } from './services/ngx-material-timepicker-event.service';
import { TimepickerDirective } from './directives/ngx-timepicker.directive';
import { DateTime } from 'luxon';
import { DomService } from './services/dom.service';
import { TimepickerRef } from './models/timepicker-ref.interface';
import { NgxMaterialTimepickerTheme } from './models/ngx-material-timepicker-theme.interface';
import * as i0 from "@angular/core";
export declare class NgxMaterialTimepickerComponent implements TimepickerRef {
    private eventService;
    private domService;
    timeUpdated: Subject<string>;
    cancelBtnTmpl: TemplateRef<Node>;
    editableHintTmpl: TemplateRef<Node>;
    confirmBtnTmpl: TemplateRef<Node>;
    isEsc: boolean;
    enableKeyboardInput: boolean;
    preventOverlayClick: boolean;
    disableAnimation: boolean;
    appendToInput: boolean;
    hoursOnly: boolean;
    defaultTime: string;
    timepickerClass: string;
    theme: NgxMaterialTimepickerTheme;
    min: DateTime;
    max: DateTime;
    /**
     * @deprecated Since version 5.1.1. Will be deleted on version 6.0.0. Use @Input() theme instead
     */
    set ngxMaterialTimepickerTheme(theme: NgxMaterialTimepickerTheme);
    set format(value: number);
    get format(): number;
    set minutesGap(gap: number);
    get minutesGap(): number;
    timeSet: EventEmitter<string>;
    opened: EventEmitter<null>;
    closed: EventEmitter<null>;
    hourSelected: EventEmitter<number>;
    timeChanged: EventEmitter<string>;
    private _minutesGap;
    private _format;
    private _ngxMaterialTimepickerTheme;
    private timepickerInput;
    private unsubscribe;
    constructor(eventService: NgxMaterialTimepickerEventService, domService: DomService);
    get minTime(): DateTime;
    get maxTime(): DateTime;
    get disabled(): boolean;
    get time(): string;
    get inputElement(): any;
    /***
     * Register an input with this timepicker.
     * input - The timepicker input to register with this timepicker
     */
    registerInput(input: TimepickerDirective): void;
    open(): void;
    close(): void;
    updateTime(time: string): void;
    private subscribeToEvents;
    private unsubscribeFromEvents;
    static ɵfac: i0.ɵɵFactoryDeclaration<NgxMaterialTimepickerComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<NgxMaterialTimepickerComponent, "ngx-material-timepicker", never, { "cancelBtnTmpl": "cancelBtnTmpl"; "editableHintTmpl": "editableHintTmpl"; "confirmBtnTmpl": "confirmBtnTmpl"; "isEsc": "ESC"; "enableKeyboardInput": "enableKeyboardInput"; "preventOverlayClick": "preventOverlayClick"; "disableAnimation": "disableAnimation"; "appendToInput": "appendToInput"; "hoursOnly": "hoursOnly"; "defaultTime": "defaultTime"; "timepickerClass": "timepickerClass"; "theme": "theme"; "min": "min"; "max": "max"; "ngxMaterialTimepickerTheme": "ngxMaterialTimepickerTheme"; "format": "format"; "minutesGap": "minutesGap"; }, { "timeSet": "timeSet"; "opened": "opened"; "closed": "closed"; "hourSelected": "hourSelected"; "timeChanged": "timeChanged"; }, never, never>;
}
