import { EventEmitter, OnDestroy, OnInit, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NgxMaterialTimepickerService } from '../../services/ngx-material-timepicker.service';
import { Observable } from 'rxjs';
import { ClockFaceTime } from '../../models/clock-face-time.interface';
import { TimePeriod } from '../../models/time-period.enum';
import { TimeUnit } from '../../models/time-unit.enum';
import { NgxMaterialTimepickerTheme } from '../../models/ngx-material-timepicker-theme.interface';
import { DateTime } from 'luxon';
import * as i0 from "@angular/core";
export declare class NgxTimepickerFieldComponent implements OnInit, OnDestroy, ControlValueAccessor {
    private timepickerService;
    private locale;
    period: TimePeriod;
    hour$: Observable<ClockFaceTime>;
    minute$: Observable<ClockFaceTime>;
    minHour: number;
    maxHour: number;
    timeUnit: typeof TimeUnit;
    timepickerTime: string;
    hoursList: ClockFaceTime[];
    minutesList: ClockFaceTime[];
    isTimeRangeSet: boolean;
    isChangePeriodDisabled: boolean;
    disabled: boolean;
    toggleIcon: TemplateRef<HTMLObjectElement>;
    buttonAlign: 'right' | 'left';
    clockTheme: NgxMaterialTimepickerTheme;
    controlOnly: boolean;
    cancelBtnTmpl: TemplateRef<Node>;
    confirmBtnTmpl: TemplateRef<Node>;
    set format(value: number);
    get format(): number;
    set min(value: string | DateTime);
    get min(): string | DateTime;
    set max(value: string | DateTime);
    get max(): string | DateTime;
    set defaultTime(val: string);
    get defaultTime(): string;
    set minutesGap(gap: number);
    get minutesGap(): number;
    timeChanged: EventEmitter<string>;
    private _defaultTime;
    private _format;
    private _min;
    private _max;
    private _minutesGap;
    private previousFormat;
    private unsubscribe$;
    private isFirstTimeChange;
    private isDefaultTime;
    private selectedHour;
    private onChange;
    constructor(timepickerService: NgxMaterialTimepickerService, locale: string);
    ngOnInit(): void;
    writeValue(val: string): void;
    registerOnTouched(fn: any): void;
    registerOnChange(fn: any): void;
    setDisabledState(isDisabled: boolean): void;
    changeHour(hour: number): void;
    changeMinute(minute: number): void;
    changePeriod(period: TimePeriod): void;
    onTimeSet(time: string): void;
    ngOnDestroy(): void;
    private changeTime;
    private resetTime;
    private emitLocalTimeChange;
    private changeDefaultTimeValue;
    private updateAvailableHours;
    private updateAvailableMinutes;
    private updateAvailableTime;
    private updateTime;
    private initTime;
    private isPeriodDisabled;
    static ɵfac: i0.ɵɵFactoryDeclaration<NgxTimepickerFieldComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<NgxTimepickerFieldComponent, "ngx-timepicker-field", never, { "disabled": "disabled"; "toggleIcon": "toggleIcon"; "buttonAlign": "buttonAlign"; "clockTheme": "clockTheme"; "controlOnly": "controlOnly"; "cancelBtnTmpl": "cancelBtnTmpl"; "confirmBtnTmpl": "confirmBtnTmpl"; "format": "format"; "min": "min"; "max": "max"; "defaultTime": "defaultTime"; "minutesGap": "minutesGap"; }, { "timeChanged": "timeChanged"; }, never, never>;
}
