import { EventEmitter, OnChanges, SimpleChanges, TemplateRef } from '@angular/core';
import { DateTime } from 'luxon';
import { ClockFaceTime } from '../../models/clock-face-time.interface';
import { TimePeriod } from '../../models/time-period.enum';
import { TimeUnit } from '../../models/time-unit.enum';
import * as i0 from "@angular/core";
export declare class NgxMaterialTimepickerDialComponent implements OnChanges {
    private locale;
    timeUnit: typeof TimeUnit;
    hours: ClockFaceTime[];
    minutes: ClockFaceTime[];
    meridiems: string[];
    isHintVisible: boolean;
    editableHintTmpl: TemplateRef<Node>;
    hour: number | string;
    minute: number | string;
    format: number;
    period: TimePeriod;
    activeTimeUnit: TimeUnit;
    minTime: DateTime;
    maxTime: DateTime;
    isEditable: boolean;
    minutesGap: number;
    hoursOnly: boolean;
    periodChanged: EventEmitter<TimePeriod>;
    timeUnitChanged: EventEmitter<TimeUnit>;
    hourChanged: EventEmitter<ClockFaceTime>;
    minuteChanged: EventEmitter<ClockFaceTime>;
    constructor(locale: string);
    ngOnChanges(changes: SimpleChanges): void;
    changeTimeUnit(unit: TimeUnit): void;
    changePeriod(period: TimePeriod): void;
    changeHour(hour: ClockFaceTime): void;
    changeMinute(minute: ClockFaceTime): void;
    showHint(): void;
    hideHint(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<NgxMaterialTimepickerDialComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<NgxMaterialTimepickerDialComponent, "ngx-material-timepicker-dial", never, { "editableHintTmpl": "editableHintTmpl"; "hour": "hour"; "minute": "minute"; "format": "format"; "period": "period"; "activeTimeUnit": "activeTimeUnit"; "minTime": "minTime"; "maxTime": "maxTime"; "isEditable": "isEditable"; "minutesGap": "minutesGap"; "hoursOnly": "hoursOnly"; }, { "periodChanged": "periodChanged"; "timeUnitChanged": "timeUnitChanged"; "hourChanged": "hourChanged"; "minuteChanged": "minuteChanged"; }, never, never>;
}
