import { ElementRef, EventEmitter, OnInit } from '@angular/core';
import { FormControl } from '@angular/forms';
import { ClockFaceTime } from '../../models/clock-face-time.interface';
import { TimeUnit } from '../../models/time-unit.enum';
import { TimeLocalizerPipe } from '../../pipes/time-localizer.pipe';
import { TimeParserPipe } from '../../pipes/time-parser.pipe';
import * as i0 from "@angular/core";
export declare class NgxMaterialTimepickerDialControlComponent implements OnInit {
    private timeParserPipe;
    private timeLocalizerPipe;
    previousTime: number | string;
    timeList: ClockFaceTime[];
    timeUnit: TimeUnit;
    time: string;
    isActive: boolean;
    isEditable: boolean;
    minutesGap: number;
    disabled: boolean;
    editableTimeTmpl: ElementRef<HTMLInputElement>;
    timeUnitChanged: EventEmitter<TimeUnit>;
    timeChanged: EventEmitter<ClockFaceTime>;
    focused: EventEmitter<null>;
    unfocused: EventEmitter<null>;
    timeControl: FormControl;
    constructor(timeParserPipe: TimeParserPipe, timeLocalizerPipe: TimeLocalizerPipe);
    private get selectedTime();
    ngOnInit(): void;
    saveTimeAndChangeTimeUnit(event: FocusEvent, unit: TimeUnit): void;
    updateTime(): void;
    onKeydown(e: any): void;
    private changeTimeByArrow;
    private formatTimeForUI;
    private updateInputValue;
    static ɵfac: i0.ɵɵFactoryDeclaration<NgxMaterialTimepickerDialControlComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<NgxMaterialTimepickerDialControlComponent, "ngx-material-timepicker-dial-control", never, { "timeList": "timeList"; "timeUnit": "timeUnit"; "time": "time"; "isActive": "isActive"; "isEditable": "isEditable"; "minutesGap": "minutesGap"; "disabled": "disabled"; }, { "timeUnitChanged": "timeUnitChanged"; "timeChanged": "timeChanged"; "focused": "focused"; "unfocused": "unfocused"; }, never, never>;
}
