export function isSameOrAfter(time, compareWith, unit = 'minutes') {
    if (unit === 'hours') {
        return time.hour >= compareWith.hour;
    }
    if (unit === 'minutes') {
        return time.hasSame(compareWith, unit) || time.valueOf() > compareWith.valueOf();
    }
}
export function isSameOrBefore(time, compareWith, unit = 'minutes') {
    if (unit === 'hours') {
        return time.hour <= compareWith.hour;
    }
    if (unit === 'minutes') {
        return time.hasSame(compareWith, unit) || time.valueOf() <= compareWith.valueOf();
    }
}
export function isBetween(time, before, after, unit = 'minutes') {
    if (unit === 'hours') {
        return isSameOrBefore(time, after, unit) && isSameOrAfter(time, before, unit);
    }
    if (unit === 'minutes') {
        return isSameOrBefore(time, after) && isSameOrAfter(time, before);
    }
}
export function isDigit(e) {
    // Allow: backspace, delete, tab, escape, enter
    if ([46, 8, 9, 27, 13].some(n => n === e.keyCode) ||
        // Allow: Ctrl/cmd+A
        (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
        // Allow: Ctrl/cmd+C
        (e.keyCode == 67 && (e.ctrlKey === true || e.metaKey === true)) ||
        // Allow: Ctrl/cmd+X
        (e.keyCode == 88 && (e.ctrlKey === true || e.metaKey === true)) ||
        // Allow: home, end, left, right, up, down
        (e.keyCode >= 35 && e.keyCode <= 40)) {
        return true;
    }
    return !((e.keyCode < 48 || e.keyCode > 57) && (e.keyCode < 96 || e.keyCode > 105));
}
//# sourceMappingURL=data:application/json;base64,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