import { TimeAdapter } from '../services/time-adapter';
import { TimeFormat } from '../models/time-format.enum';
import { DateTime } from 'luxon';
// @dynamic
export class TimepickerTimeUtils {
    static getHours(format) {
        return Array(format).fill(1).map((v, i) => {
            const angleStep = 30;
            const time = v + i;
            const angle = angleStep * time;
            return { time: time === 24 ? 0 : time, angle };
        });
    }
    static disableHours(hours, config) {
        if (config.min || config.max) {
            return hours.map(value => {
                const hour = config.format === 24 ? value.time : TimeAdapter.formatHour(value.time, config.format, config.period);
                const currentTime = DateTime.fromObject({ hour }).toFormat(TimeFormat.TWELVE);
                return Object.assign(Object.assign({}, value), { disabled: !TimeAdapter.isTimeAvailable(currentTime, config.min, config.max, 'hours') });
            });
        }
        return hours;
    }
    static getMinutes(gap = 1) {
        const minutesCount = 60;
        const angleStep = 360 / minutesCount;
        const minutes = [];
        for (let i = 0; i < minutesCount; i++) {
            const angle = angleStep * i;
            if (i % gap === 0) {
                minutes.push({ time: i, angle: angle !== 0 ? angle : 360 });
            }
        }
        return minutes;
    }
    static disableMinutes(minutes, selectedHour, config) {
        if (config.min || config.max) {
            const hour = TimeAdapter.formatHour(selectedHour, config.format, config.period);
            return minutes.map(value => {
                const currentTime = DateTime.fromObject({ hour, minute: value.time }).toFormat(TimeFormat.TWELVE);
                return Object.assign(Object.assign({}, value), { disabled: !TimeAdapter.isTimeAvailable(currentTime, config.min, config.max, 'minutes') });
            });
        }
        return minutes;
    }
}
//# sourceMappingURL=data:application/json;base64,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