import { Inject, Injectable, Pipe } from '@angular/core';
import { NUMBERING_SYSTEM, TIME_LOCALE } from '../tokens/time-locale.token';
import { TimeUnit } from '../models/time-unit.enum';
import { DateTime } from 'luxon';
import * as i0 from "@angular/core";
export class TimeParserPipe {
    constructor(locale, numberingSystem) {
        this.locale = locale;
        this.numberingSystem = numberingSystem;
    }
    transform(time, timeUnit = TimeUnit.HOUR) {
        if (time == null || time === '') {
            return '';
        }
        if (!isNaN(+time)) {
            return time;
        }
        if (timeUnit === TimeUnit.MINUTE) {
            return this.parseTime(time, 'm', 'minute');
        }
        return this.parseTime(time, 'H', 'hour');
    }
    parseTime(time, format, timeMeasure) {
        const parsedTime = DateTime.fromFormat(String(time), format, {
            numberingSystem: this.numberingSystem,
            locale: this.locale
        })[timeMeasure];
        if (!isNaN(parsedTime)) {
            return parsedTime;
        }
        throw new Error(`Cannot parse time - ${time}`);
    }
}
TimeParserPipe.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: TimeParserPipe, deps: [{ token: TIME_LOCALE }, { token: NUMBERING_SYSTEM }], target: i0.ɵɵFactoryTarget.Pipe });
TimeParserPipe.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: TimeParserPipe, name: "timeParser" });
TimeParserPipe.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: TimeParserPipe });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: TimeParserPipe, decorators: [{
            type: Pipe,
            args: [{
                    name: 'timeParser'
                }]
        }, {
            type: Injectable
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [TIME_LOCALE]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [NUMBERING_SYSTEM]
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,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