import { Inject, Pipe } from '@angular/core';
import { TIME_LOCALE } from '../tokens/time-locale.token';
import { TimeUnit } from '../models/time-unit.enum';
import { DateTime } from 'luxon';
import * as i0 from "@angular/core";
export class TimeLocalizerPipe {
    constructor(locale) {
        this.locale = locale;
    }
    transform(time, timeUnit, isKeyboardEnabled = false) {
        if (time == null || time === '') {
            return '';
        }
        switch (timeUnit) {
            case TimeUnit.HOUR: {
                const format = (time === 0 || isKeyboardEnabled) ? 'HH' : 'H';
                return this.formatTime('hour', time, format);
            }
            case TimeUnit.MINUTE:
                return this.formatTime('minute', time, 'mm');
            default:
                throw new Error(`There is no Time Unit with type ${timeUnit}`);
        }
    }
    formatTime(timeMeasure, time, format) {
        try {
            return DateTime.fromObject({ [timeMeasure]: +time }).setLocale(this.locale).toFormat(format);
        }
        catch (_a) {
            throw new Error(`Cannot format provided time - ${time} to locale - ${this.locale}`);
        }
    }
}
TimeLocalizerPipe.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: TimeLocalizerPipe, deps: [{ token: TIME_LOCALE }], target: i0.ɵɵFactoryTarget.Pipe });
TimeLocalizerPipe.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: TimeLocalizerPipe, name: "timeLocalizer" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: TimeLocalizerPipe, decorators: [{
            type: Pipe,
            args: [{
                    name: 'timeLocalizer'
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [TIME_LOCALE]
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,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