import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { NgxMaterialTimepickerComponent } from './ngx-material-timepicker.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { NgxMaterialTimepickerToggleComponent } from './components/timepicker-toggle-button/ngx-material-timepicker-toggle.component';
import { TimepickerDirective } from './directives/ngx-timepicker.directive';
import { NgxMaterialTimepickerToggleIconDirective } from './directives/ngx-material-timepicker-toggle-icon.directive';
import { NgxMaterialTimepickerThemeDirective } from './directives/ngx-material-timepicker-theme.directive';
import { NgxMaterialTimepicker24HoursFaceComponent } from './components/timepicker-24-hours-face/ngx-material-timepicker-24-hours-face.component';
import { NgxMaterialTimepicker12HoursFaceComponent } from './components/timepicker-12-hours-face/ngx-material-timepicker-12-hours-face.component';
import { NgxMaterialTimepickerMinutesFaceComponent } from './components/timepicker-minutes-face/ngx-material-timepicker-minutes-face.component';
import { NgxMaterialTimepickerFaceComponent } from './components/timepicker-face/ngx-material-timepicker-face.component';
import { NgxMaterialTimepickerButtonComponent } from './components/timepicker-button/ngx-material-timepicker-button.component';
import { NgxMaterialTimepickerDialComponent } from './components/timepicker-dial/ngx-material-timepicker-dial.component';
import { NgxMaterialTimepickerDialControlComponent } from './components/timepicker-dial-control/ngx-material-timepicker-dial-control.component';
import { NgxMaterialTimepickerPeriodComponent } from './components/timepicker-period/ngx-material-timepicker-period.component';
import { TimeFormatterPipe } from './pipes/time-formatter.pipe';
import { OverlayDirective } from './directives/overlay.directive';
import { MinutesFormatterPipe } from './pipes/minutes-formatter.pipe';
import { AutofocusDirective } from './directives/autofocus.directive';
import { NgxTimepickerFieldComponent } from './components/timepicker-field/ngx-timepicker-field.component';
import { NgxTimepickerTimeControlComponent } from './components/timepicker-field/timepicker-time-control/ngx-timepicker-time-control.component';
import { NgxTimepickerPeriodSelectorComponent } from './components/timepicker-field/timepicker-period-selector/ngx-timepicker-period-selector.component';
import { TimeLocalizerPipe } from './pipes/time-localizer.pipe';
import { TimeAdapter } from './services/time-adapter';
import { NUMBERING_SYSTEM, TIME_LOCALE } from './tokens/time-locale.token';
import { TimeParserPipe } from './pipes/time-parser.pipe';
import { ActiveHourPipe } from './pipes/active-hour.pipe';
import { ActiveMinutePipe } from './pipes/active-minute.pipe';
import { NgxMaterialTimepickerContainerComponent } from './components/ngx-material-timepicker-container/ngx-material-timepicker-container.component';
import { NgxMaterialTimepickerContentComponent } from './components/ngx-material-timepicker-content/ngx-material-timepicker-content.component';
import { AppendToInputDirective } from './directives/append-to-input.directive';
import * as i0 from "@angular/core";
export class NgxMaterialTimepickerModule {
    // tslint:disable-next-line:max-line-length
    static setOpts(locale, numberingSystem = TimeAdapter.DEFAULT_NUMBERING_SYSTEM) {
        return {
            ngModule: NgxMaterialTimepickerModule,
            providers: [
                { provide: TIME_LOCALE, useValue: locale },
                { provide: NUMBERING_SYSTEM, useValue: numberingSystem }
            ]
        };
    }
}
NgxMaterialTimepickerModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: NgxMaterialTimepickerModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
NgxMaterialTimepickerModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: NgxMaterialTimepickerModule, declarations: [NgxMaterialTimepickerComponent,
        NgxMaterialTimepicker24HoursFaceComponent,
        NgxMaterialTimepicker12HoursFaceComponent,
        NgxMaterialTimepickerMinutesFaceComponent,
        NgxMaterialTimepickerFaceComponent,
        NgxMaterialTimepickerToggleComponent,
        NgxMaterialTimepickerButtonComponent,
        NgxMaterialTimepickerDialComponent,
        NgxMaterialTimepickerDialControlComponent,
        NgxMaterialTimepickerPeriodComponent,
        TimeFormatterPipe,
        TimepickerDirective,
        OverlayDirective,
        NgxMaterialTimepickerToggleIconDirective,
        AutofocusDirective,
        MinutesFormatterPipe,
        NgxMaterialTimepickerThemeDirective,
        NgxTimepickerFieldComponent,
        NgxTimepickerTimeControlComponent,
        NgxTimepickerPeriodSelectorComponent,
        TimeLocalizerPipe,
        TimeParserPipe,
        ActiveHourPipe,
        ActiveMinutePipe,
        NgxMaterialTimepickerContainerComponent,
        NgxMaterialTimepickerContentComponent,
        AppendToInputDirective], imports: [CommonModule,
        FormsModule,
        ReactiveFormsModule], exports: [NgxMaterialTimepickerComponent,
        NgxMaterialTimepickerToggleComponent,
        NgxTimepickerFieldComponent,
        TimepickerDirective,
        NgxMaterialTimepickerToggleIconDirective,
        NgxMaterialTimepickerThemeDirective] });
NgxMaterialTimepickerModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: NgxMaterialTimepickerModule, imports: [[
            CommonModule,
            FormsModule,
            ReactiveFormsModule,
        ]] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: NgxMaterialTimepickerModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [
                        CommonModule,
                        FormsModule,
                        ReactiveFormsModule,
                    ],
                    exports: [
                        NgxMaterialTimepickerComponent,
                        NgxMaterialTimepickerToggleComponent,
                        NgxTimepickerFieldComponent,
                        TimepickerDirective,
                        NgxMaterialTimepickerToggleIconDirective,
                        NgxMaterialTimepickerThemeDirective,
                    ],
                    declarations: [
                        NgxMaterialTimepickerComponent,
                        NgxMaterialTimepicker24HoursFaceComponent,
                        NgxMaterialTimepicker12HoursFaceComponent,
                        NgxMaterialTimepickerMinutesFaceComponent,
                        NgxMaterialTimepickerFaceComponent,
                        NgxMaterialTimepickerToggleComponent,
                        NgxMaterialTimepickerButtonComponent,
                        NgxMaterialTimepickerDialComponent,
                        NgxMaterialTimepickerDialControlComponent,
                        NgxMaterialTimepickerPeriodComponent,
                        TimeFormatterPipe,
                        TimepickerDirective,
                        OverlayDirective,
                        NgxMaterialTimepickerToggleIconDirective,
                        AutofocusDirective,
                        MinutesFormatterPipe,
                        NgxMaterialTimepickerThemeDirective,
                        NgxTimepickerFieldComponent,
                        NgxTimepickerTimeControlComponent,
                        NgxTimepickerPeriodSelectorComponent,
                        TimeLocalizerPipe,
                        TimeParserPipe,
                        ActiveHourPipe,
                        ActiveMinutePipe,
                        NgxMaterialTimepickerContainerComponent,
                        NgxMaterialTimepickerContentComponent,
                        AppendToInputDirective
                    ],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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