import { Directive, HostListener, Input } from '@angular/core';
import * as i0 from "@angular/core";
export class AppendToInputDirective {
    constructor(elementRef, renderer) {
        this.renderer = renderer;
        this.element = elementRef.nativeElement;
    }
    get inputCords() {
        return this.inputElement.getBoundingClientRect();
    }
    get direction() {
        const height = this.element.offsetHeight;
        const { bottom, top } = this._inputCords;
        const isElementFit = (window && window.innerHeight) - bottom < height;
        const isTop = isElementFit && top > height;
        const isCenter = isElementFit && top < height;
        if (isTop) {
            return 'top';
        }
        else if (isCenter) {
            return 'center';
        }
        return 'bottom';
    }
    ngAfterViewInit() {
        this._inputCords = this.inputCords;
        this._direction = this.direction;
        this.append();
    }
    changePosition() {
        const { bottom, top } = this.inputCords;
        const y = this.defineElementYByDirection(top, bottom);
        this.setStyle('top', `${y}px`);
    }
    append() {
        const { left, bottom, top } = this._inputCords;
        const y = this.defineElementYByDirection(top, bottom);
        this.setStyle('position', 'fixed');
        this.setStyle('left', `${left}px`);
        this.setStyle('top', `${y}px`);
    }
    setStyle(style, value) {
        this.renderer.setStyle(this.element, style, value);
    }
    defineElementYByDirection(inputTop, inputBottom) {
        if (this._direction === 'top') {
            return inputTop - this.element.offsetHeight;
        }
        else if (this._direction === 'center') {
            return inputTop - (this.element.offsetHeight / 2);
        }
        return inputBottom;
    }
}
AppendToInputDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: AppendToInputDirective, deps: [{ token: i0.ElementRef }, { token: i0.Renderer2 }], target: i0.ɵɵFactoryTarget.Directive });
AppendToInputDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: AppendToInputDirective, selector: "[ngxAppendToInput]", inputs: { inputElement: ["ngxAppendToInput", "inputElement"] }, host: { listeners: { "window:scroll": "changePosition()" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: AppendToInputDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[ngxAppendToInput]'
                }]
        }], ctorParameters: function () { return [{ type: i0.ElementRef }, { type: i0.Renderer2 }]; }, propDecorators: { inputElement: [{
                type: Input,
                args: ['ngxAppendToInput']
            }], changePosition: [{
                type: HostListener,
                args: ['window:scroll']
            }] } });
//# sourceMappingURL=data:application/json;base64,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