import { ChangeDetectionStrategy, Component, EventEmitter, Inject, Input, Output } from '@angular/core';
import { TimePeriod } from '../../../models/time-period.enum';
import { animate, style, transition, trigger } from '@angular/animations';
import { TIME_LOCALE } from '../../../tokens/time-locale.token';
import { Info } from 'luxon';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "../../../directives/autofocus.directive";
export class NgxTimepickerPeriodSelectorComponent {
    constructor(locale) {
        this.locale = locale;
        this.periodSelected = new EventEmitter();
        this.period = TimePeriod;
        this.meridiems = Info.meridiems({ locale: this.locale });
    }
    set selectedPeriod(period) {
        if (period) {
            const periods = [TimePeriod.AM, TimePeriod.PM];
            this.localizedPeriod = this.meridiems[periods.indexOf(period)];
        }
    }
    open() {
        if (!this.disabled) {
            this.isOpened = true;
        }
    }
    select(period) {
        this.periodSelected.next(period);
        this.isOpened = false;
    }
    backdropClick() {
        this.isOpened = false;
    }
}
NgxTimepickerPeriodSelectorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: NgxTimepickerPeriodSelectorComponent, deps: [{ token: TIME_LOCALE }], target: i0.ɵɵFactoryTarget.Component });
NgxTimepickerPeriodSelectorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxTimepickerPeriodSelectorComponent, selector: "ngx-timepicker-period-selector", inputs: { isOpened: "isOpened", disabled: "disabled", selectedPeriod: "selectedPeriod" }, outputs: { periodSelected: "periodSelected" }, ngImport: i0, template: "<div class=\"period\">\n    <div class=\"period-control\">\n        <button class=\"period-control__button period__btn--default\"\n                [ngClass]=\"{'period-control__button--disabled': disabled}\"\n                type=\"button\"\n                (click)=\"open()\">\n            <span>{{localizedPeriod}}</span>\n            <span class=\"period-control__arrow\">&#9660;</span>\n        </button>\n    </div>\n    <ul class=\"period-selector\" @scaleInOut *ngIf=\"isOpened\" [timepickerAutofocus]=\"true\">\n        <li>\n            <button class=\"period-selector__button period__btn--default\"\n                    type=\"button\"\n                    (click)=\"select(period.AM)\"\n                    [ngClass]=\"{'period-selector__button--active': localizedPeriod === meridiems[0]}\">{{meridiems[0]}}</button>\n        </li>\n        <li>\n            <button class=\"period-selector__button period__btn--default\"\n                    type=\"button\"\n                    (click)=\"select(period.PM)\"\n                    [ngClass]=\"{'period-selector__button--active': localizedPeriod === meridiems[1]}\">{{meridiems[1]}}</button>\n        </li>\n    </ul>\n</div>\n<div class=\"overlay\" (click)=\"backdropClick()\" *ngIf=\"isOpened\"></div>\n", styles: [".period{position:relative}.period__btn--default{padding:0;border:none;background-color:transparent;cursor:pointer;text-align:left;-webkit-user-select:none;-moz-user-select:none;user-select:none;-webkit-tap-highlight-color:transparent;outline:none}.period-control{position:relative}.period-control__button{position:relative;width:60px;font-size:1rem;color:inherit;text-align:center}.period-control__button:not(.period-control__button--disabled):focus:after{content:\"\";position:absolute;bottom:-8px;left:0;width:100%;height:1px;background-color:#00bfff}.period-control__arrow{margin-left:10px;font-size:12px;color:#0006}.period-selector{position:absolute;top:calc(50% - 50px);right:calc(-50% + -50px);max-width:135px;width:150px;padding:6px 0;margin:0;list-style:none;background-color:#f5f5f5;box-shadow:0 1px 3px #0003,0 1px 1px #00000024,0 2px 1px -1px #0000001f;z-index:201}.period-selector__button{width:100%;height:48px;padding:0 16px;line-height:48px}.period-selector__button--active{color:#00bfff}.period-selector__button:focus{background-color:#eee}.overlay{position:fixed;width:100%;height:100%;top:0;left:0;background-color:transparent;z-index:200}\n"], directives: [{ type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: i2.AutofocusDirective, selector: "[timepickerAutofocus]", inputs: ["timepickerAutofocus"] }], animations: [
        trigger('scaleInOut', [
            transition(':enter', [
                style({ transform: 'scale(0)', opacity: 0 }),
                animate(200, style({ transform: 'scale(1)', opacity: 1 }))
            ]),
            transition(':leave', [
                animate(200, style({ transform: 'scale(0)', opacity: 0 }))
            ])
        ])
    ], changeDetection: i0.ChangeDetectionStrategy.OnPush });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: NgxTimepickerPeriodSelectorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'ngx-timepicker-period-selector',
                    templateUrl: 'ngx-timepicker-period-selector.component.html',
                    styleUrls: ['./ngx-timepicker-period-selector.component.scss'],
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    animations: [
                        trigger('scaleInOut', [
                            transition(':enter', [
                                style({ transform: 'scale(0)', opacity: 0 }),
                                animate(200, style({ transform: 'scale(1)', opacity: 1 }))
                            ]),
                            transition(':leave', [
                                animate(200, style({ transform: 'scale(0)', opacity: 0 }))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [TIME_LOCALE]
                }] }]; }, propDecorators: { isOpened: [{
                type: Input
            }], disabled: [{
                type: Input
            }], selectedPeriod: [{
                type: Input
            }], periodSelected: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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