/* tslint:disable:triple-equals */
import { Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { FormControl } from '@angular/forms';
import { debounceTime, distinctUntilChanged, filter, tap } from 'rxjs/operators';
import { TimeLocalizerPipe } from '../../pipes/time-localizer.pipe';
import { TimeParserPipe } from '../../pipes/time-parser.pipe';
import { isDigit } from '../../utils/timepicker.utils';
import * as i0 from "@angular/core";
import * as i1 from "../../pipes/time-parser.pipe";
import * as i2 from "../../pipes/time-localizer.pipe";
import * as i3 from "@angular/common";
import * as i4 from "@angular/forms";
import * as i5 from "../../directives/autofocus.directive";
export class NgxMaterialTimepickerDialControlComponent {
    constructor(timeParserPipe, timeLocalizerPipe) {
        this.timeParserPipe = timeParserPipe;
        this.timeLocalizerPipe = timeLocalizerPipe;
        this.timeUnitChanged = new EventEmitter();
        this.timeChanged = new EventEmitter();
        this.focused = new EventEmitter();
        this.unfocused = new EventEmitter();
    }
    get selectedTime() {
        if (!!this.time) {
            return this.timeList.find(t => t.time === +this.time);
        }
    }
    ngOnInit() {
        if (this.isEditable) {
            this.timeControl = new FormControl({ value: this.formatTimeForUI(this.time), disabled: this.disabled });
            this.timeControl.valueChanges.pipe(tap((value) => {
                if (value.length > 2) {
                    this.updateInputValue(value.slice(-1));
                }
            }), debounceTime(500), distinctUntilChanged(), filter((value) => !isTimeDisabledToChange(this.time, value, this.timeList)), tap((value) => this.time = this.timeParserPipe.transform(value, this.timeUnit).toString())).subscribe(() => this.updateTime());
        }
    }
    saveTimeAndChangeTimeUnit(event, unit) {
        event.preventDefault();
        this.previousTime = this.time;
        this.timeUnitChanged.next(unit);
        this.focused.next();
    }
    updateTime() {
        const time = this.selectedTime;
        if (time) {
            this.timeChanged.next(time);
            this.previousTime = time.time;
            if (this.isEditable) {
                this.updateInputValue(this.formatTimeForUI(time.time));
            }
        }
    }
    onKeydown(e) {
        if (!isDigit(e)) {
            e.preventDefault();
        }
        else {
            this.changeTimeByArrow(e.keyCode);
        }
    }
    changeTimeByArrow(keyCode) {
        const ARROW_UP = 38;
        const ARROW_DOWN = 40;
        let time;
        if (keyCode === ARROW_UP) {
            time = String(+this.time + (this.minutesGap || 1));
        }
        else if (keyCode === ARROW_DOWN) {
            time = String(+this.time - (this.minutesGap || 1));
        }
        if (!isTimeUnavailable(time, this.timeList)) {
            this.time = time;
            this.updateTime();
        }
    }
    formatTimeForUI(value) {
        const parsedTime = this.timeParserPipe.transform(value, this.timeUnit).toString();
        return this.timeLocalizerPipe.transform(parsedTime, this.timeUnit, true);
    }
    updateInputValue(value) {
        this.editableTimeTmpl.nativeElement.value = value;
    }
}
NgxMaterialTimepickerDialControlComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: NgxMaterialTimepickerDialControlComponent, deps: [{ token: i1.TimeParserPipe }, { token: i2.TimeLocalizerPipe }], target: i0.ɵɵFactoryTarget.Component });
NgxMaterialTimepickerDialControlComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerDialControlComponent, selector: "ngx-material-timepicker-dial-control", inputs: { timeList: "timeList", timeUnit: "timeUnit", time: "time", isActive: "isActive", isEditable: "isEditable", minutesGap: "minutesGap", disabled: "disabled" }, outputs: { timeUnitChanged: "timeUnitChanged", timeChanged: "timeChanged", focused: "focused", unfocused: "unfocused" }, providers: [TimeParserPipe, TimeLocalizerPipe], viewQueries: [{ propertyName: "editableTimeTmpl", first: true, predicate: ["editableTimeTmpl"], descendants: true }], ngImport: i0, template: "<!--suppress HtmlFormInputWithoutLabel, HtmlUnknownAttribute -->\n<input class=\"timepicker-dial__control timepicker-dial__item\"\n       [ngClass]=\"{'timepicker-dial__item_active': isActive}\"\n       [ngModel]=\"time | timeLocalizer: timeUnit\"\n       (ngModelChange)=\"time = $event\"\n       [disabled]=\"disabled\"\n       (input)=\"updateTime()\" (focus)=\"saveTimeAndChangeTimeUnit($event, timeUnit)\"\n       readonly [timepickerAutofocus]=\"isActive\"\n       *ngIf=\"!isEditable;else editableTemplate\">\n\n<ng-template #editableTemplate>\n    <!--suppress HtmlFormInputWithoutLabel, HtmlUnknownAttribute -->\n    <input class=\"timepicker-dial__control timepicker-dial__item timepicker-dial__control_editable\"\n           #editableTimeTmpl\n           [formControl]=\"timeControl\"\n           [ngClass]=\"{'timepicker-dial__item_active': isActive}\"\n           [timepickerAutofocus]=\"isActive\"\n           (focus)=\"saveTimeAndChangeTimeUnit($event, timeUnit)\"\n           (keydown)=\"onKeydown($event)\">\n</ng-template>\n", styles: [".timepicker-dial__item{cursor:pointer;color:#ffffff80;font-family:\"Roboto\",sans-serif}@supports (font-family: var(--primary-font-family)){.timepicker-dial__item{font-family:var(--primary-font-family);color:var(--dial-inactive-color)}}.timepicker-dial__item_active{color:#fff}@supports (color: var(--dial-active-color)){.timepicker-dial__item_active{color:var(--dial-active-color)}}.timepicker-dial__control{border:none;background-color:transparent;font-size:50px;width:60px;padding:0;border-radius:3px;text-align:right}.timepicker-dial__control_editable:focus{color:#00bfff;background-color:#fff;outline:deepskyblue}@supports (color: var(--dial-editable-active-color)){.timepicker-dial__control_editable:focus{color:var(--dial-editable-active-color)}}@supports (background-color: var(--dial-editable-background-color)){.timepicker-dial__control_editable:focus{background-color:var(--dial-editable-background-color)}}@supports (outline: var(--dial-editable-active-color)){.timepicker-dial__control_editable:focus{outline:var(--dial-editable-active-color)}}.timepicker-dial__control:disabled{cursor:default}.timepicker-dial__control:focus-visible{outline:none}\n"], directives: [{ type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { type: i3.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { type: i5.AutofocusDirective, selector: "[timepickerAutofocus]", inputs: ["timepickerAutofocus"] }, { type: i4.FormControlDirective, selector: "[formControl]", inputs: ["disabled", "formControl", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }], pipes: { "timeLocalizer": i2.TimeLocalizerPipe } });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: NgxMaterialTimepickerDialControlComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'ngx-material-timepicker-dial-control',
                    templateUrl: 'ngx-material-timepicker-dial-control.component.html',
                    styleUrls: ['ngx-material-timepicker-dial-control.component.scss'],
                    providers: [TimeParserPipe, TimeLocalizerPipe],
                }]
        }], ctorParameters: function () { return [{ type: i1.TimeParserPipe }, { type: i2.TimeLocalizerPipe }]; }, propDecorators: { timeList: [{
                type: Input
            }], timeUnit: [{
                type: Input
            }], time: [{
                type: Input
            }], isActive: [{
                type: Input
            }], isEditable: [{
                type: Input
            }], minutesGap: [{
                type: Input
            }], disabled: [{
                type: Input
            }], editableTimeTmpl: [{
                type: ViewChild,
                args: ['editableTimeTmpl']
            }], timeUnitChanged: [{
                type: Output
            }], timeChanged: [{
                type: Output
            }], focused: [{
                type: Output
            }], unfocused: [{
                type: Output
            }] } });
function isTimeDisabledToChange(currentTime, nextTime, timeList) {
    const isNumber = /\d/.test(nextTime);
    if (isNumber) {
        return isTimeUnavailable(nextTime, timeList);
    }
}
function isTimeUnavailable(time, timeList) {
    const selectedTime = timeList.find(value => value.time === +time);
    return !selectedTime || (selectedTime && selectedTime.disabled);
}
//# sourceMappingURL=data:application/json;base64,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