(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/common'), require('rxjs'), require('rxjs/operators'), require('@angular/animations'), require('luxon'), require('@angular/forms')) :
    typeof define === 'function' && define.amd ? define('ngx-material-timepicker', ['exports', '@angular/core', '@angular/common', 'rxjs', 'rxjs/operators', '@angular/animations', 'luxon', '@angular/forms'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global["ngx-material-timepicker"] = {}, global.ng.core, global.ng.common, global.rxjs, global.rxjs.operators, global.ng.animations, global.luxon, global.ng.forms));
})(this, (function (exports, i0, i1, rxjs, operators, animations, luxon, i4) { 'use strict';

    function _interopNamespace(e) {
        if (e && e.__esModule) return e;
        var n = Object.create(null);
        if (e) {
            Object.keys(e).forEach(function (k) {
                if (k !== 'default') {
                    var d = Object.getOwnPropertyDescriptor(e, k);
                    Object.defineProperty(n, k, d.get ? d : {
                        enumerable: true,
                        get: function () { return e[k]; }
                    });
                }
            });
        }
        n["default"] = e;
        return Object.freeze(n);
    }

    var i0__namespace = /*#__PURE__*/_interopNamespace(i0);
    var i1__namespace = /*#__PURE__*/_interopNamespace(i1);
    var i4__namespace = /*#__PURE__*/_interopNamespace(i4);

    var TimeUnit;
    (function (TimeUnit) {
        TimeUnit[TimeUnit["HOUR"] = 0] = "HOUR";
        TimeUnit[TimeUnit["MINUTE"] = 1] = "MINUTE";
    })(TimeUnit || (TimeUnit = {}));

    var TimePeriod;
    (function (TimePeriod) {
        TimePeriod["AM"] = "AM";
        TimePeriod["PM"] = "PM";
    })(TimePeriod || (TimePeriod = {}));

    var TimeFormat;
    (function (TimeFormat) {
        TimeFormat["TWELVE"] = "hh:mm a";
        TimeFormat["TWELVE_SHORT"] = "h:m a";
        TimeFormat["TWENTY_FOUR"] = "HH:mm";
        TimeFormat["TWENTY_FOUR_SHORT"] = "H:m";
    })(TimeFormat || (TimeFormat = {}));

    function isSameOrAfter(time, compareWith, unit) {
        if (unit === void 0) { unit = 'minutes'; }
        if (unit === 'hours') {
            return time.hour >= compareWith.hour;
        }
        if (unit === 'minutes') {
            return time.hasSame(compareWith, unit) || time.valueOf() > compareWith.valueOf();
        }
    }
    function isSameOrBefore(time, compareWith, unit) {
        if (unit === void 0) { unit = 'minutes'; }
        if (unit === 'hours') {
            return time.hour <= compareWith.hour;
        }
        if (unit === 'minutes') {
            return time.hasSame(compareWith, unit) || time.valueOf() <= compareWith.valueOf();
        }
    }
    function isBetween(time, before, after, unit) {
        if (unit === void 0) { unit = 'minutes'; }
        if (unit === 'hours') {
            return isSameOrBefore(time, after, unit) && isSameOrAfter(time, before, unit);
        }
        if (unit === 'minutes') {
            return isSameOrBefore(time, after) && isSameOrAfter(time, before);
        }
    }
    function isDigit(e) {
        // Allow: backspace, delete, tab, escape, enter
        if ([46, 8, 9, 27, 13].some(function (n) { return n === e.keyCode; }) ||
            // Allow: Ctrl/cmd+A
            (e.keyCode == 65 && (e.ctrlKey === true || e.metaKey === true)) ||
            // Allow: Ctrl/cmd+C
            (e.keyCode == 67 && (e.ctrlKey === true || e.metaKey === true)) ||
            // Allow: Ctrl/cmd+X
            (e.keyCode == 88 && (e.ctrlKey === true || e.metaKey === true)) ||
            // Allow: home, end, left, right, up, down
            (e.keyCode >= 35 && e.keyCode <= 40)) {
            return true;
        }
        return !((e.keyCode < 48 || e.keyCode > 57) && (e.keyCode < 96 || e.keyCode > 105));
    }

    // @dynamic
    var TimeAdapter = /** @class */ (function () {
        function TimeAdapter() {
        }
        TimeAdapter.parseTime = function (time, opts) {
            var _a = TimeAdapter.getLocaleOptionsByTime(time, opts), numberingSystem = _a.numberingSystem, locale = _a.locale;
            var isPeriodExist = time.split(' ').length === 2;
            var timeMask = isPeriodExist ? TimeFormat.TWELVE_SHORT : TimeFormat.TWENTY_FOUR_SHORT;
            return luxon.DateTime.fromFormat(time, timeMask, { numberingSystem: numberingSystem, locale: locale });
        };
        TimeAdapter.formatTime = function (time, opts) {
            if (!time) {
                return 'Invalid Time';
            }
            var format = opts.format;
            var parsedTime = TimeAdapter.parseTime(time, opts).setLocale(TimeAdapter.DEFAULT_LOCALE);
            if (!parsedTime.isValid) {
                return null;
            }
            if (format !== 24) {
                return parsedTime.toLocaleString(Object.assign(Object.assign({}, luxon.DateTime.TIME_SIMPLE), { hour12: format !== 24, numberingSystem: TimeAdapter.DEFAULT_NUMBERING_SYSTEM })).replace(/\u200E/g, '').replace(/\u202F/g, ' ');
            }
            return parsedTime.toISOTime({
                includeOffset: false,
                suppressMilliseconds: true,
                suppressSeconds: true
            }).replace(/\u200E/g, '').replace(/\u202F/g, ' ');
        };
        TimeAdapter.toLocaleTimeString = function (time, opts) {
            if (opts === void 0) { opts = {}; }
            var _a = opts.format, format = _a === void 0 ? TimeAdapter.DEFAULT_FORMAT : _a, _b = opts.locale, locale = _b === void 0 ? TimeAdapter.DEFAULT_LOCALE : _b;
            var hourCycle = format === 24 ? 'h23' : 'h12';
            var timeFormat = Object.assign(Object.assign({}, luxon.DateTime.TIME_SIMPLE), { hourCycle: hourCycle });
            var timeMask = (format === 24) ? TimeFormat.TWENTY_FOUR_SHORT : TimeFormat.TWELVE_SHORT;
            var localOpts = Object.assign({ locale: opts.locale, numberingSystem: opts.numberingSystem }, timeFormat);
            return luxon.DateTime.fromFormat(time, timeMask).setLocale(locale).toLocaleString(localOpts).replace(/\u202F/g, ' ');
        };
        TimeAdapter.isTimeAvailable = function (time, min, max, granularity, minutesGap, format) {
            if (!time) {
                return;
            }
            var convertedTime = this.parseTime(time, { format: format });
            var minutes = convertedTime.minute;
            if (minutesGap && minutes === minutes && minutes % minutesGap !== 0) {
                throw new Error("Your minutes - " + minutes + " doesn't match your minutesGap - " + minutesGap);
            }
            var isAfter = (min && !max)
                && isSameOrAfter(convertedTime, min, granularity);
            var isBefore = (max && !min)
                && isSameOrBefore(convertedTime, max, granularity);
            var between = (min && max)
                && isBetween(convertedTime, min, max, granularity);
            var isAvailable = !min && !max;
            return isAfter || isBefore || between || isAvailable;
        };
        /***
         *  Format hour according to time format (12 or 24)
         */
        TimeAdapter.formatHour = function (currentHour, format, period) {
            if (format === 24) {
                return currentHour;
            }
            var hour = period === TimePeriod.AM ? currentHour : currentHour + 12;
            if (period === TimePeriod.AM && hour === 12) {
                return 0;
            }
            else if (period === TimePeriod.PM && hour === 24) {
                return 12;
            }
            return hour;
        };
        TimeAdapter.fromDateTimeToString = function (time, format) {
            var timeFormat = format === 24 ? TimeFormat.TWENTY_FOUR : TimeFormat.TWELVE;
            return time.reconfigure({
                numberingSystem: TimeAdapter.DEFAULT_NUMBERING_SYSTEM,
                locale: TimeAdapter.DEFAULT_LOCALE
            }).toFormat(timeFormat).replace(/\u202F/g, ' ');
        };
        TimeAdapter.getLocaleOptionsByTime = function (time, opts) {
            var localeConfig = { numberingSystem: opts.numberingSystem, locale: opts.locale };
            var defaultConfig = { numberingSystem: TimeAdapter.DEFAULT_NUMBERING_SYSTEM, locale: TimeAdapter.DEFAULT_LOCALE };
            return isNaN(parseInt(time, 10)) ? localeConfig : defaultConfig;
        };
        return TimeAdapter;
    }());
    TimeAdapter.DEFAULT_FORMAT = 12;
    TimeAdapter.DEFAULT_LOCALE = 'en-US';
    TimeAdapter.DEFAULT_NUMBERING_SYSTEM = 'latn';

    var DEFAULT_HOUR = {
        time: 12,
        angle: 360
    };
    var DEFAULT_MINUTE = {
        time: 0,
        angle: 360
    };
    var NgxMaterialTimepickerService = /** @class */ (function () {
        function NgxMaterialTimepickerService() {
            this.hourSubject = new rxjs.BehaviorSubject(DEFAULT_HOUR);
            this.minuteSubject = new rxjs.BehaviorSubject(DEFAULT_MINUTE);
            this.periodSubject = new rxjs.BehaviorSubject(TimePeriod.AM);
        }
        Object.defineProperty(NgxMaterialTimepickerService.prototype, "hour", {
            set: function (hour) {
                this.hourSubject.next(hour);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerService.prototype, "selectedHour", {
            get: function () {
                return this.hourSubject.asObservable();
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerService.prototype, "minute", {
            set: function (minute) {
                this.minuteSubject.next(minute);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerService.prototype, "selectedMinute", {
            get: function () {
                return this.minuteSubject.asObservable();
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerService.prototype, "period", {
            set: function (period) {
                var isPeriodValid = (period === TimePeriod.AM) || (period === TimePeriod.PM);
                if (isPeriodValid) {
                    this.periodSubject.next(period);
                }
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerService.prototype, "selectedPeriod", {
            get: function () {
                return this.periodSubject.asObservable();
            },
            enumerable: false,
            configurable: true
        });
        NgxMaterialTimepickerService.prototype.setDefaultTimeIfAvailable = function (time, min, max, format, minutesGap) {
            /* Workaround to double error message*/
            try {
                if (TimeAdapter.isTimeAvailable(time, min, max, 'minutes', minutesGap)) {
                    this.setDefaultTime(time, format);
                }
            }
            catch (e) {
                console.error(e);
            }
        };
        NgxMaterialTimepickerService.prototype.getFullTime = function (format) {
            var selectedHour = this.hourSubject.getValue().time;
            var selectedMinute = this.minuteSubject.getValue().time;
            var hour = selectedHour != null ? selectedHour : DEFAULT_HOUR.time;
            var minute = selectedMinute != null ? selectedMinute : DEFAULT_MINUTE.time;
            var period = format === 12 ? this.periodSubject.getValue() : '';
            var time = (hour + ":" + minute + " " + period).trim();
            return TimeAdapter.formatTime(time, { format: format });
        };
        NgxMaterialTimepickerService.prototype.setDefaultTime = function (time, format) {
            var defaultTime = TimeAdapter.parseTime(time, { format: format }).toJSDate();
            if (luxon.DateTime.fromJSDate(defaultTime).isValid) {
                var period = time.substr(time.length - 2).toUpperCase();
                var hour = defaultTime.getHours();
                this.hour = Object.assign(Object.assign({}, DEFAULT_HOUR), { time: formatHourByPeriod(hour, period) });
                this.minute = Object.assign(Object.assign({}, DEFAULT_MINUTE), { time: defaultTime.getMinutes() });
                this.period = period;
            }
            else {
                this.resetTime();
            }
        };
        NgxMaterialTimepickerService.prototype.resetTime = function () {
            this.hour = Object.assign({}, DEFAULT_HOUR);
            this.minute = Object.assign({}, DEFAULT_MINUTE);
            this.period = TimePeriod.AM;
        };
        return NgxMaterialTimepickerService;
    }());
    NgxMaterialTimepickerService.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerService, deps: [], target: i0__namespace.ɵɵFactoryTarget.Injectable });
    NgxMaterialTimepickerService.ɵprov = i0__namespace.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerService, providedIn: 'root' });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerService, decorators: [{
                type: i0.Injectable,
                args: [{
                        providedIn: 'root'
                    }]
            }] });
    /***
     *  Format hour in 24hours format to meridian (AM or PM) format
     */
    function formatHourByPeriod(hour, period) {
        switch (period) {
            case TimePeriod.AM:
                return hour === 0 ? 12 : hour;
            case TimePeriod.PM:
                return hour === 12 ? 12 : hour - 12;
            default:
                return hour;
        }
    }

    var TIME_LOCALE = new i0.InjectionToken('TimeLocale', {
        providedIn: 'root',
        factory: function () { return TimeAdapter.DEFAULT_LOCALE; }
    });
    var NUMBERING_SYSTEM = new i0.InjectionToken('NumberingSystem', {
        providedIn: 'root',
        factory: function () { return TimeAdapter.DEFAULT_NUMBERING_SYSTEM; }
    });

    var NgxMaterialTimepickerEventService = /** @class */ (function () {
        function NgxMaterialTimepickerEventService() {
            this.backdropClickSubject = new rxjs.Subject();
            this.keydownEventSubject = new rxjs.Subject();
        }
        Object.defineProperty(NgxMaterialTimepickerEventService.prototype, "backdropClick", {
            get: function () {
                return this.backdropClickSubject.asObservable().pipe(operators.shareReplay({ bufferSize: 1, refCount: true }));
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerEventService.prototype, "keydownEvent", {
            get: function () {
                return this.keydownEventSubject.asObservable().pipe(operators.shareReplay({ bufferSize: 1, refCount: true }));
            },
            enumerable: false,
            configurable: true
        });
        NgxMaterialTimepickerEventService.prototype.dispatchEvent = function (event) {
            switch (event.type) {
                case 'click':
                    this.backdropClickSubject.next(event);
                    break;
                case 'keydown':
                    this.keydownEventSubject.next(event);
                    break;
                default:
                    throw new Error('no such event type');
            }
        };
        return NgxMaterialTimepickerEventService;
    }());
    NgxMaterialTimepickerEventService.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerEventService, deps: [], target: i0__namespace.ɵɵFactoryTarget.Injectable });
    NgxMaterialTimepickerEventService.ɵprov = i0__namespace.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerEventService, providedIn: 'root' });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerEventService, decorators: [{
                type: i0.Injectable,
                args: [{
                        providedIn: 'root'
                    }]
            }] });

    var AppendToInputDirective = /** @class */ (function () {
        function AppendToInputDirective(elementRef, renderer) {
            this.renderer = renderer;
            this.element = elementRef.nativeElement;
        }
        Object.defineProperty(AppendToInputDirective.prototype, "inputCords", {
            get: function () {
                return this.inputElement.getBoundingClientRect();
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AppendToInputDirective.prototype, "direction", {
            get: function () {
                var height = this.element.offsetHeight;
                var _a = this._inputCords, bottom = _a.bottom, top = _a.top;
                var isElementFit = (window && window.innerHeight) - bottom < height;
                var isTop = isElementFit && top > height;
                var isCenter = isElementFit && top < height;
                if (isTop) {
                    return 'top';
                }
                else if (isCenter) {
                    return 'center';
                }
                return 'bottom';
            },
            enumerable: false,
            configurable: true
        });
        AppendToInputDirective.prototype.ngAfterViewInit = function () {
            this._inputCords = this.inputCords;
            this._direction = this.direction;
            this.append();
        };
        AppendToInputDirective.prototype.changePosition = function () {
            var _a = this.inputCords, bottom = _a.bottom, top = _a.top;
            var y = this.defineElementYByDirection(top, bottom);
            this.setStyle('top', y + "px");
        };
        AppendToInputDirective.prototype.append = function () {
            var _a = this._inputCords, left = _a.left, bottom = _a.bottom, top = _a.top;
            var y = this.defineElementYByDirection(top, bottom);
            this.setStyle('position', 'fixed');
            this.setStyle('left', left + "px");
            this.setStyle('top', y + "px");
        };
        AppendToInputDirective.prototype.setStyle = function (style, value) {
            this.renderer.setStyle(this.element, style, value);
        };
        AppendToInputDirective.prototype.defineElementYByDirection = function (inputTop, inputBottom) {
            if (this._direction === 'top') {
                return inputTop - this.element.offsetHeight;
            }
            else if (this._direction === 'center') {
                return inputTop - (this.element.offsetHeight / 2);
            }
            return inputBottom;
        };
        return AppendToInputDirective;
    }());
    AppendToInputDirective.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: AppendToInputDirective, deps: [{ token: i0__namespace.ElementRef }, { token: i0__namespace.Renderer2 }], target: i0__namespace.ɵɵFactoryTarget.Directive });
    AppendToInputDirective.ɵdir = i0__namespace.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: AppendToInputDirective, selector: "[ngxAppendToInput]", inputs: { inputElement: ["ngxAppendToInput", "inputElement"] }, host: { listeners: { "window:scroll": "changePosition()" } }, ngImport: i0__namespace });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: AppendToInputDirective, decorators: [{
                type: i0.Directive,
                args: [{
                        selector: '[ngxAppendToInput]'
                    }]
            }], ctorParameters: function () { return [{ type: i0__namespace.ElementRef }, { type: i0__namespace.Renderer2 }]; }, propDecorators: { inputElement: [{
                    type: i0.Input,
                    args: ['ngxAppendToInput']
                }], changePosition: [{
                    type: i0.HostListener,
                    args: ['window:scroll']
                }] } });

    var NgxMaterialTimepickerContentComponent = /** @class */ (function () {
        function NgxMaterialTimepickerContentComponent() {
        }
        return NgxMaterialTimepickerContentComponent;
    }());
    NgxMaterialTimepickerContentComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerContentComponent, deps: [], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerContentComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerContentComponent, selector: "ngx-material-timepicker-content", inputs: { appendToInput: "appendToInput", inputElement: "inputElement" }, ngImport: i0__namespace, template: "<div [ngxAppendToInput]=\"inputElement\" *ngIf=\"appendToInput;else timepickerModal\">\n    <!--suppress HtmlUnknownAttribute -->\n    <ng-container *ngTemplateOutlet=\"timepickerOutlet\"></ng-container>\n</div>\n\n<ng-template #timepickerModal>\n    <!--suppress HtmlUnknownAttribute -->\n    <ng-container *ngTemplateOutlet=\"timepickerOutlet\"></ng-container>\n</ng-template>\n\n<ng-template #timepickerOutlet>\n    <ng-content></ng-content>\n</ng-template>\n", directives: [{ type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: AppendToInputDirective, selector: "[ngxAppendToInput]", inputs: ["ngxAppendToInput"] }, { type: i1__namespace.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet"] }] });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerContentComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-content',
                        templateUrl: './ngx-material-timepicker-content.component.html',
                    }]
            }], propDecorators: { appendToInput: [{
                    type: i0.Input
                }], inputElement: [{
                    type: i0.Input
                }] } });

    // @dynamic
    var TimepickerTimeUtils = /** @class */ (function () {
        function TimepickerTimeUtils() {
        }
        TimepickerTimeUtils.getHours = function (format) {
            return Array(format).fill(1).map(function (v, i) {
                var angleStep = 30;
                var time = v + i;
                var angle = angleStep * time;
                return { time: time === 24 ? 0 : time, angle: angle };
            });
        };
        TimepickerTimeUtils.disableHours = function (hours, config) {
            if (config.min || config.max) {
                return hours.map(function (value) {
                    var hour = config.format === 24 ? value.time : TimeAdapter.formatHour(value.time, config.format, config.period);
                    var currentTime = luxon.DateTime.fromObject({ hour: hour }).toFormat(TimeFormat.TWELVE);
                    return Object.assign(Object.assign({}, value), { disabled: !TimeAdapter.isTimeAvailable(currentTime, config.min, config.max, 'hours') });
                });
            }
            return hours;
        };
        TimepickerTimeUtils.getMinutes = function (gap) {
            if (gap === void 0) { gap = 1; }
            var minutesCount = 60;
            var angleStep = 360 / minutesCount;
            var minutes = [];
            for (var i = 0; i < minutesCount; i++) {
                var angle = angleStep * i;
                if (i % gap === 0) {
                    minutes.push({ time: i, angle: angle !== 0 ? angle : 360 });
                }
            }
            return minutes;
        };
        TimepickerTimeUtils.disableMinutes = function (minutes, selectedHour, config) {
            if (config.min || config.max) {
                var hour_1 = TimeAdapter.formatHour(selectedHour, config.format, config.period);
                return minutes.map(function (value) {
                    var currentTime = luxon.DateTime.fromObject({ hour: hour_1, minute: value.time }).toFormat(TimeFormat.TWELVE);
                    return Object.assign(Object.assign({}, value), { disabled: !TimeAdapter.isTimeAvailable(currentTime, config.min, config.max, 'minutes') });
                });
            }
            return minutes;
        };
        return TimepickerTimeUtils;
    }());

    var TimeLocalizerPipe = /** @class */ (function () {
        function TimeLocalizerPipe(locale) {
            this.locale = locale;
        }
        TimeLocalizerPipe.prototype.transform = function (time, timeUnit, isKeyboardEnabled) {
            if (isKeyboardEnabled === void 0) { isKeyboardEnabled = false; }
            if (time == null || time === '') {
                return '';
            }
            switch (timeUnit) {
                case TimeUnit.HOUR: {
                    var format = (time === 0 || isKeyboardEnabled) ? 'HH' : 'H';
                    return this.formatTime('hour', time, format);
                }
                case TimeUnit.MINUTE:
                    return this.formatTime('minute', time, 'mm');
                default:
                    throw new Error("There is no Time Unit with type " + timeUnit);
            }
        };
        TimeLocalizerPipe.prototype.formatTime = function (timeMeasure, time, format) {
            var _b;
            try {
                return luxon.DateTime.fromObject((_b = {}, _b[timeMeasure] = +time, _b)).setLocale(this.locale).toFormat(format);
            }
            catch (_a) {
                throw new Error("Cannot format provided time - " + time + " to locale - " + this.locale);
            }
        };
        return TimeLocalizerPipe;
    }());
    TimeLocalizerPipe.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeLocalizerPipe, deps: [{ token: TIME_LOCALE }], target: i0__namespace.ɵɵFactoryTarget.Pipe });
    TimeLocalizerPipe.ɵpipe = i0__namespace.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeLocalizerPipe, name: "timeLocalizer" });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeLocalizerPipe, decorators: [{
                type: i0.Pipe,
                args: [{
                        name: 'timeLocalizer'
                    }]
            }], ctorParameters: function () {
            return [{ type: undefined, decorators: [{
                            type: i0.Inject,
                            args: [TIME_LOCALE]
                        }] }];
        } });

    var TimeParserPipe = /** @class */ (function () {
        function TimeParserPipe(locale, numberingSystem) {
            this.locale = locale;
            this.numberingSystem = numberingSystem;
        }
        TimeParserPipe.prototype.transform = function (time, timeUnit) {
            if (timeUnit === void 0) { timeUnit = TimeUnit.HOUR; }
            if (time == null || time === '') {
                return '';
            }
            if (!isNaN(+time)) {
                return time;
            }
            if (timeUnit === TimeUnit.MINUTE) {
                return this.parseTime(time, 'm', 'minute');
            }
            return this.parseTime(time, 'H', 'hour');
        };
        TimeParserPipe.prototype.parseTime = function (time, format, timeMeasure) {
            var parsedTime = luxon.DateTime.fromFormat(String(time), format, {
                numberingSystem: this.numberingSystem,
                locale: this.locale
            })[timeMeasure];
            if (!isNaN(parsedTime)) {
                return parsedTime;
            }
            throw new Error("Cannot parse time - " + time);
        };
        return TimeParserPipe;
    }());
    TimeParserPipe.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeParserPipe, deps: [{ token: TIME_LOCALE }, { token: NUMBERING_SYSTEM }], target: i0__namespace.ɵɵFactoryTarget.Pipe });
    TimeParserPipe.ɵpipe = i0__namespace.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeParserPipe, name: "timeParser" });
    TimeParserPipe.ɵprov = i0__namespace.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeParserPipe });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeParserPipe, decorators: [{
                type: i0.Pipe,
                args: [{
                        name: 'timeParser'
                    }]
            }, {
                type: i0.Injectable
            }], ctorParameters: function () {
            return [{ type: undefined, decorators: [{
                            type: i0.Inject,
                            args: [TIME_LOCALE]
                        }] }, { type: undefined, decorators: [{
                            type: i0.Inject,
                            args: [NUMBERING_SYSTEM]
                        }] }];
        } });

    var AutofocusDirective = /** @class */ (function () {
        function AutofocusDirective(element, document) {
            this.element = element;
            this.document = document;
            this.activeElement = this.document.activeElement;
        }
        AutofocusDirective.prototype.ngOnChanges = function () {
            var _this = this;
            if (this.isFocusActive) {
                // To avoid ExpressionChangedAfterItHasBeenCheckedError;
                setTimeout(function () { return _this.element.nativeElement.focus({ preventScroll: true }); });
            }
        };
        AutofocusDirective.prototype.ngOnDestroy = function () {
            var _this = this;
            // To avoid ExpressionChangedAfterItHasBeenCheckedError;
            setTimeout(function () { return _this.activeElement.focus({ preventScroll: true }); });
        };
        return AutofocusDirective;
    }());
    AutofocusDirective.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: AutofocusDirective, deps: [{ token: i0__namespace.ElementRef }, { token: i1.DOCUMENT, optional: true }], target: i0__namespace.ɵɵFactoryTarget.Directive });
    AutofocusDirective.ɵdir = i0__namespace.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: AutofocusDirective, selector: "[timepickerAutofocus]", inputs: { isFocusActive: ["timepickerAutofocus", "isFocusActive"] }, usesOnChanges: true, ngImport: i0__namespace });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: AutofocusDirective, decorators: [{
                type: i0.Directive,
                args: [{
                        selector: '[timepickerAutofocus]'
                    }]
            }], ctorParameters: function () {
            return [{ type: i0__namespace.ElementRef }, { type: undefined, decorators: [{
                            type: i0.Optional
                        }, {
                            type: i0.Inject,
                            args: [i1.DOCUMENT]
                        }] }];
        }, propDecorators: { isFocusActive: [{
                    type: i0.Input,
                    args: ['timepickerAutofocus']
                }] } });

    /* tslint:disable:triple-equals */
    var NgxMaterialTimepickerDialControlComponent = /** @class */ (function () {
        function NgxMaterialTimepickerDialControlComponent(timeParserPipe, timeLocalizerPipe) {
            this.timeParserPipe = timeParserPipe;
            this.timeLocalizerPipe = timeLocalizerPipe;
            this.timeUnitChanged = new i0.EventEmitter();
            this.timeChanged = new i0.EventEmitter();
            this.focused = new i0.EventEmitter();
            this.unfocused = new i0.EventEmitter();
        }
        Object.defineProperty(NgxMaterialTimepickerDialControlComponent.prototype, "selectedTime", {
            get: function () {
                var _this = this;
                if (!!this.time) {
                    return this.timeList.find(function (t) { return t.time === +_this.time; });
                }
            },
            enumerable: false,
            configurable: true
        });
        NgxMaterialTimepickerDialControlComponent.prototype.ngOnInit = function () {
            var _this = this;
            if (this.isEditable) {
                this.timeControl = new i4.FormControl({ value: this.formatTimeForUI(this.time), disabled: this.disabled });
                this.timeControl.valueChanges.pipe(operators.tap(function (value) {
                    if (value.length > 2) {
                        _this.updateInputValue(value.slice(-1));
                    }
                }), operators.debounceTime(500), operators.distinctUntilChanged(), operators.filter(function (value) { return !isTimeDisabledToChange(_this.time, value, _this.timeList); }), operators.tap(function (value) { return _this.time = _this.timeParserPipe.transform(value, _this.timeUnit).toString(); })).subscribe(function () { return _this.updateTime(); });
            }
        };
        NgxMaterialTimepickerDialControlComponent.prototype.saveTimeAndChangeTimeUnit = function (event, unit) {
            event.preventDefault();
            this.previousTime = this.time;
            this.timeUnitChanged.next(unit);
            this.focused.next();
        };
        NgxMaterialTimepickerDialControlComponent.prototype.updateTime = function () {
            var time = this.selectedTime;
            if (time) {
                this.timeChanged.next(time);
                this.previousTime = time.time;
                if (this.isEditable) {
                    this.updateInputValue(this.formatTimeForUI(time.time));
                }
            }
        };
        NgxMaterialTimepickerDialControlComponent.prototype.onKeydown = function (e) {
            if (!isDigit(e)) {
                e.preventDefault();
            }
            else {
                this.changeTimeByArrow(e.keyCode);
            }
        };
        NgxMaterialTimepickerDialControlComponent.prototype.changeTimeByArrow = function (keyCode) {
            var ARROW_UP = 38;
            var ARROW_DOWN = 40;
            var time;
            if (keyCode === ARROW_UP) {
                time = String(+this.time + (this.minutesGap || 1));
            }
            else if (keyCode === ARROW_DOWN) {
                time = String(+this.time - (this.minutesGap || 1));
            }
            if (!isTimeUnavailable(time, this.timeList)) {
                this.time = time;
                this.updateTime();
            }
        };
        NgxMaterialTimepickerDialControlComponent.prototype.formatTimeForUI = function (value) {
            var parsedTime = this.timeParserPipe.transform(value, this.timeUnit).toString();
            return this.timeLocalizerPipe.transform(parsedTime, this.timeUnit, true);
        };
        NgxMaterialTimepickerDialControlComponent.prototype.updateInputValue = function (value) {
            this.editableTimeTmpl.nativeElement.value = value;
        };
        return NgxMaterialTimepickerDialControlComponent;
    }());
    NgxMaterialTimepickerDialControlComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerDialControlComponent, deps: [{ token: TimeParserPipe }, { token: TimeLocalizerPipe }], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerDialControlComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerDialControlComponent, selector: "ngx-material-timepicker-dial-control", inputs: { timeList: "timeList", timeUnit: "timeUnit", time: "time", isActive: "isActive", isEditable: "isEditable", minutesGap: "minutesGap", disabled: "disabled" }, outputs: { timeUnitChanged: "timeUnitChanged", timeChanged: "timeChanged", focused: "focused", unfocused: "unfocused" }, providers: [TimeParserPipe, TimeLocalizerPipe], viewQueries: [{ propertyName: "editableTimeTmpl", first: true, predicate: ["editableTimeTmpl"], descendants: true }], ngImport: i0__namespace, template: "<!--suppress HtmlFormInputWithoutLabel, HtmlUnknownAttribute -->\n<input class=\"timepicker-dial__control timepicker-dial__item\"\n       [ngClass]=\"{'timepicker-dial__item_active': isActive}\"\n       [ngModel]=\"time | timeLocalizer: timeUnit\"\n       (ngModelChange)=\"time = $event\"\n       [disabled]=\"disabled\"\n       (input)=\"updateTime()\" (focus)=\"saveTimeAndChangeTimeUnit($event, timeUnit)\"\n       readonly [timepickerAutofocus]=\"isActive\"\n       *ngIf=\"!isEditable;else editableTemplate\">\n\n<ng-template #editableTemplate>\n    <!--suppress HtmlFormInputWithoutLabel, HtmlUnknownAttribute -->\n    <input class=\"timepicker-dial__control timepicker-dial__item timepicker-dial__control_editable\"\n           #editableTimeTmpl\n           [formControl]=\"timeControl\"\n           [ngClass]=\"{'timepicker-dial__item_active': isActive}\"\n           [timepickerAutofocus]=\"isActive\"\n           (focus)=\"saveTimeAndChangeTimeUnit($event, timeUnit)\"\n           (keydown)=\"onKeydown($event)\">\n</ng-template>\n", styles: [".timepicker-dial__item{cursor:pointer;color:#ffffff80;font-family:\"Roboto\",sans-serif}@supports (font-family: var(--primary-font-family)){.timepicker-dial__item{font-family:var(--primary-font-family);color:var(--dial-inactive-color)}}.timepicker-dial__item_active{color:#fff}@supports (color: var(--dial-active-color)){.timepicker-dial__item_active{color:var(--dial-active-color)}}.timepicker-dial__control{border:none;background-color:transparent;font-size:50px;width:60px;padding:0;border-radius:3px;text-align:right}.timepicker-dial__control_editable:focus{color:#00bfff;background-color:#fff;outline:deepskyblue}@supports (color: var(--dial-editable-active-color)){.timepicker-dial__control_editable:focus{color:var(--dial-editable-active-color)}}@supports (background-color: var(--dial-editable-background-color)){.timepicker-dial__control_editable:focus{background-color:var(--dial-editable-background-color)}}@supports (outline: var(--dial-editable-active-color)){.timepicker-dial__control_editable:focus{outline:var(--dial-editable-active-color)}}.timepicker-dial__control:disabled{cursor:default}.timepicker-dial__control:focus-visible{outline:none}\n"], directives: [{ type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: i4__namespace.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { type: i1__namespace.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i4__namespace.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { type: i4__namespace.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { type: AutofocusDirective, selector: "[timepickerAutofocus]", inputs: ["timepickerAutofocus"] }, { type: i4__namespace.FormControlDirective, selector: "[formControl]", inputs: ["disabled", "formControl", "ngModel"], outputs: ["ngModelChange"], exportAs: ["ngForm"] }], pipes: { "timeLocalizer": TimeLocalizerPipe } });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerDialControlComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-dial-control',
                        templateUrl: 'ngx-material-timepicker-dial-control.component.html',
                        styleUrls: ['ngx-material-timepicker-dial-control.component.scss'],
                        providers: [TimeParserPipe, TimeLocalizerPipe],
                    }]
            }], ctorParameters: function () { return [{ type: TimeParserPipe }, { type: TimeLocalizerPipe }]; }, propDecorators: { timeList: [{
                    type: i0.Input
                }], timeUnit: [{
                    type: i0.Input
                }], time: [{
                    type: i0.Input
                }], isActive: [{
                    type: i0.Input
                }], isEditable: [{
                    type: i0.Input
                }], minutesGap: [{
                    type: i0.Input
                }], disabled: [{
                    type: i0.Input
                }], editableTimeTmpl: [{
                    type: i0.ViewChild,
                    args: ['editableTimeTmpl']
                }], timeUnitChanged: [{
                    type: i0.Output
                }], timeChanged: [{
                    type: i0.Output
                }], focused: [{
                    type: i0.Output
                }], unfocused: [{
                    type: i0.Output
                }] } });
    function isTimeDisabledToChange(currentTime, nextTime, timeList) {
        var isNumber = /\d/.test(nextTime);
        if (isNumber) {
            return isTimeUnavailable(nextTime, timeList);
        }
    }
    function isTimeUnavailable(time, timeList) {
        var selectedTime = timeList.find(function (value) { return value.time === +time; });
        return !selectedTime || (selectedTime && selectedTime.disabled);
    }

    var NgxMaterialTimepickerPeriodComponent = /** @class */ (function () {
        function NgxMaterialTimepickerPeriodComponent() {
            this.timePeriod = TimePeriod;
            this.isPeriodAvailable = true;
            this.periodChanged = new i0.EventEmitter();
        }
        NgxMaterialTimepickerPeriodComponent.prototype.changePeriod = function (period) {
            this.isPeriodAvailable = this.isSwitchPeriodAvailable(period);
            if (this.isPeriodAvailable) {
                this.periodChanged.next(period);
            }
        };
        NgxMaterialTimepickerPeriodComponent.prototype.animationDone = function () {
            this.isPeriodAvailable = true;
        };
        NgxMaterialTimepickerPeriodComponent.prototype.isSwitchPeriodAvailable = function (period) {
            var time = this.getDisabledTimeByPeriod(period);
            return !time.every(function (t) { return t.disabled; });
        };
        NgxMaterialTimepickerPeriodComponent.prototype.getDisabledTimeByPeriod = function (period) {
            switch (this.activeTimeUnit) {
                case TimeUnit.HOUR:
                    return TimepickerTimeUtils.disableHours(this.hours, {
                        min: this.minTime,
                        max: this.maxTime,
                        format: this.format,
                        period: period
                    });
                case TimeUnit.MINUTE:
                    return TimepickerTimeUtils.disableMinutes(this.minutes, +this.selectedHour, {
                        min: this.minTime,
                        max: this.maxTime,
                        format: this.format,
                        period: period
                    });
                default:
                    throw new Error('no such TimeUnit');
            }
        };
        return NgxMaterialTimepickerPeriodComponent;
    }());
    NgxMaterialTimepickerPeriodComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerPeriodComponent, deps: [], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerPeriodComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerPeriodComponent, selector: "ngx-material-timepicker-period", inputs: { selectedPeriod: "selectedPeriod", format: "format", activeTimeUnit: "activeTimeUnit", hours: "hours", minutes: "minutes", minTime: "minTime", maxTime: "maxTime", selectedHour: "selectedHour", meridiems: "meridiems" }, outputs: { periodChanged: "periodChanged" }, ngImport: i0__namespace, template: "<div class=\"timepicker-period\">\n\t\t\t<button class=\"timepicker-dial__item timepicker-period__btn\"\n                  [ngClass]=\"{'timepicker-dial__item_active': selectedPeriod === timePeriod.AM}\"\n                  (click)=\"changePeriod(timePeriod.AM)\"\n                  type=\"button\">{{meridiems[0]}}</button>\n    <button class=\"timepicker-dial__item timepicker-period__btn\"\n          [ngClass]=\"{'timepicker-dial__item_active': selectedPeriod === timePeriod.PM}\"\n          (click)=\"changePeriod(timePeriod.PM)\"\n          type=\"button\">{{meridiems[1]}}</button>\n    <div class=\"timepicker-period__warning\" [@scaleInOut] (@scaleInOut.done)=\"animationDone()\" *ngIf=\"!isPeriodAvailable\">\n        <p>Current time would be invalid in this period.</p>\n    </div>\n</div>\n", styles: [".timepicker-dial__item{cursor:pointer;color:#ffffff80;font-family:\"Roboto\",sans-serif}@supports (font-family: var(--primary-font-family)){.timepicker-dial__item{font-family:var(--primary-font-family);color:var(--dial-inactive-color)}}.timepicker-dial__item_active{color:#fff}@supports (color: var(--dial-active-color)){.timepicker-dial__item_active{color:var(--dial-active-color)}}.timepicker-period{display:flex;flex-direction:column;position:relative}.timepicker-period__btn{padding:1px 3px;border:0;background-color:transparent;font-size:18px;font-weight:500;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;border-radius:3px;transition:background-color .5s;font-family:\"Roboto\",sans-serif}@supports (font-family: var(--primary-font-family)){.timepicker-period__btn{font-family:var(--primary-font-family)}}.timepicker-period__btn:focus{background-color:#00000012}.timepicker-period__warning{padding:5px 10px;border-radius:3px;background-color:#0000008c;color:#fff;position:absolute;width:200px;left:-20px;top:40px}.timepicker-period__warning>p{margin:0;font-size:12px;font-family:\"Roboto\",sans-serif}@supports (font-family: var(--primary-font-family)){.timepicker-period__warning>p{font-family:var(--primary-font-family)}}\n"], directives: [{ type: i1__namespace.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }], animations: [
            animations.trigger('scaleInOut', [
                animations.transition(':enter', [
                    animations.style({ transform: 'scale(0)' }),
                    animations.animate('.2s', animations.style({ transform: 'scale(1)' })),
                    animations.sequence([
                        animations.animate('3s', animations.style({ opacity: 1 })),
                        animations.animate('.3s', animations.style({ opacity: 0 }))
                    ])
                ])
            ])
        ] });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerPeriodComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-period',
                        templateUrl: 'ngx-material-timepicker-period.component.html',
                        styleUrls: ['ngx-material-timepicker-period.component.scss'],
                        animations: [
                            animations.trigger('scaleInOut', [
                                animations.transition(':enter', [
                                    animations.style({ transform: 'scale(0)' }),
                                    animations.animate('.2s', animations.style({ transform: 'scale(1)' })),
                                    animations.sequence([
                                        animations.animate('3s', animations.style({ opacity: 1 })),
                                        animations.animate('.3s', animations.style({ opacity: 0 }))
                                    ])
                                ])
                            ])
                        ]
                    }]
            }], propDecorators: { selectedPeriod: [{
                    type: i0.Input
                }], format: [{
                    type: i0.Input
                }], activeTimeUnit: [{
                    type: i0.Input
                }], hours: [{
                    type: i0.Input
                }], minutes: [{
                    type: i0.Input
                }], minTime: [{
                    type: i0.Input
                }], maxTime: [{
                    type: i0.Input
                }], selectedHour: [{
                    type: i0.Input
                }], meridiems: [{
                    type: i0.Input
                }], periodChanged: [{
                    type: i0.Output
                }] } });

    var NgxMaterialTimepickerDialComponent = /** @class */ (function () {
        function NgxMaterialTimepickerDialComponent(locale) {
            this.locale = locale;
            this.timeUnit = TimeUnit;
            this.meridiems = luxon.Info.meridiems({ locale: this.locale });
            this.periodChanged = new i0.EventEmitter();
            this.timeUnitChanged = new i0.EventEmitter();
            this.hourChanged = new i0.EventEmitter();
            this.minuteChanged = new i0.EventEmitter();
        }
        NgxMaterialTimepickerDialComponent.prototype.ngOnChanges = function (changes) {
            if (changes['period'] && changes['period'].currentValue
                || changes['format'] && changes['format'].currentValue) {
                var hours = TimepickerTimeUtils.getHours(this.format);
                this.hours = TimepickerTimeUtils.disableHours(hours, {
                    min: this.minTime,
                    max: this.maxTime,
                    format: this.format,
                    period: this.period,
                });
            }
            if (changes['period'] && changes['period'].currentValue
                || changes['hour'] && changes['hour'].currentValue) {
                var minutes = TimepickerTimeUtils.getMinutes(this.minutesGap);
                this.minutes = TimepickerTimeUtils.disableMinutes(minutes, +this.hour, {
                    min: this.minTime,
                    max: this.maxTime,
                    format: this.format,
                    period: this.period,
                });
            }
        };
        NgxMaterialTimepickerDialComponent.prototype.changeTimeUnit = function (unit) {
            this.timeUnitChanged.next(unit);
        };
        NgxMaterialTimepickerDialComponent.prototype.changePeriod = function (period) {
            this.periodChanged.next(period);
        };
        NgxMaterialTimepickerDialComponent.prototype.changeHour = function (hour) {
            this.hourChanged.next(hour);
            if (this.isEditable) {
                this.changeTimeUnit(TimeUnit.MINUTE);
            }
        };
        NgxMaterialTimepickerDialComponent.prototype.changeMinute = function (minute) {
            this.minuteChanged.next(minute);
        };
        NgxMaterialTimepickerDialComponent.prototype.showHint = function () {
            this.isHintVisible = true;
        };
        NgxMaterialTimepickerDialComponent.prototype.hideHint = function () {
            this.isHintVisible = false;
        };
        return NgxMaterialTimepickerDialComponent;
    }());
    NgxMaterialTimepickerDialComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerDialComponent, deps: [{ token: TIME_LOCALE }], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerDialComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerDialComponent, selector: "ngx-material-timepicker-dial", inputs: { editableHintTmpl: "editableHintTmpl", hour: "hour", minute: "minute", format: "format", period: "period", activeTimeUnit: "activeTimeUnit", minTime: "minTime", maxTime: "maxTime", isEditable: "isEditable", minutesGap: "minutesGap", hoursOnly: "hoursOnly" }, outputs: { periodChanged: "periodChanged", timeUnitChanged: "timeUnitChanged", hourChanged: "hourChanged", minuteChanged: "minuteChanged" }, usesOnChanges: true, ngImport: i0__namespace, template: "<div class=\"timepicker-dial\">\n    <div class=\"timepicker-dial__container\">\n        <div class=\"timepicker-dial__time\">\n            <ngx-material-timepicker-dial-control [timeList]=\"hours\" [time]=\"hour\" [timeUnit]=\"timeUnit.HOUR\"\n                                                  [isActive]=\"activeTimeUnit === timeUnit.HOUR\"\n                                                  [isEditable]=\"isEditable\"\n                                                  (timeUnitChanged)=\"changeTimeUnit($event)\"\n                                                  (timeChanged)=\"changeHour($event)\"\n                                                  (focused)=\"showHint()\"\n                                                  (unfocused)=\"hideHint()\">\n\n            </ngx-material-timepicker-dial-control>\n            <span>:</span>\n            <ngx-material-timepicker-dial-control [timeList]=\"minutes\" [time]=\"minute\" [timeUnit]=\"timeUnit.MINUTE\"\n                                                  [isActive]=\"activeTimeUnit === timeUnit.MINUTE\"\n                                                  [isEditable]=\"isEditable\"\n                                                  [minutesGap]=\"minutesGap\"\n                                                  [disabled]=\"hoursOnly\"\n                                                  (timeUnitChanged)=\"changeTimeUnit($event)\"\n                                                  (timeChanged)=\"changeMinute($event)\"\n                                                  (focused)=\"showHint()\"\n                                                  (unfocused)=\"hideHint()\">\n\n            </ngx-material-timepicker-dial-control>\n        </div>\n        <ngx-material-timepicker-period class=\"timepicker-dial__period\"\n                                        [ngClass]=\"{'timepicker-dial__period--hidden': format === 24}\"\n                                        [selectedPeriod]=\"period\" [activeTimeUnit]=\"activeTimeUnit\"\n                                        [maxTime]=\"maxTime\" [minTime]=\"minTime\" [format]=\"format\"\n                                        [hours]=\"hours\" [minutes]=\"minutes\" [selectedHour]=\"hour\"\n                                        [meridiems]=\"meridiems\"\n                                        (periodChanged)=\"changePeriod($event)\"></ngx-material-timepicker-period>\n    </div>\n    <div *ngIf=\"isEditable || editableHintTmpl\" [ngClass]=\"{'timepicker-dial__hint-container--hidden': !isHintVisible}\">\n        <!--suppress HtmlUnknownAttribute -->\n        <ng-container *ngTemplateOutlet=\"editableHintTmpl ? editableHintTmpl : editableHintDefault\"></ng-container>\n        <ng-template #editableHintDefault>\n            <small class=\"timepicker-dial__hint\"> * use arrows (<span>&#8645;</span>) to change the time</small>\n        </ng-template>\n    </div>\n</div>\n", styles: [".timepicker-dial{text-align:right}.timepicker-dial__container{display:flex;align-items:center;justify-content:flex-end;-webkit-tap-highlight-color:rgba(0,0,0,0)}.timepicker-dial__time{display:flex;align-items:baseline;line-height:normal;font-size:50px;color:#ffffff80;font-family:\"Roboto\",sans-serif}@supports (font-family: var(--primary-font-family)){.timepicker-dial__time{font-family:var(--primary-font-family);color:var(--dial-inactive-color)}}.timepicker-dial__period{display:block;margin-left:10px}.timepicker-dial__period--hidden{visibility:hidden}.timepicker-dial__hint-container--hidden{visibility:hidden}.timepicker-dial__hint{display:inline-block;font-size:10px;color:#fff}@supports (color: var(--dial-active-color)){.timepicker-dial__hint{color:var(--dial-active-color)}}.timepicker-dial__hint span{font-size:14px}@media (max-device-width: 1023px) and (orientation: landscape){.timepicker-dial__container{flex-direction:column}.timepicker-dial__period{margin-left:0}}\n"], components: [{ type: NgxMaterialTimepickerDialControlComponent, selector: "ngx-material-timepicker-dial-control", inputs: ["timeList", "timeUnit", "time", "isActive", "isEditable", "minutesGap", "disabled"], outputs: ["timeUnitChanged", "timeChanged", "focused", "unfocused"] }, { type: NgxMaterialTimepickerPeriodComponent, selector: "ngx-material-timepicker-period", inputs: ["selectedPeriod", "format", "activeTimeUnit", "hours", "minutes", "minTime", "maxTime", "selectedHour", "meridiems"], outputs: ["periodChanged"] }], directives: [{ type: i1__namespace.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: i1__namespace.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet"] }], changeDetection: i0__namespace.ChangeDetectionStrategy.OnPush });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerDialComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-dial',
                        templateUrl: 'ngx-material-timepicker-dial.component.html',
                        styleUrls: ['ngx-material-timepicker-dial.component.scss'],
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                    }]
            }], ctorParameters: function () {
            return [{ type: undefined, decorators: [{
                            type: i0.Inject,
                            args: [TIME_LOCALE]
                        }] }];
        }, propDecorators: { editableHintTmpl: [{
                    type: i0.Input
                }], hour: [{
                    type: i0.Input
                }], minute: [{
                    type: i0.Input
                }], format: [{
                    type: i0.Input
                }], period: [{
                    type: i0.Input
                }], activeTimeUnit: [{
                    type: i0.Input
                }], minTime: [{
                    type: i0.Input
                }], maxTime: [{
                    type: i0.Input
                }], isEditable: [{
                    type: i0.Input
                }], minutesGap: [{
                    type: i0.Input
                }], hoursOnly: [{
                    type: i0.Input
                }], periodChanged: [{
                    type: i0.Output
                }], timeUnitChanged: [{
                    type: i0.Output
                }], hourChanged: [{
                    type: i0.Output
                }], minuteChanged: [{
                    type: i0.Output
                }] } });

    /******************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise */
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b)
                if (Object.prototype.hasOwnProperty.call(b, p))
                    d[p] = b[p]; };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function () {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
        function accept(f) { if (f !== void 0 && typeof f !== "function")
            throw new TypeError("Function expected"); return f; }
        var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
        var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
        var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
        var _, done = false;
        for (var i = decorators.length - 1; i >= 0; i--) {
            var context = {};
            for (var p in contextIn)
                context[p] = p === "access" ? {} : contextIn[p];
            for (var p in contextIn.access)
                context.access[p] = contextIn.access[p];
            context.addInitializer = function (f) { if (done)
                throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
            var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
            if (kind === "accessor") {
                if (result === void 0)
                    continue;
                if (result === null || typeof result !== "object")
                    throw new TypeError("Object expected");
                if (_ = accept(result.get))
                    descriptor.get = _;
                if (_ = accept(result.set))
                    descriptor.set = _;
                if (_ = accept(result.init))
                    initializers.unshift(_);
            }
            else if (_ = accept(result)) {
                if (kind === "field")
                    initializers.unshift(_);
                else
                    descriptor[key] = _;
            }
        }
        if (target)
            Object.defineProperty(target, contextIn.name, descriptor);
        done = true;
    }
    ;
    function __runInitializers(thisArg, initializers, value) {
        var useValue = arguments.length > 2;
        for (var i = 0; i < initializers.length; i++) {
            value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
        }
        return useValue ? value : void 0;
    }
    ;
    function __propKey(x) {
        return typeof x === "symbol" ? x : "".concat(x);
    }
    ;
    function __setFunctionName(f, name, prefix) {
        if (typeof name === "symbol")
            name = name.description ? "[".concat(name.description, "]") : "";
        return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
    }
    ;
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try {
                step(generator.next(value));
            }
            catch (e) {
                reject(e);
            } }
            function rejected(value) { try {
                step(generator["throw"](value));
            }
            catch (e) {
                reject(e);
            } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () { if (t[0] & 1)
                throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (g && (g = 0, op[0] && (_ = 0)), _)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    var __createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
            desc = { enumerable: true, get: function () { return m[k]; } };
        }
        Object.defineProperty(o, k2, desc);
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                __createBinding(o, m, p);
    }
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    /** @deprecated */
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    /** @deprecated */
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    }
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n])
            i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try {
            step(g[n](v));
        }
        catch (e) {
            settle(q[0][3], e);
        } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length)
            resume(q[0][0], q[0][1]); }
    }
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
    }
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    function __classPrivateFieldGet(receiver, state, kind, f) {
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    }
    function __classPrivateFieldSet(receiver, state, value, kind, f) {
        if (kind === "m")
            throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    }
    function __classPrivateFieldIn(state, receiver) {
        if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function"))
            throw new TypeError("Cannot use 'in' operator on non-object");
        return typeof state === "function" ? receiver === state : state.has(receiver);
    }
    var tslib_es6 = {
        __extends: __extends,
        __assign: __assign,
        __rest: __rest,
        __decorate: __decorate,
        __param: __param,
        __metadata: __metadata,
        __awaiter: __awaiter,
        __generator: __generator,
        __createBinding: __createBinding,
        __exportStar: __exportStar,
        __values: __values,
        __read: __read,
        __spread: __spread,
        __spreadArrays: __spreadArrays,
        __spreadArray: __spreadArray,
        __await: __await,
        __asyncGenerator: __asyncGenerator,
        __asyncDelegator: __asyncDelegator,
        __asyncValues: __asyncValues,
        __makeTemplateObject: __makeTemplateObject,
        __importStar: __importStar,
        __importDefault: __importDefault,
        __classPrivateFieldGet: __classPrivateFieldGet,
        __classPrivateFieldSet: __classPrivateFieldSet,
        __classPrivateFieldIn: __classPrivateFieldIn,
    };

    var NgxMaterialTimepickerHoursFace = /** @class */ (function () {
        function NgxMaterialTimepickerHoursFace(format) {
            this.hourChange = new i0.EventEmitter();
            this.hourSelected = new i0.EventEmitter();
            this.hoursList = [];
            this.hoursList = TimepickerTimeUtils.getHours(format);
        }
        NgxMaterialTimepickerHoursFace.prototype.onTimeSelected = function (time) {
            this.hourSelected.next(time);
        };
        return NgxMaterialTimepickerHoursFace;
    }());
    NgxMaterialTimepickerHoursFace.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerHoursFace, deps: "invalid", target: i0__namespace.ɵɵFactoryTarget.Directive });
    NgxMaterialTimepickerHoursFace.ɵdir = i0__namespace.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerHoursFace, inputs: { selectedHour: "selectedHour", minTime: "minTime", maxTime: "maxTime", format: "format" }, outputs: { hourChange: "hourChange", hourSelected: "hourSelected" }, ngImport: i0__namespace });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerHoursFace, decorators: [{
                type: i0.Directive
            }], ctorParameters: function () { return [{ type: undefined }]; }, propDecorators: { selectedHour: [{
                    type: i0.Input
                }], minTime: [{
                    type: i0.Input
                }], maxTime: [{
                    type: i0.Input
                }], format: [{
                    type: i0.Input
                }], hourChange: [{
                    type: i0.Output
                }], hourSelected: [{
                    type: i0.Output
                }] } });

    var ActiveHourPipe = /** @class */ (function () {
        function ActiveHourPipe() {
        }
        ActiveHourPipe.prototype.transform = function (hour, currentHour, isClockFaceDisabled) {
            if (hour == null || isClockFaceDisabled) {
                return false;
            }
            return hour === currentHour;
        };
        return ActiveHourPipe;
    }());
    ActiveHourPipe.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: ActiveHourPipe, deps: [], target: i0__namespace.ɵɵFactoryTarget.Pipe });
    ActiveHourPipe.ɵpipe = i0__namespace.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: ActiveHourPipe, name: "activeHour" });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: ActiveHourPipe, decorators: [{
                type: i0.Pipe,
                args: [{
                        name: 'activeHour'
                    }]
            }] });

    var ActiveMinutePipe = /** @class */ (function () {
        function ActiveMinutePipe() {
        }
        ActiveMinutePipe.prototype.transform = function (minute, currentMinute, gap, isClockFaceDisabled) {
            if (minute == null || isClockFaceDisabled) {
                return false;
            }
            var defaultGap = 5;
            return ((currentMinute === minute) && (minute % (gap || defaultGap) === 0));
        };
        return ActiveMinutePipe;
    }());
    ActiveMinutePipe.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: ActiveMinutePipe, deps: [], target: i0__namespace.ɵɵFactoryTarget.Pipe });
    ActiveMinutePipe.ɵpipe = i0__namespace.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: ActiveMinutePipe, name: "activeMinute" });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: ActiveMinutePipe, decorators: [{
                type: i0.Pipe,
                args: [{
                        name: 'activeMinute'
                    }]
            }] });

    var MinutesFormatterPipe = /** @class */ (function () {
        function MinutesFormatterPipe() {
        }
        MinutesFormatterPipe.prototype.transform = function (minute, gap) {
            if (gap === void 0) { gap = 5; }
            if (!minute) {
                return minute;
            }
            return minute % gap === 0 ? minute : '';
        };
        return MinutesFormatterPipe;
    }());
    MinutesFormatterPipe.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: MinutesFormatterPipe, deps: [], target: i0__namespace.ɵɵFactoryTarget.Pipe });
    MinutesFormatterPipe.ɵpipe = i0__namespace.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: MinutesFormatterPipe, name: "minutesFormatter" });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: MinutesFormatterPipe, decorators: [{
                type: i0.Pipe,
                args: [{
                        name: 'minutesFormatter'
                    }]
            }] });

    var CLOCK_HAND_STYLES = {
        small: {
            height: '75px',
            top: 'calc(50% - 75px)'
        },
        large: {
            height: '103px',
            top: 'calc(50% - 103px)'
        }
    };
    var NgxMaterialTimepickerFaceComponent = /** @class */ (function () {
        function NgxMaterialTimepickerFaceComponent() {
            this.timeUnit = TimeUnit;
            this.innerClockFaceSize = 85;
            this.timeChange = new i0.EventEmitter();
            this.timeSelected = new i0.EventEmitter();
        }
        NgxMaterialTimepickerFaceComponent.prototype.ngAfterViewInit = function () {
            this.setClockHandPosition();
            this.addTouchEvents();
        };
        NgxMaterialTimepickerFaceComponent.prototype.ngOnChanges = function (changes) {
            var _this = this;
            var faceTimeChanges = changes['faceTime'];
            var selectedTimeChanges = changes['selectedTime'];
            if ((faceTimeChanges && faceTimeChanges.currentValue)
                && (selectedTimeChanges && selectedTimeChanges.currentValue)) {
                /* Set time according to passed an input value */
                this.selectedTime = this.faceTime.find(function (time) { return time.time === _this.selectedTime.time; });
            }
            if (selectedTimeChanges && selectedTimeChanges.currentValue) {
                this.setClockHandPosition();
            }
            if (faceTimeChanges && faceTimeChanges.currentValue) {
                // To avoid an error ExpressionChangedAfterItHasBeenCheckedError
                setTimeout(function () { return _this.selectAvailableTime(); });
            }
        };
        NgxMaterialTimepickerFaceComponent.prototype.trackByTime = function (_, time) {
            return time.time;
        };
        NgxMaterialTimepickerFaceComponent.prototype.onMousedown = function (e) {
            e.preventDefault();
            this.isStarted = true;
        };
        NgxMaterialTimepickerFaceComponent.prototype.selectTime = function (e) {
            if (!this.isStarted && (e instanceof MouseEvent && e.type !== 'click')) {
                return;
            }
            var clockFaceCords = this.clockFace.nativeElement.getBoundingClientRect();
            /* Get x0 and y0 of the circle */
            var centerX = clockFaceCords.left + clockFaceCords.width / 2;
            var centerY = clockFaceCords.top + clockFaceCords.height / 2;
            /* Counting the arctangent and convert it to from radian to deg */
            var arctangent = Math.atan(Math.abs(e.clientX - centerX) / Math.abs(e.clientY - centerY)) * 180 / Math.PI;
            /* Get angle according to quadrant */
            var circleAngle = countAngleByCords(centerX, centerY, e.clientX, e.clientY, arctangent);
            /* Check if selected time from the inner clock face (24 hours format only) */
            var isInnerClockChosen = this.format && this.isInnerClockFace(centerX, centerY, e.clientX, e.clientY);
            /* Round angle according to angle step */
            var angleStep = this.unit === TimeUnit.MINUTE ? (6 * (this.minutesGap || 1)) : 30;
            var roundedAngle = roundAngle(circleAngle, angleStep);
            var angle = (roundedAngle || 360) + (isInnerClockChosen ? 360 : 0);
            var selectedTime = this.faceTime.find(function (val) { return val.angle === angle; });
            if (selectedTime && !selectedTime.disabled) {
                this.timeChange.next(selectedTime);
                /* To let know whether user ended interaction with clock face */
                if (!this.isStarted) {
                    this.timeSelected.next(selectedTime.time);
                }
            }
        };
        NgxMaterialTimepickerFaceComponent.prototype.onMouseup = function (e) {
            e.preventDefault();
            this.isStarted = false;
        };
        NgxMaterialTimepickerFaceComponent.prototype.ngOnDestroy = function () {
            this.removeTouchEvents();
        };
        NgxMaterialTimepickerFaceComponent.prototype.addTouchEvents = function () {
            this.touchStartHandler = this.onMousedown.bind(this);
            this.touchEndHandler = this.onMouseup.bind(this);
            this.clockFace.nativeElement.addEventListener('touchstart', this.touchStartHandler);
            this.clockFace.nativeElement.addEventListener('touchend', this.touchEndHandler);
        };
        NgxMaterialTimepickerFaceComponent.prototype.removeTouchEvents = function () {
            this.clockFace.nativeElement.removeEventListener('touchstart', this.touchStartHandler);
            this.clockFace.nativeElement.removeEventListener('touchend', this.touchEndHandler);
        };
        NgxMaterialTimepickerFaceComponent.prototype.setClockHandPosition = function () {
            if (this.format === 24) {
                if (this.selectedTime.time > 12 || this.selectedTime.time === 0) {
                    this.decreaseClockHand();
                }
                else {
                    this.increaseClockHand();
                }
            }
            this.clockHand.nativeElement.style.transform = "rotate(" + this.selectedTime.angle + "deg)";
        };
        NgxMaterialTimepickerFaceComponent.prototype.selectAvailableTime = function () {
            var _this = this;
            var currentTime = this.faceTime.find(function (time) { return _this.selectedTime.time === time.time; });
            this.isClockFaceDisabled = this.faceTime.every(function (time) { return time.disabled; });
            if ((currentTime && currentTime.disabled) && !this.isClockFaceDisabled) {
                var availableTime = this.faceTime.find(function (time) { return !time.disabled; });
                this.timeChange.next(availableTime);
            }
        };
        NgxMaterialTimepickerFaceComponent.prototype.isInnerClockFace = function (x0, y0, x, y) {
            /* Detect whether time from the inner clock face or not (24 format only) */
            return Math.sqrt(Math.pow(x - x0, 2) + Math.pow(y - y0, 2)) < this.innerClockFaceSize;
        };
        NgxMaterialTimepickerFaceComponent.prototype.decreaseClockHand = function () {
            this.clockHand.nativeElement.style.height = CLOCK_HAND_STYLES.small.height;
            this.clockHand.nativeElement.style.top = CLOCK_HAND_STYLES.small.top;
        };
        NgxMaterialTimepickerFaceComponent.prototype.increaseClockHand = function () {
            this.clockHand.nativeElement.style.height = CLOCK_HAND_STYLES.large.height;
            this.clockHand.nativeElement.style.top = CLOCK_HAND_STYLES.large.top;
        };
        return NgxMaterialTimepickerFaceComponent;
    }());
    NgxMaterialTimepickerFaceComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerFaceComponent, deps: [], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerFaceComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerFaceComponent, selector: "ngx-material-timepicker-face", inputs: { faceTime: "faceTime", selectedTime: "selectedTime", unit: "unit", format: "format", minutesGap: "minutesGap" }, outputs: { timeChange: "timeChange", timeSelected: "timeSelected" }, host: { listeners: { "mousedown": "onMousedown($event)", "click": "selectTime($event)", "touchmove": "selectTime($event.changedTouches[0])", "touchend": "selectTime($event.changedTouches[0])", "mousemove": "selectTime($event)", "mouseup": "onMouseup($event)" } }, viewQueries: [{ propertyName: "clockFace", first: true, predicate: ["clockFace"], descendants: true, static: true }, { propertyName: "clockHand", first: true, predicate: ["clockHand"], descendants: true, static: true }], usesOnChanges: true, ngImport: i0__namespace, template: "<div class=\"clock-face\" #clockFace>\n    <div *ngIf=\"unit !== timeUnit.MINUTE;else minutesFace\" class=\"clock-face__container\">\n        <div class=\"clock-face__number clock-face__number--outer\"\n             [ngStyle]=\"{'transform': 'rotateZ('+ time.angle +'deg) translateX(-50%)'}\"\n             *ngFor=\"let time of faceTime | slice: 0 : 12; trackBy: trackByTime\">\n\t\t\t<span [ngStyle]=\"{'transform': 'rotateZ(-'+ time.angle +'deg)'}\"\n                  [ngClass]=\"{'active': time.time | activeHour: selectedTime.time : isClockFaceDisabled,\n                   'disabled': time.disabled}\">\n                {{time.time | timeLocalizer: timeUnit.HOUR}}\n            </span>\n        </div>\n        <div class=\"clock-face__inner\" *ngIf=\"faceTime.length > 12\"\n             [style.top]=\"'calc(50% - ' + innerClockFaceSize + 'px)'\">\n            <div class=\"clock-face__number clock-face__number--inner\"\n                 [ngStyle]=\"{'transform': 'rotateZ('+ time.angle +'deg) translateX(-50%)'}\"\n                 [style.height.px]=\"innerClockFaceSize\"\n                 *ngFor=\"let time of faceTime | slice: 12 : 24; trackBy: trackByTime\">\n\t\t\t<span [ngStyle]=\"{'transform': 'rotateZ(-'+ time.angle +'deg)'}\"\n                  [ngClass]=\"{'active': time.time | activeHour: selectedTime?.time : isClockFaceDisabled,\n                   'disabled': time.disabled}\">\n                {{time.time | timeLocalizer: timeUnit.HOUR}}</span>\n            </div>\n        </div>\n    </div>\n\n    <span class=\"clock-face__clock-hand\" [ngClass]=\"{'clock-face__clock-hand_minute': unit === timeUnit.MINUTE}\"\n          #clockHand [hidden]=\"isClockFaceDisabled\"></span>\n</div>\n<ng-template #minutesFace>\n    <div class=\"clock-face__container\">\n        <div class=\"clock-face__number clock-face__number--outer\"\n             [ngStyle]=\"{'transform': 'rotateZ('+ time.angle +'deg) translateX(-50%)'}\"\n             *ngFor=\"let time of faceTime; trackBy: trackByTime\">\n\t<span [ngStyle]=\"{'transform': 'rotateZ(-'+ time.angle +'deg)'}\"\n          [ngClass]=\"{'active': time.time | activeMinute: selectedTime?.time:minutesGap:isClockFaceDisabled,\n           'disabled': time.disabled}\">\n\t{{time.time | minutesFormatter: minutesGap | timeLocalizer: timeUnit.MINUTE}}</span>\n        </div>\n    </div>\n</ng-template>\n", styles: [".clock-face{width:290px;height:290px;border-radius:50%;position:relative;display:flex;justify-content:center;padding:20px;box-sizing:border-box;background-color:#f0f0f0}@supports (background-color: var(--clock-face-background-color)){.clock-face{background-color:var(--clock-face-background-color)}}.clock-face__inner{position:absolute}.clock-face__container{margin-left:-2px}.clock-face__number{position:absolute;transform-origin:0 100%;width:50px;text-align:center;z-index:2}.clock-face__number--outer{height:calc(290px / 2 - 20px)}.clock-face__number--outer>span{font-size:16px;color:#6c6c6c}@supports (color: var(--clock-face-time-inactive-color)){.clock-face__number--outer>span{color:var(--clock-face-time-inactive-color)}}.clock-face__number--inner>span{font-size:14px;color:#929292}@supports (color: var(--clock-face-inner-time-inactive-color)){.clock-face__number--inner>span{color:var(--clock-face-inner-time-inactive-color)}}.clock-face__number>span{-webkit-user-select:none;-moz-user-select:none;user-select:none;width:30px;height:30px;display:flex;justify-content:center;align-items:center;margin:auto;border-radius:50%;font-weight:500;font-family:\"Roboto\",sans-serif}@supports (font-family: var(--primary-font-family)){.clock-face__number>span{font-family:var(--primary-font-family)}}.clock-face__number>span.active{background-color:#00bfff;color:#fff}@supports (background-color: var(--clock-hand-color)){.clock-face__number>span.active{background-color:var(--clock-hand-color);color:var(--clock-face-time-active-color)}}.clock-face__number>span.disabled{color:#c5c5c5}@supports (color: var(--clock-face-time-disabled-color)){.clock-face__number>span.disabled{color:var(--clock-face-time-disabled-color)}}.clock-face__clock-hand{height:103px;width:2px;transform-origin:0 100%;position:absolute;top:calc(50% - 103px);z-index:1;background-color:#00bfff}@supports (background-color: var(--clock-hand-color)){.clock-face__clock-hand{background-color:var(--clock-hand-color)}}.clock-face__clock-hand:after{content:\"\";width:7px;height:7px;border-radius:50%;background-color:inherit;position:absolute;bottom:-3px;left:-3.5px}.clock-face__clock-hand_minute:before{content:\"\";width:7px;height:7px;background-color:#fff;border-radius:50%;position:absolute;top:-8px;left:calc(50% - 8px);box-sizing:content-box;border-width:4px;border-style:solid;border-color:#00bfff}@supports (border-color: var(--clock-hand-color)){.clock-face__clock-hand_minute:before{border-color:var(--clock-hand-color)}}@media (max-device-width: 1023px) and (orientation: landscape){.clock-face{width:225px;height:225px;padding:5px}.clock-face__number--outer{height:calc(225px / 2 - 5px)}.clock-face__clock-hand_minute:before{top:0}}\n"], directives: [{ type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: i1__namespace.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { type: i1__namespace.NgStyle, selector: "[ngStyle]", inputs: ["ngStyle"] }, { type: i1__namespace.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }], pipes: { "slice": i1__namespace.SlicePipe, "activeHour": ActiveHourPipe, "timeLocalizer": TimeLocalizerPipe, "activeMinute": ActiveMinutePipe, "minutesFormatter": MinutesFormatterPipe }, changeDetection: i0__namespace.ChangeDetectionStrategy.OnPush });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerFaceComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-face',
                        templateUrl: './ngx-material-timepicker-face.component.html',
                        styleUrls: ['./ngx-material-timepicker-face.component.scss'],
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }]
            }], propDecorators: { faceTime: [{
                    type: i0.Input
                }], selectedTime: [{
                    type: i0.Input
                }], unit: [{
                    type: i0.Input
                }], format: [{
                    type: i0.Input
                }], minutesGap: [{
                    type: i0.Input
                }], timeChange: [{
                    type: i0.Output
                }], timeSelected: [{
                    type: i0.Output
                }], clockFace: [{
                    type: i0.ViewChild,
                    args: ['clockFace', { static: true }]
                }], clockHand: [{
                    type: i0.ViewChild,
                    args: ['clockHand', { static: true }]
                }], onMousedown: [{
                    type: i0.HostListener,
                    args: ['mousedown', ['$event']]
                }], selectTime: [{
                    type: i0.HostListener,
                    args: ['click', ['$event']]
                }, {
                    type: i0.HostListener,
                    args: ['touchmove', ['$event.changedTouches[0]']]
                }, {
                    type: i0.HostListener,
                    args: ['touchend', ['$event.changedTouches[0]']]
                }, {
                    type: i0.HostListener,
                    args: ['mousemove', ['$event']]
                }], onMouseup: [{
                    type: i0.HostListener,
                    args: ['mouseup', ['$event']]
                }] } });
    function roundAngle(angle, step) {
        return Math.round(angle / step) * step;
    }
    function countAngleByCords(x0, y0, x, y, currentAngle) {
        if (y > y0 && x >= x0) { // II quarter
            return 180 - currentAngle;
        }
        else if (y > y0 && x < x0) { // III quarter
            return 180 + currentAngle;
        }
        else if (y < y0 && x < x0) { // IV quarter
            return 360 - currentAngle;
        }
        else { // I quarter
            return currentAngle;
        }
    }

    var NgxMaterialTimepicker24HoursFaceComponent = /** @class */ (function (_super) {
        __extends(NgxMaterialTimepicker24HoursFaceComponent, _super);
        function NgxMaterialTimepicker24HoursFaceComponent() {
            return _super.call(this, 24) || this;
        }
        NgxMaterialTimepicker24HoursFaceComponent.prototype.ngAfterContentInit = function () {
            this.hoursList = TimepickerTimeUtils.disableHours(this.hoursList, {
                min: this.minTime,
                max: this.maxTime,
                format: this.format
            });
        };
        return NgxMaterialTimepicker24HoursFaceComponent;
    }(NgxMaterialTimepickerHoursFace));
    NgxMaterialTimepicker24HoursFaceComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepicker24HoursFaceComponent, deps: [], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepicker24HoursFaceComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepicker24HoursFaceComponent, selector: "ngx-material-timepicker-24-hours-face", usesInheritance: true, ngImport: i0__namespace, template: "<ngx-material-timepicker-face [selectedTime]=\"selectedHour\" [faceTime]=\"hoursList\" [format]=\"format\"\n                              (timeChange)=\"hourChange.next($event)\"\n                              (timeSelected)=\"onTimeSelected($event)\"></ngx-material-timepicker-face>\n", components: [{ type: NgxMaterialTimepickerFaceComponent, selector: "ngx-material-timepicker-face", inputs: ["faceTime", "selectedTime", "unit", "format", "minutesGap"], outputs: ["timeChange", "timeSelected"] }], changeDetection: i0__namespace.ChangeDetectionStrategy.OnPush });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepicker24HoursFaceComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-24-hours-face',
                        templateUrl: 'ngx-material-timepicker-24-hours-face.component.html',
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }]
            }], ctorParameters: function () { return []; } });

    var NgxMaterialTimepicker12HoursFaceComponent = /** @class */ (function (_super) {
        __extends(NgxMaterialTimepicker12HoursFaceComponent, _super);
        function NgxMaterialTimepicker12HoursFaceComponent() {
            return _super.call(this, 12) || this;
        }
        NgxMaterialTimepicker12HoursFaceComponent.prototype.ngOnChanges = function (changes) {
            if (changes['period'] && changes['period'].currentValue) {
                this.hoursList = TimepickerTimeUtils.disableHours(this.hoursList, {
                    min: this.minTime,
                    max: this.maxTime,
                    format: this.format,
                    period: this.period
                });
            }
        };
        return NgxMaterialTimepicker12HoursFaceComponent;
    }(NgxMaterialTimepickerHoursFace));
    NgxMaterialTimepicker12HoursFaceComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepicker12HoursFaceComponent, deps: [], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepicker12HoursFaceComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepicker12HoursFaceComponent, selector: "ngx-material-timepicker-12-hours-face", inputs: { period: "period" }, usesInheritance: true, usesOnChanges: true, ngImport: i0__namespace, template: "<ngx-material-timepicker-face [selectedTime]=\"selectedHour\" [faceTime]=\"hoursList\"\n                              (timeChange)=\"hourChange.next($event)\" (timeSelected)=\"onTimeSelected($event)\"></ngx-material-timepicker-face>\n", components: [{ type: NgxMaterialTimepickerFaceComponent, selector: "ngx-material-timepicker-face", inputs: ["faceTime", "selectedTime", "unit", "format", "minutesGap"], outputs: ["timeChange", "timeSelected"] }], changeDetection: i0__namespace.ChangeDetectionStrategy.OnPush });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepicker12HoursFaceComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-12-hours-face',
                        templateUrl: 'ngx-material-timepicker-12-hours-face.component.html',
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }]
            }], ctorParameters: function () { return []; }, propDecorators: { period: [{
                    type: i0.Input
                }] } });

    var NgxMaterialTimepickerMinutesFaceComponent = /** @class */ (function () {
        function NgxMaterialTimepickerMinutesFaceComponent() {
            this.minutesList = [];
            this.timeUnit = TimeUnit;
            this.minuteChange = new i0.EventEmitter();
        }
        NgxMaterialTimepickerMinutesFaceComponent.prototype.ngOnChanges = function (changes) {
            if (changes['period'] && changes['period'].currentValue) {
                var minutes = TimepickerTimeUtils.getMinutes(this.minutesGap);
                this.minutesList = TimepickerTimeUtils.disableMinutes(minutes, this.selectedHour, {
                    min: this.minTime,
                    max: this.maxTime,
                    format: this.format,
                    period: this.period
                });
            }
        };
        return NgxMaterialTimepickerMinutesFaceComponent;
    }());
    NgxMaterialTimepickerMinutesFaceComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerMinutesFaceComponent, deps: [], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerMinutesFaceComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerMinutesFaceComponent, selector: "ngx-material-timepicker-minutes-face", inputs: { selectedMinute: "selectedMinute", selectedHour: "selectedHour", period: "period", minTime: "minTime", maxTime: "maxTime", format: "format", minutesGap: "minutesGap" }, outputs: { minuteChange: "minuteChange" }, usesOnChanges: true, ngImport: i0__namespace, template: "<ngx-material-timepicker-face [faceTime]=\"minutesList\" [selectedTime]=\"selectedMinute\"\n                              [minutesGap]=\"minutesGap\"\n                              (timeChange)=\"minuteChange.next($event)\" [unit]=\"timeUnit.MINUTE\"></ngx-material-timepicker-face>\n", components: [{ type: NgxMaterialTimepickerFaceComponent, selector: "ngx-material-timepicker-face", inputs: ["faceTime", "selectedTime", "unit", "format", "minutesGap"], outputs: ["timeChange", "timeSelected"] }] });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerMinutesFaceComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-minutes-face',
                        templateUrl: './ngx-material-timepicker-minutes-face.component.html'
                    }]
            }], propDecorators: { selectedMinute: [{
                    type: i0.Input
                }], selectedHour: [{
                    type: i0.Input
                }], period: [{
                    type: i0.Input
                }], minTime: [{
                    type: i0.Input
                }], maxTime: [{
                    type: i0.Input
                }], format: [{
                    type: i0.Input
                }], minutesGap: [{
                    type: i0.Input
                }], minuteChange: [{
                    type: i0.Output
                }] } });

    var NgxMaterialTimepickerButtonComponent = /** @class */ (function () {
        function NgxMaterialTimepickerButtonComponent() {
        }
        return NgxMaterialTimepickerButtonComponent;
    }());
    NgxMaterialTimepickerButtonComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerButtonComponent, deps: [], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerButtonComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerButtonComponent, selector: "ngx-material-timepicker-button", ngImport: i0__namespace, template: "<button class=\"timepicker-button\" type=\"button\">\n  <span><ng-content></ng-content></span>\n</button>\n", styles: [".timepicker-button{display:inline-block;height:36px;min-width:88px;line-height:36px;border:12px;border-radius:2px;background-color:transparent;text-align:center;transition:all .45s cubic-bezier(.23,1,.32,1);overflow:hidden;-webkit-user-select:none;-moz-user-select:none;user-select:none;position:relative;cursor:pointer;outline:none;color:#00bfff}@supports (color: var(--button-color)){.timepicker-button{color:var(--button-color)}}.timepicker-button:hover,.timepicker-button:focus{background-color:#9993}.timepicker-button>span{font-size:14px;text-transform:uppercase;font-weight:600;padding-left:16px;padding-right:16px;font-family:\"Roboto\",sans-serif}@supports (font-family: var(--primary-font-family)){.timepicker-button>span{font-family:var(--primary-font-family)}}\n"] });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerButtonComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-button',
                        templateUrl: './ngx-material-timepicker-button.component.html',
                        styleUrls: ['./ngx-material-timepicker-button.component.scss']
                    }]
            }] });

    var OverlayDirective = /** @class */ (function () {
        function OverlayDirective(eventService) {
            this.eventService = eventService;
        }
        OverlayDirective.prototype.onClick = function (e) {
            if (!this.preventClick) {
                this.eventService.dispatchEvent(e);
            }
            e.preventDefault();
        };
        return OverlayDirective;
    }());
    OverlayDirective.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: OverlayDirective, deps: [{ token: NgxMaterialTimepickerEventService }], target: i0__namespace.ɵɵFactoryTarget.Directive });
    OverlayDirective.ɵdir = i0__namespace.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: OverlayDirective, selector: "[overlay]", inputs: { preventClick: ["overlay", "preventClick"] }, host: { listeners: { "click": "onClick($event)" } }, ngImport: i0__namespace });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: OverlayDirective, decorators: [{
                type: i0.Directive,
                args: [{
                        selector: '[overlay]'
                    }]
            }], ctorParameters: function () { return [{ type: NgxMaterialTimepickerEventService }]; }, propDecorators: { preventClick: [{
                    type: i0.Input,
                    args: ['overlay']
                }], onClick: [{
                    type: i0.HostListener,
                    args: ['click', ['$event']]
                }] } });

    var NgxMaterialTimepickerThemeDirective = /** @class */ (function () {
        function NgxMaterialTimepickerThemeDirective(elementRef) {
            this.element = elementRef.nativeElement;
        }
        NgxMaterialTimepickerThemeDirective.prototype.ngAfterViewInit = function () {
            if (this.theme) {
                this.setTheme(this.theme);
            }
        };
        NgxMaterialTimepickerThemeDirective.prototype.setTheme = function (theme) {
            for (var val in theme) {
                if (theme.hasOwnProperty(val)) {
                    if (typeof theme[val] === 'string') {
                        for (var prop in theme) {
                            if (theme.hasOwnProperty(prop)) {
                                this.element.style.setProperty("--" + camelCaseToDash(prop), theme[prop]);
                            }
                        }
                        return;
                    }
                    this.setTheme(theme[val]);
                }
            }
        };
        return NgxMaterialTimepickerThemeDirective;
    }());
    NgxMaterialTimepickerThemeDirective.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerThemeDirective, deps: [{ token: i0__namespace.ElementRef }], target: i0__namespace.ɵɵFactoryTarget.Directive });
    NgxMaterialTimepickerThemeDirective.ɵdir = i0__namespace.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerThemeDirective, selector: "[ngxMaterialTimepickerTheme]", inputs: { theme: ["ngxMaterialTimepickerTheme", "theme"] }, ngImport: i0__namespace });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerThemeDirective, decorators: [{
                type: i0.Directive,
                args: [{ selector: '[ngxMaterialTimepickerTheme]' }]
            }], ctorParameters: function () { return [{ type: i0__namespace.ElementRef }]; }, propDecorators: { theme: [{
                    type: i0.Input,
                    args: ['ngxMaterialTimepickerTheme']
                }] } });
    function camelCaseToDash(myStr) {
        return myStr.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
    }

    var AnimationState;
    (function (AnimationState) {
        AnimationState["ENTER"] = "enter";
        AnimationState["LEAVE"] = "leave";
    })(AnimationState || (AnimationState = {}));
    var NgxMaterialTimepickerContainerComponent = /** @class */ (function () {
        function NgxMaterialTimepickerContainerComponent(timepickerService, eventService, locale) {
            this.timepickerService = timepickerService;
            this.eventService = eventService;
            this.locale = locale;
            this.timeUnit = TimeUnit;
            this.activeTimeUnit = TimeUnit.HOUR;
            this.unsubscribe = new rxjs.Subject();
        }
        Object.defineProperty(NgxMaterialTimepickerContainerComponent.prototype, "defaultTime", {
            get: function () {
                return this._defaultTime;
            },
            set: function (time) {
                this._defaultTime = time;
                this.setDefaultTime(time);
            },
            enumerable: false,
            configurable: true
        });
        NgxMaterialTimepickerContainerComponent.prototype.onKeydown = function (e) {
            this.eventService.dispatchEvent(e);
            e.stopPropagation();
        };
        NgxMaterialTimepickerContainerComponent.prototype.ngOnInit = function () {
            this.animationState = !this.disableAnimation && AnimationState.ENTER;
            this.defineTime();
            this.selectedHour = this.timepickerService.selectedHour
                .pipe(operators.shareReplay({ bufferSize: 1, refCount: true }));
            this.selectedMinute = this.timepickerService.selectedMinute
                .pipe(operators.shareReplay({ bufferSize: 1, refCount: true }));
            this.selectedPeriod = this.timepickerService.selectedPeriod
                .pipe(operators.shareReplay({ bufferSize: 1, refCount: true }));
            this.timepickerBaseRef.timeUpdated.pipe(operators.takeUntil(this.unsubscribe))
                .subscribe(this.setDefaultTime.bind(this));
        };
        NgxMaterialTimepickerContainerComponent.prototype.onHourChange = function (hour) {
            this.timepickerService.hour = hour;
            this.onTimeChange();
        };
        NgxMaterialTimepickerContainerComponent.prototype.onHourSelected = function (hour) {
            if (!this.hoursOnly) {
                this.changeTimeUnit(TimeUnit.MINUTE);
            }
            this.timepickerBaseRef.hourSelected.next(hour);
        };
        NgxMaterialTimepickerContainerComponent.prototype.onMinuteChange = function (minute) {
            this.timepickerService.minute = minute;
            this.onTimeChange();
        };
        NgxMaterialTimepickerContainerComponent.prototype.changePeriod = function (period) {
            this.timepickerService.period = period;
            this.onTimeChange();
        };
        NgxMaterialTimepickerContainerComponent.prototype.changeTimeUnit = function (unit) {
            this.activeTimeUnit = unit;
        };
        NgxMaterialTimepickerContainerComponent.prototype.setTime = function () {
            this.timepickerBaseRef.timeSet.next(this.timepickerService.getFullTime(this.format));
            this.close();
        };
        NgxMaterialTimepickerContainerComponent.prototype.close = function () {
            if (this.disableAnimation) {
                this.timepickerBaseRef.close();
                return;
            }
            this.animationState = AnimationState.LEAVE;
        };
        NgxMaterialTimepickerContainerComponent.prototype.animationDone = function (event) {
            if (event.phaseName === 'done' && event.toState === AnimationState.LEAVE) {
                this.timepickerBaseRef.close();
            }
        };
        NgxMaterialTimepickerContainerComponent.prototype.ngOnDestroy = function () {
            this.unsubscribe.next();
            this.unsubscribe.complete();
        };
        NgxMaterialTimepickerContainerComponent.prototype.setDefaultTime = function (time) {
            this.timepickerService.setDefaultTimeIfAvailable(time, this.minTime, this.maxTime, this.format, this.minutesGap);
        };
        NgxMaterialTimepickerContainerComponent.prototype.defineTime = function () {
            var minTime = this.minTime;
            if (minTime && (!this.time && !this.defaultTime)) {
                var time = TimeAdapter.fromDateTimeToString(minTime, this.format);
                this.setDefaultTime(time);
            }
        };
        NgxMaterialTimepickerContainerComponent.prototype.onTimeChange = function () {
            var time = TimeAdapter.toLocaleTimeString(this.timepickerService.getFullTime(this.format), {
                locale: this.locale,
                format: this.format
            });
            this.timepickerBaseRef.timeChanged.emit(time);
        };
        return NgxMaterialTimepickerContainerComponent;
    }());
    NgxMaterialTimepickerContainerComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerContainerComponent, deps: [{ token: NgxMaterialTimepickerService }, { token: NgxMaterialTimepickerEventService }, { token: TIME_LOCALE }], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerContainerComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerContainerComponent, selector: "ngx-material-timepicker-container", inputs: { defaultTime: "defaultTime" }, host: { listeners: { "keydown": "onKeydown($event)" } }, providers: [NgxMaterialTimepickerService], ngImport: i0__namespace, template: "<div class=\"timepicker-backdrop-overlay\" [overlay]=\"preventOverlayClick\"\n     [ngClass]=\"{'timepicker-backdrop-overlay--transparent': appendToInput}\"></div>\n<div class=\"timepicker-overlay\">\n    <ngx-material-timepicker-content [appendToInput]=\"appendToInput\"\n                                     [inputElement]=\"inputElement\"\n                                     [ngxMaterialTimepickerTheme]=\"theme\">\n        <div class=\"timepicker\"\n             [@timepicker]=\"animationState\"\n             (@timepicker.done)=\"animationDone($event)\"\n             [ngClass]=\"timepickerClass\">\n            <header class=\"timepicker__header\">\n                <ngx-material-timepicker-dial [format]=\"format\" [hour]=\"(selectedHour | async)?.time\"\n                                              [minute]=\"(selectedMinute | async)?.time\"\n                                              [period]=\"selectedPeriod | async\"\n                                              [activeTimeUnit]=\"activeTimeUnit\"\n                                              [minTime]=\"minTime\"\n                                              [maxTime]=\"maxTime\"\n                                              [isEditable]=\"enableKeyboardInput\"\n                                              [editableHintTmpl]=\"editableHintTmpl\"\n                                              [minutesGap]=\"minutesGap\"\n                                              [hoursOnly]=\"hoursOnly\"\n                                              (periodChanged)=\"changePeriod($event)\"\n                                              (timeUnitChanged)=\"changeTimeUnit($event)\"\n                                              (hourChanged)=\"onHourChange($event)\"\n                                              (minuteChanged)=\"onMinuteChange($event)\"\n                ></ngx-material-timepicker-dial>\n            </header>\n            <div class=\"timepicker__main-content\">\n                <div class=\"timepicker__body\" [ngSwitch]=\"activeTimeUnit\">\n                    <div *ngSwitchCase=\"timeUnit.HOUR\">\n                        <ngx-material-timepicker-24-hours-face *ngIf=\"format === 24;else ampmHours\"\n                                                               (hourChange)=\"onHourChange($event)\"\n                                                               [selectedHour]=\"selectedHour | async\"\n                                                               [minTime]=\"minTime\"\n                                                               [maxTime]=\"maxTime\"\n                                                               [format]=\"format\"\n                                                               (hourSelected)=\"onHourSelected($event)\"></ngx-material-timepicker-24-hours-face>\n                        <ng-template #ampmHours>\n                            <ngx-material-timepicker-12-hours-face\n                                (hourChange)=\"onHourChange($event)\"\n                                [selectedHour]=\"selectedHour | async\"\n                                [period]=\"selectedPeriod | async\"\n                                [minTime]=\"minTime\"\n                                [maxTime]=\"maxTime\"\n                                (hourSelected)=\"onHourSelected($event)\"></ngx-material-timepicker-12-hours-face>\n                        </ng-template>\n                    </div>\n                    <ngx-material-timepicker-minutes-face *ngSwitchCase=\"timeUnit.MINUTE\"\n                                                          [selectedMinute]=\"selectedMinute | async\"\n                                                          [selectedHour]=\"(selectedHour | async)?.time\"\n                                                          [minTime]=\"minTime\"\n                                                          [maxTime]=\"maxTime\"\n                                                          [format]=\"format\"\n                                                          [period]=\"selectedPeriod | async\"\n                                                          [minutesGap]=\"minutesGap\"\n                                                          (minuteChange)=\"onMinuteChange($event)\"></ngx-material-timepicker-minutes-face>\n                </div>\n                <div class=\"timepicker__actions\">\n                    <div (click)=\"close()\">\n                        <!--suppress HtmlUnknownAttribute -->\n                        <ng-container\n                            *ngTemplateOutlet=\"cancelBtnTmpl ? cancelBtnTmpl : cancelBtnDefault\"></ng-container>\n                    </div>\n                    <div (click)=\"setTime()\">\n                        <!--suppress HtmlUnknownAttribute -->\n                        <ng-container\n                            *ngTemplateOutlet=\"confirmBtnTmpl ? confirmBtnTmpl : confirmBtnDefault\"></ng-container>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </ngx-material-timepicker-content>\n</div>\n<ng-template #cancelBtnDefault>\n    <ngx-material-timepicker-button>Cancel</ngx-material-timepicker-button>\n</ng-template>\n<ng-template #confirmBtnDefault>\n    <ngx-material-timepicker-button>Ok</ngx-material-timepicker-button>\n</ng-template>\n", styles: [":host{--body-background-color: #fff;--primary-font-family: \"Roboto\", sans-serif;--button-color: deepskyblue;--dial-active-color: #fff;--dial-inactive-color: rgba(255, 255, 255, .5);--dial-background-color: deepskyblue;--dial-editable-active-color: deepskyblue;--dial-editable-background-color: #fff;--clock-face-time-active-color: #fff;--clock-face-time-inactive-color: #6c6c6c;--clock-face-inner-time-inactive-color: #929292;--clock-face-time-disabled-color: #c5c5c5;--clock-face-background-color: #f0f0f0;--clock-hand-color: deepskyblue}.timepicker-backdrop-overlay{position:fixed;top:0;bottom:0;right:0;left:0;background-color:#0000004d;z-index:999;pointer-events:auto}.timepicker-backdrop-overlay--transparent{background-color:transparent}.timepicker-overlay{position:fixed;top:0;left:0;width:100%;height:100%;display:flex;justify-content:center;align-items:center;z-index:999;pointer-events:none}.timepicker{width:300px;border-radius:2px;box-shadow:#00000040 0 14px 45px,#00000038 0 10px 18px;outline:none;position:static;z-index:999;pointer-events:auto}.timepicker__header{padding:15px 30px;background-color:#00bfff}@supports (background-color: var(--dial-background-color)){.timepicker__header{background-color:var(--dial-background-color)}}.timepicker__body{padding:15px 5px;display:flex;justify-content:center;align-items:center;background-color:#fff}@supports (background-color: var(--body-background-color)){.timepicker__body{background-color:var(--body-background-color)}}.timepicker__actions{display:flex;justify-content:flex-end;padding:15px;background-color:#fff}@supports (background-color: var(--body-background-color)){.timepicker__actions{background-color:var(--body-background-color)}}@media (max-device-width: 1023px) and (orientation: landscape){.timepicker{display:flex;width:515px}.timepicker__header{display:flex;align-items:center}.timepicker__main-content{display:flex;flex-direction:column;width:100%}.timepicker__actions{padding:5px;margin-top:-1px}}\n"], components: [{ type: NgxMaterialTimepickerContentComponent, selector: "ngx-material-timepicker-content", inputs: ["appendToInput", "inputElement"] }, { type: NgxMaterialTimepickerDialComponent, selector: "ngx-material-timepicker-dial", inputs: ["editableHintTmpl", "hour", "minute", "format", "period", "activeTimeUnit", "minTime", "maxTime", "isEditable", "minutesGap", "hoursOnly"], outputs: ["periodChanged", "timeUnitChanged", "hourChanged", "minuteChanged"] }, { type: NgxMaterialTimepicker24HoursFaceComponent, selector: "ngx-material-timepicker-24-hours-face" }, { type: NgxMaterialTimepicker12HoursFaceComponent, selector: "ngx-material-timepicker-12-hours-face", inputs: ["period"] }, { type: NgxMaterialTimepickerMinutesFaceComponent, selector: "ngx-material-timepicker-minutes-face", inputs: ["selectedMinute", "selectedHour", "period", "minTime", "maxTime", "format", "minutesGap"], outputs: ["minuteChange"] }, { type: NgxMaterialTimepickerButtonComponent, selector: "ngx-material-timepicker-button" }], directives: [{ type: OverlayDirective, selector: "[overlay]", inputs: ["overlay"] }, { type: i1__namespace.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: NgxMaterialTimepickerThemeDirective, selector: "[ngxMaterialTimepickerTheme]", inputs: ["ngxMaterialTimepickerTheme"] }, { type: i1__namespace.NgSwitch, selector: "[ngSwitch]", inputs: ["ngSwitch"] }, { type: i1__namespace.NgSwitchCase, selector: "[ngSwitchCase]", inputs: ["ngSwitchCase"] }, { type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: i1__namespace.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet"] }], pipes: { "async": i1__namespace.AsyncPipe }, animations: [
            animations.trigger('timepicker', [
                animations.transition("* => " + AnimationState.ENTER, [
                    animations.style({ transform: 'translateY(-30%)' }),
                    animations.animate('0.2s ease-out', animations.style({ transform: 'translateY(0)' }))
                ]),
                animations.transition(AnimationState.ENTER + " => " + AnimationState.LEAVE, [
                    animations.style({ transform: 'translateY(0)', opacity: 1 }),
                    animations.animate('0.2s ease-out', animations.style({ transform: 'translateY(-30%)', opacity: 0 }))
                ])
            ])
        ] });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerContainerComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-container',
                        templateUrl: './ngx-material-timepicker-container.component.html',
                        styleUrls: ['./ngx-material-timepicker-container.component.scss'],
                        animations: [
                            animations.trigger('timepicker', [
                                animations.transition("* => " + AnimationState.ENTER, [
                                    animations.style({ transform: 'translateY(-30%)' }),
                                    animations.animate('0.2s ease-out', animations.style({ transform: 'translateY(0)' }))
                                ]),
                                animations.transition(AnimationState.ENTER + " => " + AnimationState.LEAVE, [
                                    animations.style({ transform: 'translateY(0)', opacity: 1 }),
                                    animations.animate('0.2s ease-out', animations.style({ transform: 'translateY(-30%)', opacity: 0 }))
                                ])
                            ])
                        ],
                        providers: [NgxMaterialTimepickerService]
                    }]
            }], ctorParameters: function () {
            return [{ type: NgxMaterialTimepickerService }, { type: NgxMaterialTimepickerEventService }, { type: undefined, decorators: [{
                            type: i0.Inject,
                            args: [TIME_LOCALE]
                        }] }];
        }, propDecorators: { defaultTime: [{
                    type: i0.Input
                }], onKeydown: [{
                    type: i0.HostListener,
                    args: ['keydown', ['$event']]
                }] } });

    var DomService = /** @class */ (function () {
        function DomService(cfr, appRef, injector, document) {
            this.cfr = cfr;
            this.appRef = appRef;
            this.injector = injector;
            this.document = document;
        }
        DomService.prototype.appendTimepickerToBody = function (timepicker, config) {
            var _this = this;
            this.componentRef = this.cfr.resolveComponentFactory(timepicker).create(this.injector);
            Object.keys(config).forEach(function (key) { return _this.componentRef.instance[key] = config[key]; });
            this.appRef.attachView(this.componentRef.hostView);
            var domElement = this.componentRef.hostView
                .rootNodes[0];
            this.document.body.appendChild(domElement);
        };
        DomService.prototype.destroyTimepicker = function () {
            this.componentRef.destroy();
            this.appRef.detachView(this.componentRef.hostView);
        };
        return DomService;
    }());
    DomService.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: DomService, deps: [{ token: i0__namespace.ComponentFactoryResolver }, { token: i0__namespace.ApplicationRef }, { token: i0__namespace.Injector }, { token: i1.DOCUMENT, optional: true }], target: i0__namespace.ɵɵFactoryTarget.Injectable });
    DomService.ɵprov = i0__namespace.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: DomService, providedIn: 'root' });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: DomService, decorators: [{
                type: i0.Injectable,
                args: [{
                        providedIn: 'root'
                    }]
            }], ctorParameters: function () {
            return [{ type: i0__namespace.ComponentFactoryResolver }, { type: i0__namespace.ApplicationRef }, { type: i0__namespace.Injector }, { type: undefined, decorators: [{
                            type: i0.Optional
                        }, {
                            type: i0.Inject,
                            args: [i1.DOCUMENT]
                        }] }];
        } });

    var ESCAPE = 27;
    var NgxMaterialTimepickerComponent = /** @class */ (function () {
        function NgxMaterialTimepickerComponent(eventService, domService) {
            this.eventService = eventService;
            this.domService = domService;
            this.timeUpdated = new rxjs.Subject();
            this.isEsc = true;
            this.hoursOnly = false;
            this.timeSet = new i0.EventEmitter();
            this.opened = new i0.EventEmitter();
            this.closed = new i0.EventEmitter();
            this.hourSelected = new i0.EventEmitter();
            this.timeChanged = new i0.EventEmitter();
            this.unsubscribe = new rxjs.Subject();
        }
        Object.defineProperty(NgxMaterialTimepickerComponent.prototype, "ngxMaterialTimepickerTheme", {
            /**
             * @deprecated Since version 5.1.1. Will be deleted on version 6.0.0. Use @Input() theme instead
             */
            set: function (theme) {
                console.warn("'ngxMaterialTimepickerTheme' is deprecated. Use 'theme' instead");
                this._ngxMaterialTimepickerTheme = theme;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerComponent.prototype, "format", {
            get: function () {
                return this.timepickerInput ? this.timepickerInput.format : this._format;
            },
            set: function (value) {
                this._format = value === 24 ? 24 : 12;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerComponent.prototype, "minutesGap", {
            get: function () {
                return this._minutesGap;
            },
            set: function (gap) {
                if (gap == null) {
                    return;
                }
                gap = Math.floor(gap);
                this._minutesGap = gap <= 59 ? gap : 1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerComponent.prototype, "minTime", {
            get: function () {
                return this.timepickerInput ? this.timepickerInput.min : this.min;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerComponent.prototype, "maxTime", {
            get: function () {
                return this.timepickerInput ? this.timepickerInput.max : this.max;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerComponent.prototype, "disabled", {
            get: function () {
                return this.timepickerInput && this.timepickerInput.disabled;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerComponent.prototype, "time", {
            get: function () {
                return this.timepickerInput && this.timepickerInput.value;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxMaterialTimepickerComponent.prototype, "inputElement", {
            get: function () {
                return this.timepickerInput && this.timepickerInput.element;
            },
            enumerable: false,
            configurable: true
        });
        /***
         * Register an input with this timepicker.
         * input - The timepicker input to register with this timepicker
         */
        NgxMaterialTimepickerComponent.prototype.registerInput = function (input) {
            if (this.timepickerInput) {
                throw Error('A Timepicker can only be associated with a single input.');
            }
            this.timepickerInput = input;
        };
        NgxMaterialTimepickerComponent.prototype.open = function () {
            this.domService.appendTimepickerToBody(NgxMaterialTimepickerContainerComponent, {
                timepickerBaseRef: this,
                time: this.time,
                defaultTime: this.defaultTime,
                maxTime: this.maxTime,
                minTime: this.minTime,
                format: this.format,
                minutesGap: this.minutesGap,
                disableAnimation: this.disableAnimation,
                cancelBtnTmpl: this.cancelBtnTmpl,
                confirmBtnTmpl: this.confirmBtnTmpl,
                editableHintTmpl: this.editableHintTmpl,
                disabled: this.disabled,
                enableKeyboardInput: this.enableKeyboardInput,
                preventOverlayClick: this.preventOverlayClick,
                appendToInput: this.appendToInput,
                hoursOnly: this.hoursOnly,
                theme: this.theme || this._ngxMaterialTimepickerTheme,
                timepickerClass: this.timepickerClass,
                inputElement: this.inputElement
            });
            this.opened.next();
            this.subscribeToEvents();
        };
        NgxMaterialTimepickerComponent.prototype.close = function () {
            this.domService.destroyTimepicker();
            this.closed.next();
            this.unsubscribeFromEvents();
        };
        NgxMaterialTimepickerComponent.prototype.updateTime = function (time) {
            this.timeUpdated.next(time);
        };
        NgxMaterialTimepickerComponent.prototype.subscribeToEvents = function () {
            var _this = this;
            rxjs.merge(this.eventService.backdropClick, this.eventService.keydownEvent.pipe(operators.filter(function (e) { return e.keyCode === ESCAPE && _this.isEsc; })))
                .pipe(operators.takeUntil(this.unsubscribe))
                .subscribe(function () { return _this.close(); });
        };
        NgxMaterialTimepickerComponent.prototype.unsubscribeFromEvents = function () {
            this.unsubscribe.next();
            this.unsubscribe.complete();
        };
        return NgxMaterialTimepickerComponent;
    }());
    NgxMaterialTimepickerComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerComponent, deps: [{ token: NgxMaterialTimepickerEventService }, { token: DomService }], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerComponent, selector: "ngx-material-timepicker", inputs: { cancelBtnTmpl: "cancelBtnTmpl", editableHintTmpl: "editableHintTmpl", confirmBtnTmpl: "confirmBtnTmpl", isEsc: ["ESC", "isEsc"], enableKeyboardInput: "enableKeyboardInput", preventOverlayClick: "preventOverlayClick", disableAnimation: "disableAnimation", appendToInput: "appendToInput", hoursOnly: "hoursOnly", defaultTime: "defaultTime", timepickerClass: "timepickerClass", theme: "theme", min: "min", max: "max", ngxMaterialTimepickerTheme: "ngxMaterialTimepickerTheme", format: "format", minutesGap: "minutesGap" }, outputs: { timeSet: "timeSet", opened: "opened", closed: "closed", hourSelected: "hourSelected", timeChanged: "timeChanged" }, ngImport: i0__namespace, template: '', isInline: true });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker',
                        template: '',
                    }]
            }], ctorParameters: function () { return [{ type: NgxMaterialTimepickerEventService }, { type: DomService }]; }, propDecorators: { cancelBtnTmpl: [{
                    type: i0.Input
                }], editableHintTmpl: [{
                    type: i0.Input
                }], confirmBtnTmpl: [{
                    type: i0.Input
                }], isEsc: [{
                    type: i0.Input,
                    args: ['ESC']
                }], enableKeyboardInput: [{
                    type: i0.Input
                }], preventOverlayClick: [{
                    type: i0.Input
                }], disableAnimation: [{
                    type: i0.Input
                }], appendToInput: [{
                    type: i0.Input
                }], hoursOnly: [{
                    type: i0.Input
                }], defaultTime: [{
                    type: i0.Input
                }], timepickerClass: [{
                    type: i0.Input
                }], theme: [{
                    type: i0.Input
                }], min: [{
                    type: i0.Input
                }], max: [{
                    type: i0.Input
                }], ngxMaterialTimepickerTheme: [{
                    type: i0.Input
                }], format: [{
                    type: i0.Input
                }], minutesGap: [{
                    type: i0.Input
                }], timeSet: [{
                    type: i0.Output
                }], opened: [{
                    type: i0.Output
                }], closed: [{
                    type: i0.Output
                }], hourSelected: [{
                    type: i0.Output
                }], timeChanged: [{
                    type: i0.Output
                }] } });

    /* To override a default toggle icon */
    var NgxMaterialTimepickerToggleIconDirective = /** @class */ (function () {
        function NgxMaterialTimepickerToggleIconDirective() {
        }
        return NgxMaterialTimepickerToggleIconDirective;
    }());
    NgxMaterialTimepickerToggleIconDirective.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerToggleIconDirective, deps: [], target: i0__namespace.ɵɵFactoryTarget.Directive });
    NgxMaterialTimepickerToggleIconDirective.ɵdir = i0__namespace.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerToggleIconDirective, selector: "[ngxMaterialTimepickerToggleIcon]", ngImport: i0__namespace });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerToggleIconDirective, decorators: [{
                type: i0.Directive,
                args: [{ selector: '[ngxMaterialTimepickerToggleIcon]' }]
            }] });

    var NgxMaterialTimepickerToggleComponent = /** @class */ (function () {
        function NgxMaterialTimepickerToggleComponent() {
        }
        Object.defineProperty(NgxMaterialTimepickerToggleComponent.prototype, "disabled", {
            get: function () {
                return this._disabled === undefined ? this.timepicker.disabled : this._disabled;
            },
            set: function (value) {
                this._disabled = value;
            },
            enumerable: false,
            configurable: true
        });
        NgxMaterialTimepickerToggleComponent.prototype.open = function (event) {
            if (this.timepicker) {
                this.timepicker.open();
                event.stopPropagation();
            }
        };
        return NgxMaterialTimepickerToggleComponent;
    }());
    NgxMaterialTimepickerToggleComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerToggleComponent, deps: [], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxMaterialTimepickerToggleComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxMaterialTimepickerToggleComponent, selector: "ngx-material-timepicker-toggle", inputs: { timepicker: ["for", "timepicker"], disabled: "disabled" }, queries: [{ propertyName: "customIcon", first: true, predicate: NgxMaterialTimepickerToggleIconDirective, descendants: true, static: true }], ngImport: i0__namespace, template: "<button class=\"ngx-material-timepicker-toggle\" (click)=\"open($event)\" [disabled]=\"disabled\" type=\"button\">\n    <svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" width=\"24px\" height=\"24px\" *ngIf=\"!customIcon\">\n        <path\n            d=\"M 12 2 C 6.4889971 2 2 6.4889971 2 12 C 2 17.511003                   6.4889971 22 12 22 C 17.511003 22 22 17.511003 22 12 C 22 6.4889971 17.511003 2 12 2 z M 12 4 C 16.430123 4 20 7.5698774 20 12 C 20 16.430123 16.430123 20 12 20 C 7.5698774 20 4 16.430123 4 12 C 4 7.5698774 7.5698774 4 12 4 z M 11 6 L 11 12.414062 L 15.292969 16.707031 L 16.707031 15.292969 L 13 11.585938 L 13 6 L 11 6 z\"/>\n    </svg>\n\n    <ng-content select=\"[ngxMaterialTimepickerToggleIcon]\"></ng-content>\n</button>\n", styles: [".ngx-material-timepicker-toggle{display:flex;justify-content:center;align-items:center;padding:4px;background-color:transparent;border-radius:50%;text-align:center;border:none;outline:none;-webkit-user-select:none;-moz-user-select:none;user-select:none;transition:background-color .3s;cursor:pointer}.ngx-material-timepicker-toggle:focus{background-color:#00000012}\n"], directives: [{ type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerToggleComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-material-timepicker-toggle',
                        templateUrl: 'ngx-material-timepicker-toggle.component.html',
                        styleUrls: ['ngx-material-timepicker-toggle.component.scss']
                    }]
            }], propDecorators: { timepicker: [{
                    type: i0.Input,
                    args: ['for']
                }], disabled: [{
                    type: i0.Input
                }], customIcon: [{
                    type: i0.ContentChild,
                    args: [NgxMaterialTimepickerToggleIconDirective, { static: true }]
                }] } });

    var TimepickerDirective = /** @class */ (function () {
        function TimepickerDirective(elementRef, locale) {
            this.elementRef = elementRef;
            this.locale = locale;
            this._format = 12;
            this._value = '';
            this.timepickerSubscriptions = [];
            this.onTouched = function () {
            };
            this.onChange = function () {
            };
        }
        Object.defineProperty(TimepickerDirective.prototype, "format", {
            get: function () {
                return this._format;
            },
            set: function (value) {
                this._format = value === 24 ? 24 : 12;
                var isDynamicallyChanged = value && (this.previousFormat && this.previousFormat !== this._format);
                if (isDynamicallyChanged) {
                    this.value = this._value;
                    this._timepicker.updateTime(this._value);
                }
                this.previousFormat = this._format;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TimepickerDirective.prototype, "min", {
            get: function () {
                return this._min;
            },
            set: function (value) {
                console.log(value);
                if (typeof value === 'string') {
                    this._min = TimeAdapter.parseTime(value, { locale: this.locale, format: this.format });
                    return;
                }
                this._min = value;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TimepickerDirective.prototype, "max", {
            get: function () {
                return this._max;
            },
            set: function (value) {
                if (typeof value === 'string') {
                    this._max = TimeAdapter.parseTime(value, { locale: this.locale, format: this.format });
                    return;
                }
                this._max = value;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TimepickerDirective.prototype, "timepicker", {
            set: function (picker) {
                this.registerTimepicker(picker);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TimepickerDirective.prototype, "value", {
            get: function () {
                if (!this._value) {
                    return '';
                }
                return TimeAdapter.toLocaleTimeString(this._value, { format: this.format, locale: this.locale });
            },
            set: function (value) {
                if (!value) {
                    this._value = '';
                    this.updateInputValue();
                    return;
                }
                this.setTimeIfAvailable(value);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TimepickerDirective.prototype, "element", {
            get: function () {
                return this.elementRef && this.elementRef.nativeElement;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TimepickerDirective.prototype, "defaultTime", {
            set: function (time) {
                this._timepicker.defaultTime = TimeAdapter.formatTime(time, { locale: this.locale, format: this.format });
            },
            enumerable: false,
            configurable: true
        });
        TimepickerDirective.prototype.updateValue = function (value) {
            this.value = value;
            this.onChange(value);
        };
        TimepickerDirective.prototype.ngOnChanges = function (changes) {
            var _a;
            var value = (_a = changes === null || changes === void 0 ? void 0 : changes.value) === null || _a === void 0 ? void 0 : _a.currentValue;
            if (value) {
                // Call setTimeIfAvailable after @Input setters
                this.setTimeIfAvailable(value);
                this.defaultTime = value;
            }
        };
        TimepickerDirective.prototype.onClick = function (event) {
            if (!this.disableClick) {
                this._timepicker.open();
                event.stopPropagation();
            }
        };
        TimepickerDirective.prototype.writeValue = function (value) {
            this.value = value;
            if (value) {
                this.defaultTime = value;
            }
        };
        TimepickerDirective.prototype.registerOnChange = function (fn) {
            this.onChange = fn;
        };
        TimepickerDirective.prototype.registerOnTouched = function (fn) {
            this.onTouched = fn;
        };
        TimepickerDirective.prototype.setDisabledState = function (isDisabled) {
            this.disabled = isDisabled;
        };
        TimepickerDirective.prototype.ngOnDestroy = function () {
            this.timepickerSubscriptions.forEach(function (s) { return s.unsubscribe(); });
        };
        TimepickerDirective.prototype.registerTimepicker = function (picker) {
            var _this = this;
            if (picker) {
                this._timepicker = picker;
                this._timepicker.registerInput(this);
                this.timepickerSubscriptions.push(this._timepicker.timeSet.subscribe(function (time) {
                    _this.value = time;
                    _this.onChange(_this.value);
                    _this.onTouched();
                    _this.defaultTime = _this._value;
                }));
            }
            else {
                throw new Error('NgxMaterialTimepickerComponent is not defined.' +
                    ' Please make sure you passed the timepicker to ngxTimepicker directive');
            }
        };
        TimepickerDirective.prototype.updateInputValue = function () {
            this.elementRef.nativeElement.value = this.value;
        };
        TimepickerDirective.prototype.setTimeIfAvailable = function (value) {
            var _a;
            var time = TimeAdapter.formatTime(value, { locale: this.locale, format: this.format });
            var isAvailable = TimeAdapter.isTimeAvailable(time, this._min, this._max, 'minutes', (_a = this._timepicker) === null || _a === void 0 ? void 0 : _a.minutesGap, this._format);
            if (isAvailable) {
                this._value = time;
                this.updateInputValue();
            }
            else {
                this.value = null;
                console.warn('Selected time doesn\'t match min or max value');
            }
        };
        return TimepickerDirective;
    }());
    TimepickerDirective.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimepickerDirective, deps: [{ token: i0__namespace.ElementRef }, { token: TIME_LOCALE }], target: i0__namespace.ɵɵFactoryTarget.Directive });
    TimepickerDirective.ɵdir = i0__namespace.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: TimepickerDirective, selector: "[ngxTimepicker]", inputs: { format: "format", min: "min", max: "max", timepicker: ["ngxTimepicker", "timepicker"], value: "value", disabled: "disabled", disableClick: "disableClick" }, host: { listeners: { "change": "updateValue($event.target.value)", "blur": "onTouched()", "click": "onClick($event)" }, properties: { "disabled": "disabled" } }, providers: [
            {
                provide: i4.NG_VALUE_ACCESSOR,
                useExisting: TimepickerDirective,
                multi: true
            }
        ], usesOnChanges: true, ngImport: i0__namespace });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimepickerDirective, decorators: [{
                type: i0.Directive,
                args: [{
                        selector: '[ngxTimepicker]',
                        providers: [
                            {
                                provide: i4.NG_VALUE_ACCESSOR,
                                useExisting: TimepickerDirective,
                                multi: true
                            }
                        ],
                        host: {
                            '[disabled]': 'disabled',
                            '(change)': 'updateValue($event.target.value)',
                            '(blur)': 'onTouched()',
                        },
                    }]
            }], ctorParameters: function () {
            return [{ type: i0__namespace.ElementRef }, { type: undefined, decorators: [{
                            type: i0.Inject,
                            args: [TIME_LOCALE]
                        }] }];
        }, propDecorators: { format: [{
                    type: i0.Input
                }], min: [{
                    type: i0.Input
                }], max: [{
                    type: i0.Input
                }], timepicker: [{
                    type: i0.Input,
                    args: ['ngxTimepicker']
                }], value: [{
                    type: i0.Input
                }], disabled: [{
                    type: i0.Input
                }], disableClick: [{
                    type: i0.Input
                }], onClick: [{
                    type: i0.HostListener,
                    args: ['click', ['$event']]
                }] } });

    var TimeFormatterPipe = /** @class */ (function () {
        function TimeFormatterPipe() {
        }
        TimeFormatterPipe.prototype.transform = function (time, timeUnit) {
            if (time == null || time === '') {
                return time;
            }
            switch (timeUnit) {
                case TimeUnit.HOUR:
                    return luxon.DateTime.fromObject({ hour: +time }).toFormat('HH');
                case TimeUnit.MINUTE:
                    return luxon.DateTime.fromObject({ minute: +time }).toFormat('mm');
                default:
                    throw new Error('no such time unit');
            }
        };
        return TimeFormatterPipe;
    }());
    TimeFormatterPipe.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeFormatterPipe, deps: [], target: i0__namespace.ɵɵFactoryTarget.Pipe });
    TimeFormatterPipe.ɵpipe = i0__namespace.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeFormatterPipe, name: "timeFormatter" });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: TimeFormatterPipe, decorators: [{
                type: i0.Pipe,
                args: [{
                        name: 'timeFormatter'
                    }]
            }] });

    var NgxTimepickerTimeControlComponent = /** @class */ (function () {
        function NgxTimepickerTimeControlComponent(timeParser) {
            this.timeParser = timeParser;
            this.timeChanged = new i0.EventEmitter();
        }
        NgxTimepickerTimeControlComponent.prototype.ngOnChanges = function (changes) {
            if (changes.timeList && this.time != null) {
                if (this.isSelectedTimeDisabled(this.time)) {
                    this.setAvailableTime();
                }
            }
        };
        NgxTimepickerTimeControlComponent.prototype.changeTime = function (event) {
            event.stopPropagation();
            var char = String.fromCharCode(event.keyCode);
            var time = concatTime(String(this.time), char);
            this.changeTimeIfValid(time);
        };
        NgxTimepickerTimeControlComponent.prototype.onKeydown = function (event) {
            event.stopPropagation();
            if (!isDigit(event)) {
                event.preventDefault();
            }
            switch (event.key) {
                case 'ArrowUp':
                    this.increase();
                    break;
                case 'ArrowDown':
                    this.decrease();
                    break;
            }
            if (this.preventTyping && event.key !== 'Tab') {
                event.preventDefault();
            }
        };
        NgxTimepickerTimeControlComponent.prototype.increase = function () {
            if (!this.disabled) {
                var nextTime = +this.time + (this.minutesGap || 1);
                if (nextTime > this.max) {
                    nextTime = this.min;
                }
                if (this.isSelectedTimeDisabled(nextTime)) {
                    nextTime = this.getAvailableTime(nextTime, this.getNextAvailableTime.bind(this));
                }
                if (nextTime !== this.time) {
                    this.timeChanged.emit(nextTime);
                }
            }
        };
        NgxTimepickerTimeControlComponent.prototype.decrease = function () {
            if (!this.disabled) {
                var previousTime = +this.time - (this.minutesGap || 1);
                if (previousTime < this.min) {
                    previousTime = this.minutesGap ? this.max - (this.minutesGap - 1) : this.max;
                }
                if (this.isSelectedTimeDisabled(previousTime)) {
                    previousTime = this.getAvailableTime(previousTime, this.getPrevAvailableTime.bind(this));
                }
                if (previousTime !== this.time) {
                    this.timeChanged.emit(previousTime);
                }
            }
        };
        NgxTimepickerTimeControlComponent.prototype.onFocus = function () {
            this.isFocused = true;
            this.previousTime = this.time;
        };
        NgxTimepickerTimeControlComponent.prototype.onBlur = function () {
            this.isFocused = false;
            if (this.previousTime !== this.time) {
                this.changeTimeIfValid(+this.time);
            }
        };
        NgxTimepickerTimeControlComponent.prototype.onModelChange = function (value) {
            this.time = +this.timeParser.transform(value, this.timeUnit);
        };
        NgxTimepickerTimeControlComponent.prototype.changeTimeIfValid = function (value) {
            if (!isNaN(value)) {
                this.time = value;
                if (this.time > this.max) {
                    var timeString = String(value);
                    this.time = +timeString[timeString.length - 1];
                }
                if (this.time < this.min) {
                    this.time = this.min;
                }
                this.timeChanged.emit(this.time);
            }
        };
        NgxTimepickerTimeControlComponent.prototype.isSelectedTimeDisabled = function (time) {
            return this.timeList.find(function (faceTime) { return faceTime.time === time; }).disabled;
        };
        NgxTimepickerTimeControlComponent.prototype.getNextAvailableTime = function (index) {
            var timeCollection = this.timeList;
            var maxValue = timeCollection.length;
            for (var i = index + 1; i < maxValue; i++) {
                var time = timeCollection[i];
                if (!time.disabled) {
                    return time.time;
                }
            }
        };
        NgxTimepickerTimeControlComponent.prototype.getPrevAvailableTime = function (index) {
            for (var i = index; i >= 0; i--) {
                var time = this.timeList[i];
                if (!time.disabled) {
                    return time.time;
                }
            }
        };
        NgxTimepickerTimeControlComponent.prototype.getAvailableTime = function (currentTime, fn) {
            var currentTimeIndex = this.timeList.findIndex(function (time) { return time.time === currentTime; });
            var availableTime = fn(currentTimeIndex);
            return availableTime != null ? availableTime : this.time;
        };
        NgxTimepickerTimeControlComponent.prototype.setAvailableTime = function () {
            var availableTime = this.timeList.find(function (t) { return !t.disabled; });
            if (availableTime != null) {
                this.time = availableTime.time;
                this.timeChanged.emit(this.time);
            }
        };
        return NgxTimepickerTimeControlComponent;
    }());
    NgxTimepickerTimeControlComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxTimepickerTimeControlComponent, deps: [{ token: TimeParserPipe }], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxTimepickerTimeControlComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxTimepickerTimeControlComponent, selector: "ngx-timepicker-time-control", inputs: { time: "time", min: "min", max: "max", placeholder: "placeholder", timeUnit: "timeUnit", disabled: "disabled", timeList: "timeList", preventTyping: "preventTyping", minutesGap: "minutesGap" }, outputs: { timeChanged: "timeChanged" }, providers: [TimeParserPipe], usesOnChanges: true, ngImport: i0__namespace, template: "<div class=\"ngx-timepicker-control\" [ngClass]=\"{'ngx-timepicker-control--active': isFocused}\">\n    <!--suppress HtmlFormInputWithoutLabel -->\n    <input class=\"ngx-timepicker-control__input\"\n           maxlength=\"2\"\n           [ngModel]=\"time | timeParser: timeUnit | timeLocalizer: timeUnit : true\"\n           (ngModelChange)=\"onModelChange($event)\"\n           [placeholder]=\"placeholder\"\n           [disabled]=\"disabled\"\n           (keydown)=\"onKeydown($event)\"\n           (keypress)=\"changeTime($event)\"\n           (focus)=\"onFocus()\"\n           (blur)=\"onBlur()\">\n    <div class=\"ngx-timepicker-control__arrows\">\n            <span class=\"ngx-timepicker-control__arrow\" role=\"button\" (click)=\"increase()\">\n                &#9650;\n            </span>\n        <span class=\"ngx-timepicker-control__arrow\" role=\"button\" (click)=\"decrease()\">\n                &#9660;\n            </span>\n    </div>\n</div>\n", styles: [".ngx-timepicker-control{position:relative;display:flex;width:60px;height:30px;padding:0 5px;box-sizing:border-box}.ngx-timepicker-control--active:after{content:\"\";position:absolute;bottom:-2px;left:0;width:100%;height:1px;background-color:#00bfff}.ngx-timepicker-control__input{width:100%;height:100%;padding:0 5px 0 0;border:0;font-size:1rem;color:inherit;outline:none;text-align:center}.ngx-timepicker-control__input:disabled{background-color:transparent}.ngx-timepicker-control__arrows{position:absolute;right:2px;top:0;display:flex;flex-direction:column}.ngx-timepicker-control__arrow{font-size:11px;color:#0006;cursor:pointer;transition:color .2s;-webkit-user-select:none;-moz-user-select:none;user-select:none}.ngx-timepicker-control__arrow:hover{color:#000000e6}\n"], directives: [{ type: i1__namespace.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i4__namespace.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { type: i4__namespace.MaxLengthValidator, selector: "[maxlength][formControlName],[maxlength][formControl],[maxlength][ngModel]", inputs: ["maxlength"] }, { type: i4__namespace.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { type: i4__namespace.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }], pipes: { "timeLocalizer": TimeLocalizerPipe, "timeParser": TimeParserPipe }, changeDetection: i0__namespace.ChangeDetectionStrategy.OnPush });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxTimepickerTimeControlComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-timepicker-time-control',
                        templateUrl: './ngx-timepicker-time-control.component.html',
                        styleUrls: ['./ngx-timepicker-time-control.component.scss'],
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        providers: [TimeParserPipe],
                    }]
            }], ctorParameters: function () { return [{ type: TimeParserPipe }]; }, propDecorators: { time: [{
                    type: i0.Input
                }], min: [{
                    type: i0.Input
                }], max: [{
                    type: i0.Input
                }], placeholder: [{
                    type: i0.Input
                }], timeUnit: [{
                    type: i0.Input
                }], disabled: [{
                    type: i0.Input
                }], timeList: [{
                    type: i0.Input
                }], preventTyping: [{
                    type: i0.Input
                }], minutesGap: [{
                    type: i0.Input
                }], timeChanged: [{
                    type: i0.Output
                }] } });
    function concatTime(currentTime, nextTime) {
        var isNumber = /\d/.test(nextTime);
        if (isNumber) {
            var time = currentTime + nextTime;
            return +time;
        }
    }

    var NgxTimepickerPeriodSelectorComponent = /** @class */ (function () {
        function NgxTimepickerPeriodSelectorComponent(locale) {
            this.locale = locale;
            this.periodSelected = new i0.EventEmitter();
            this.period = TimePeriod;
            this.meridiems = luxon.Info.meridiems({ locale: this.locale });
        }
        Object.defineProperty(NgxTimepickerPeriodSelectorComponent.prototype, "selectedPeriod", {
            set: function (period) {
                if (period) {
                    var periods = [TimePeriod.AM, TimePeriod.PM];
                    this.localizedPeriod = this.meridiems[periods.indexOf(period)];
                }
            },
            enumerable: false,
            configurable: true
        });
        NgxTimepickerPeriodSelectorComponent.prototype.open = function () {
            if (!this.disabled) {
                this.isOpened = true;
            }
        };
        NgxTimepickerPeriodSelectorComponent.prototype.select = function (period) {
            this.periodSelected.next(period);
            this.isOpened = false;
        };
        NgxTimepickerPeriodSelectorComponent.prototype.backdropClick = function () {
            this.isOpened = false;
        };
        return NgxTimepickerPeriodSelectorComponent;
    }());
    NgxTimepickerPeriodSelectorComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxTimepickerPeriodSelectorComponent, deps: [{ token: TIME_LOCALE }], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxTimepickerPeriodSelectorComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxTimepickerPeriodSelectorComponent, selector: "ngx-timepicker-period-selector", inputs: { isOpened: "isOpened", disabled: "disabled", selectedPeriod: "selectedPeriod" }, outputs: { periodSelected: "periodSelected" }, ngImport: i0__namespace, template: "<div class=\"period\">\n    <div class=\"period-control\">\n        <button class=\"period-control__button period__btn--default\"\n                [ngClass]=\"{'period-control__button--disabled': disabled}\"\n                type=\"button\"\n                (click)=\"open()\">\n            <span>{{localizedPeriod}}</span>\n            <span class=\"period-control__arrow\">&#9660;</span>\n        </button>\n    </div>\n    <ul class=\"period-selector\" @scaleInOut *ngIf=\"isOpened\" [timepickerAutofocus]=\"true\">\n        <li>\n            <button class=\"period-selector__button period__btn--default\"\n                    type=\"button\"\n                    (click)=\"select(period.AM)\"\n                    [ngClass]=\"{'period-selector__button--active': localizedPeriod === meridiems[0]}\">{{meridiems[0]}}</button>\n        </li>\n        <li>\n            <button class=\"period-selector__button period__btn--default\"\n                    type=\"button\"\n                    (click)=\"select(period.PM)\"\n                    [ngClass]=\"{'period-selector__button--active': localizedPeriod === meridiems[1]}\">{{meridiems[1]}}</button>\n        </li>\n    </ul>\n</div>\n<div class=\"overlay\" (click)=\"backdropClick()\" *ngIf=\"isOpened\"></div>\n", styles: [".period{position:relative}.period__btn--default{padding:0;border:none;background-color:transparent;cursor:pointer;text-align:left;-webkit-user-select:none;-moz-user-select:none;user-select:none;-webkit-tap-highlight-color:transparent;outline:none}.period-control{position:relative}.period-control__button{position:relative;width:60px;font-size:1rem;color:inherit;text-align:center}.period-control__button:not(.period-control__button--disabled):focus:after{content:\"\";position:absolute;bottom:-8px;left:0;width:100%;height:1px;background-color:#00bfff}.period-control__arrow{margin-left:10px;font-size:12px;color:#0006}.period-selector{position:absolute;top:calc(50% - 50px);right:calc(-50% + -50px);max-width:135px;width:150px;padding:6px 0;margin:0;list-style:none;background-color:#f5f5f5;box-shadow:0 1px 3px #0003,0 1px 1px #00000024,0 2px 1px -1px #0000001f;z-index:201}.period-selector__button{width:100%;height:48px;padding:0 16px;line-height:48px}.period-selector__button--active{color:#00bfff}.period-selector__button:focus{background-color:#eee}.overlay{position:fixed;width:100%;height:100%;top:0;left:0;background-color:transparent;z-index:200}\n"], directives: [{ type: i1__namespace.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: AutofocusDirective, selector: "[timepickerAutofocus]", inputs: ["timepickerAutofocus"] }], animations: [
            animations.trigger('scaleInOut', [
                animations.transition(':enter', [
                    animations.style({ transform: 'scale(0)', opacity: 0 }),
                    animations.animate(200, animations.style({ transform: 'scale(1)', opacity: 1 }))
                ]),
                animations.transition(':leave', [
                    animations.animate(200, animations.style({ transform: 'scale(0)', opacity: 0 }))
                ])
            ])
        ], changeDetection: i0__namespace.ChangeDetectionStrategy.OnPush });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxTimepickerPeriodSelectorComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-timepicker-period-selector',
                        templateUrl: 'ngx-timepicker-period-selector.component.html',
                        styleUrls: ['./ngx-timepicker-period-selector.component.scss'],
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        animations: [
                            animations.trigger('scaleInOut', [
                                animations.transition(':enter', [
                                    animations.style({ transform: 'scale(0)', opacity: 0 }),
                                    animations.animate(200, animations.style({ transform: 'scale(1)', opacity: 1 }))
                                ]),
                                animations.transition(':leave', [
                                    animations.animate(200, animations.style({ transform: 'scale(0)', opacity: 0 }))
                                ])
                            ])
                        ]
                    }]
            }], ctorParameters: function () {
            return [{ type: undefined, decorators: [{
                            type: i0.Inject,
                            args: [TIME_LOCALE]
                        }] }];
        }, propDecorators: { isOpened: [{
                    type: i0.Input
                }], disabled: [{
                    type: i0.Input
                }], selectedPeriod: [{
                    type: i0.Input
                }], periodSelected: [{
                    type: i0.Output
                }] } });

    var NgxTimepickerFieldComponent = /** @class */ (function () {
        function NgxTimepickerFieldComponent(timepickerService, locale) {
            this.timepickerService = timepickerService;
            this.locale = locale;
            this.minHour = 1;
            this.maxHour = 12;
            this.timeUnit = TimeUnit;
            this.buttonAlign = 'right';
            this.timeChanged = new i0.EventEmitter();
            this._format = 12;
            this.unsubscribe$ = new rxjs.Subject();
            this.isFirstTimeChange = true;
            this.onChange = function () {
            };
        }
        Object.defineProperty(NgxTimepickerFieldComponent.prototype, "format", {
            get: function () {
                return this._format;
            },
            set: function (value) {
                this._format = value === 24 ? 24 : 12;
                this.minHour = this._format === 12 ? 1 : 0;
                this.maxHour = this._format === 12 ? 12 : 23;
                this.hoursList = TimepickerTimeUtils.getHours(this._format);
                var isDynamicallyChanged = value && (this.previousFormat && this.previousFormat !== this._format);
                if (isDynamicallyChanged) {
                    this.updateTime(this.timepickerTime);
                }
                this.previousFormat = this._format;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxTimepickerFieldComponent.prototype, "min", {
            get: function () {
                return this._min;
            },
            set: function (value) {
                if (typeof value === 'string') {
                    this._min = TimeAdapter.parseTime(value, { locale: this.locale, format: this.format });
                    return;
                }
                this._min = value;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxTimepickerFieldComponent.prototype, "max", {
            get: function () {
                return this._max;
            },
            set: function (value) {
                if (typeof value === 'string') {
                    this._max = TimeAdapter.parseTime(value, { locale: this.locale, format: this.format });
                    return;
                }
                this._max = value;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxTimepickerFieldComponent.prototype, "defaultTime", {
            get: function () {
                return this._defaultTime;
            },
            set: function (val) {
                this._defaultTime = val;
                this.isDefaultTime = !!val;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(NgxTimepickerFieldComponent.prototype, "minutesGap", {
            get: function () {
                return this._minutesGap;
            },
            set: function (gap) {
                if (gap == null) {
                    return;
                }
                gap = Math.floor(gap);
                this._minutesGap = gap <= 59 ? gap : 1;
            },
            enumerable: false,
            configurable: true
        });
        NgxTimepickerFieldComponent.prototype.ngOnInit = function () {
            var _this = this;
            this.initTime(this.defaultTime);
            this.hoursList = TimepickerTimeUtils.getHours(this._format);
            this.minutesList = TimepickerTimeUtils.getMinutes();
            this.isTimeRangeSet = !!(this.min || this.max);
            this.hour$ = this.timepickerService.selectedHour.pipe(operators.tap(function (clockTime) { return _this.selectedHour = clockTime.time; }), operators.map(this.changeDefaultTimeValue.bind(this)), operators.tap(function () { return _this.isTimeRangeSet && _this.updateAvailableMinutes(); }));
            this.minute$ = this.timepickerService.selectedMinute.pipe(operators.map(this.changeDefaultTimeValue.bind(this)), operators.tap(function () { return _this.isFirstTimeChange = false; }));
            if (this.format === 12) {
                this.timepickerService.selectedPeriod.pipe(operators.distinctUntilChanged(), operators.tap(function (period) { return _this.period = period; }), operators.tap(function (period) { return _this.isChangePeriodDisabled = _this.isPeriodDisabled(period); }), operators.takeUntil(this.unsubscribe$)).subscribe(function () { return _this.isTimeRangeSet && _this.updateAvailableTime(); });
            }
            else if (this.isTimeRangeSet) {
                this.updateAvailableTime();
            }
        };
        NgxTimepickerFieldComponent.prototype.writeValue = function (val) {
            if (val) {
                this.initTime(val);
            }
            else {
                this.resetTime();
            }
        };
        NgxTimepickerFieldComponent.prototype.registerOnTouched = function (fn) {
        };
        NgxTimepickerFieldComponent.prototype.registerOnChange = function (fn) {
            this.onChange = fn;
        };
        NgxTimepickerFieldComponent.prototype.setDisabledState = function (isDisabled) {
            this.disabled = isDisabled;
        };
        NgxTimepickerFieldComponent.prototype.changeHour = function (hour) {
            this.timepickerService.hour = this.hoursList.find(function (h) { return h.time === hour; });
            this.changeTime();
        };
        NgxTimepickerFieldComponent.prototype.changeMinute = function (minute) {
            this.timepickerService.minute = this.minutesList.find(function (m) { return m.time === minute; });
            this.changeTime();
        };
        NgxTimepickerFieldComponent.prototype.changePeriod = function (period) {
            this.timepickerService.period = period;
            this.changeTime();
        };
        NgxTimepickerFieldComponent.prototype.onTimeSet = function (time) {
            this.updateTime(time);
            this.emitLocalTimeChange(time);
        };
        NgxTimepickerFieldComponent.prototype.ngOnDestroy = function () {
            this.unsubscribe$.next();
            this.unsubscribe$.complete();
        };
        NgxTimepickerFieldComponent.prototype.changeTime = function () {
            var time = this.timepickerService.getFullTime(this.format);
            this.timepickerTime = time;
            this.emitLocalTimeChange(time);
        };
        NgxTimepickerFieldComponent.prototype.resetTime = function () {
            this.timepickerService.hour = { angle: 0, time: null };
            this.timepickerService.minute = { angle: 0, time: null };
        };
        NgxTimepickerFieldComponent.prototype.emitLocalTimeChange = function (time) {
            var localTime = TimeAdapter.toLocaleTimeString(time, { format: this.format, locale: this.locale });
            this.onChange(localTime);
            this.timeChanged.emit(localTime);
        };
        NgxTimepickerFieldComponent.prototype.changeDefaultTimeValue = function (clockFaceTime) {
            if (!this.isDefaultTime && this.isFirstTimeChange) {
                return Object.assign(Object.assign({}, clockFaceTime), { time: null });
            }
            return clockFaceTime;
        };
        NgxTimepickerFieldComponent.prototype.updateAvailableHours = function () {
            this.hoursList = TimepickerTimeUtils.disableHours(this.hoursList, {
                min: this.min,
                max: this.max,
                format: this.format,
                period: this.period
            });
        };
        NgxTimepickerFieldComponent.prototype.updateAvailableMinutes = function () {
            this.minutesList = TimepickerTimeUtils.disableMinutes(this.minutesList, this.selectedHour, {
                min: this.min,
                max: this.max,
                format: this.format,
                period: this.period
            });
        };
        NgxTimepickerFieldComponent.prototype.updateAvailableTime = function () {
            this.updateAvailableHours();
            if (this.selectedHour) {
                this.updateAvailableMinutes();
            }
        };
        NgxTimepickerFieldComponent.prototype.updateTime = function (time) {
            if (time) {
                var formattedTime = TimeAdapter.formatTime(time, { locale: this.locale, format: this.format });
                this.timepickerService.setDefaultTimeIfAvailable(formattedTime, this.min, this.max, this.format);
                this.timepickerTime = formattedTime;
            }
        };
        NgxTimepickerFieldComponent.prototype.initTime = function (time) {
            var isDefaultTimeAvailable = TimeAdapter
                .isTimeAvailable(time, this.min, this.max, 'minutes', null, this.format);
            if (!isDefaultTimeAvailable) {
                if (this.min) {
                    this.updateTime(TimeAdapter.fromDateTimeToString(this.min, this.format));
                    return;
                }
                if (this.max) {
                    this.updateTime(TimeAdapter.fromDateTimeToString(this.max, this.format));
                    return;
                }
            }
            this.updateTime(time);
        };
        NgxTimepickerFieldComponent.prototype.isPeriodDisabled = function (period) {
            return TimepickerTimeUtils.disableHours(TimepickerTimeUtils.getHours(12), {
                min: this.min,
                max: this.max,
                format: 12,
                period: period === TimePeriod.AM ? TimePeriod.PM : TimePeriod.AM
            }).every(function (time) { return time.disabled; });
        };
        return NgxTimepickerFieldComponent;
    }());
    NgxTimepickerFieldComponent.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxTimepickerFieldComponent, deps: [{ token: NgxMaterialTimepickerService }, { token: TIME_LOCALE }], target: i0__namespace.ɵɵFactoryTarget.Component });
    NgxTimepickerFieldComponent.ɵcmp = i0__namespace.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.17", type: NgxTimepickerFieldComponent, selector: "ngx-timepicker-field", inputs: { disabled: "disabled", toggleIcon: "toggleIcon", buttonAlign: "buttonAlign", clockTheme: "clockTheme", controlOnly: "controlOnly", cancelBtnTmpl: "cancelBtnTmpl", confirmBtnTmpl: "confirmBtnTmpl", format: "format", min: "min", max: "max", defaultTime: "defaultTime", minutesGap: "minutesGap" }, outputs: { timeChanged: "timeChanged" }, providers: [
            NgxMaterialTimepickerService,
            {
                provide: i4.NG_VALUE_ACCESSOR,
                useExisting: NgxTimepickerFieldComponent,
                multi: true
            }
        ], ngImport: i0__namespace, template: "<div class=\"ngx-timepicker\" [ngClass]=\"{'ngx-timepicker--disabled': disabled}\">\n    <ngx-timepicker-time-control\n        class=\"ngx-timepicker__control--first\"\n        [placeholder]=\"'HH'\"\n        [time]=\"(hour$ | async)?.time\"\n        [min]=\"minHour\"\n        [max]=\"maxHour\"\n        [timeUnit]=\"timeUnit.HOUR\"\n        [disabled]=\"disabled\"\n        [timeList]=\"hoursList\"\n        [preventTyping]=\"isTimeRangeSet\"\n        (timeChanged)=\"changeHour($event)\"></ngx-timepicker-time-control>\n    <span class=\"ngx-timepicker__time-colon ngx-timepicker__control--second\">:</span>\n    <ngx-timepicker-time-control\n        class=\"ngx-timepicker__control--third\"\n        [placeholder]=\"'MM'\"\n        [time]=\"(minute$ | async)?.time\"\n        [min]=\"0\"\n        [max]=\"59\"\n        [timeUnit]=\"timeUnit.MINUTE\"\n        [disabled]=\"disabled\"\n        [timeList]=\"minutesList\"\n        [preventTyping]=\"isTimeRangeSet\"\n        [minutesGap]=\"minutesGap\"\n        (timeChanged)=\"changeMinute($event)\"></ngx-timepicker-time-control>\n    <ngx-timepicker-period-selector\n        class=\"ngx-timepicker__control--forth\"\n        [selectedPeriod]=\"period\"\n        [disabled]=\"disabled || isChangePeriodDisabled\"\n        (periodSelected)=\"changePeriod($event)\"\n        *ngIf=\"format !== 24\"></ngx-timepicker-period-selector>\n    <ngx-material-timepicker-toggle\n        class=\"ngx-timepicker__toggle\"\n        *ngIf=\"!controlOnly\"\n        [ngClass]=\"{'ngx-timepicker__toggle--left': buttonAlign === 'left'}\"\n        [for]=\"timepicker\"\n        [disabled]=\"disabled\">\n        <span ngxMaterialTimepickerToggleIcon>\n            <!--suppress HtmlUnknownAttribute -->\n            <ng-container *ngTemplateOutlet=\"toggleIcon || defaultIcon\"></ng-container>\n        </span>\n    </ngx-material-timepicker-toggle>\n</div>\n<ngx-material-timepicker\n    [min]=\"min\"\n    [max]=\"max\"\n    [theme]=\"clockTheme\"\n    [defaultTime]=\"timepickerTime\"\n    [format]=\"format\"\n    [cancelBtnTmpl]=\"cancelBtnTmpl\"\n    [confirmBtnTmpl]=\"confirmBtnTmpl\"\n    [minutesGap]=\"minutesGap\"\n    (timeSet)=\"onTimeSet($event)\" #timepicker></ngx-material-timepicker>\n\n<ng-template #defaultIcon>\n    <svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\" width=\"24px\" height=\"24px\">\n        <!--suppress CheckEmptyScriptTag -->\n        <path\n            d=\"M 12 2 C 6.4889971 2 2 6.4889971 2 12 C 2 17.511003                   6.4889971 22 12 22 C 17.511003 22 22 17.511003 22 12 C 22 6.4889971 17.511003 2 12 2 z M 12 4 C 16.430123 4 20 7.5698774 20 12 C 20 16.430123 16.430123 20 12 20 C 7.5698774 20 4 16.430123 4 12 C 4 7.5698774 7.5698774 4 12 4 z M 11 6 L 11 12.414062 L 15.292969 16.707031 L 16.707031 15.292969 L 13 11.585938 L 13 6 L 11 6 z\"/>\n    </svg>\n</ng-template>\n", styles: [".ngx-timepicker{display:flex;align-items:center;height:100%;border-bottom:1px solid rgba(0,0,0,.12)}.ngx-timepicker--disabled{background:rgba(0,0,0,.07);pointer-events:none}.ngx-timepicker__time-colon{margin-left:10px}.ngx-timepicker__control--first{order:1}.ngx-timepicker__control--second{order:2}.ngx-timepicker__control--third{order:3}.ngx-timepicker__control--forth{order:4}.ngx-timepicker__toggle{order:4}.ngx-timepicker__toggle--left{order:0}\n"], components: [{ type: NgxTimepickerTimeControlComponent, selector: "ngx-timepicker-time-control", inputs: ["time", "min", "max", "placeholder", "timeUnit", "disabled", "timeList", "preventTyping", "minutesGap"], outputs: ["timeChanged"] }, { type: NgxTimepickerPeriodSelectorComponent, selector: "ngx-timepicker-period-selector", inputs: ["isOpened", "disabled", "selectedPeriod"], outputs: ["periodSelected"] }, { type: NgxMaterialTimepickerToggleComponent, selector: "ngx-material-timepicker-toggle", inputs: ["for", "disabled"] }, { type: NgxMaterialTimepickerComponent, selector: "ngx-material-timepicker", inputs: ["cancelBtnTmpl", "editableHintTmpl", "confirmBtnTmpl", "ESC", "enableKeyboardInput", "preventOverlayClick", "disableAnimation", "appendToInput", "hoursOnly", "defaultTime", "timepickerClass", "theme", "min", "max", "ngxMaterialTimepickerTheme", "format", "minutesGap"], outputs: ["timeSet", "opened", "closed", "hourSelected", "timeChanged"] }], directives: [{ type: i1__namespace.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { type: i1__namespace.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { type: NgxMaterialTimepickerToggleIconDirective, selector: "[ngxMaterialTimepickerToggleIcon]" }, { type: i1__namespace.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet"] }], pipes: { "async": i1__namespace.AsyncPipe }, changeDetection: i0__namespace.ChangeDetectionStrategy.OnPush });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxTimepickerFieldComponent, decorators: [{
                type: i0.Component,
                args: [{
                        selector: 'ngx-timepicker-field',
                        templateUrl: './ngx-timepicker-field.component.html',
                        styleUrls: ['./ngx-timepicker-field.component.scss'],
                        providers: [
                            NgxMaterialTimepickerService,
                            {
                                provide: i4.NG_VALUE_ACCESSOR,
                                useExisting: NgxTimepickerFieldComponent,
                                multi: true
                            }
                        ],
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }]
            }], ctorParameters: function () {
            return [{ type: NgxMaterialTimepickerService }, { type: undefined, decorators: [{
                            type: i0.Inject,
                            args: [TIME_LOCALE]
                        }] }];
        }, propDecorators: { disabled: [{
                    type: i0.Input
                }], toggleIcon: [{
                    type: i0.Input
                }], buttonAlign: [{
                    type: i0.Input
                }], clockTheme: [{
                    type: i0.Input
                }], controlOnly: [{
                    type: i0.Input
                }], cancelBtnTmpl: [{
                    type: i0.Input
                }], confirmBtnTmpl: [{
                    type: i0.Input
                }], format: [{
                    type: i0.Input
                }], min: [{
                    type: i0.Input
                }], max: [{
                    type: i0.Input
                }], defaultTime: [{
                    type: i0.Input
                }], minutesGap: [{
                    type: i0.Input
                }], timeChanged: [{
                    type: i0.Output
                }] } });

    var NgxMaterialTimepickerModule = /** @class */ (function () {
        function NgxMaterialTimepickerModule() {
        }
        // tslint:disable-next-line:max-line-length
        NgxMaterialTimepickerModule.setOpts = function (locale, numberingSystem) {
            if (numberingSystem === void 0) { numberingSystem = TimeAdapter.DEFAULT_NUMBERING_SYSTEM; }
            return {
                ngModule: NgxMaterialTimepickerModule,
                providers: [
                    { provide: TIME_LOCALE, useValue: locale },
                    { provide: NUMBERING_SYSTEM, useValue: numberingSystem }
                ]
            };
        };
        return NgxMaterialTimepickerModule;
    }());
    NgxMaterialTimepickerModule.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerModule, deps: [], target: i0__namespace.ɵɵFactoryTarget.NgModule });
    NgxMaterialTimepickerModule.ɵmod = i0__namespace.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerModule, declarations: [NgxMaterialTimepickerComponent,
            NgxMaterialTimepicker24HoursFaceComponent,
            NgxMaterialTimepicker12HoursFaceComponent,
            NgxMaterialTimepickerMinutesFaceComponent,
            NgxMaterialTimepickerFaceComponent,
            NgxMaterialTimepickerToggleComponent,
            NgxMaterialTimepickerButtonComponent,
            NgxMaterialTimepickerDialComponent,
            NgxMaterialTimepickerDialControlComponent,
            NgxMaterialTimepickerPeriodComponent,
            TimeFormatterPipe,
            TimepickerDirective,
            OverlayDirective,
            NgxMaterialTimepickerToggleIconDirective,
            AutofocusDirective,
            MinutesFormatterPipe,
            NgxMaterialTimepickerThemeDirective,
            NgxTimepickerFieldComponent,
            NgxTimepickerTimeControlComponent,
            NgxTimepickerPeriodSelectorComponent,
            TimeLocalizerPipe,
            TimeParserPipe,
            ActiveHourPipe,
            ActiveMinutePipe,
            NgxMaterialTimepickerContainerComponent,
            NgxMaterialTimepickerContentComponent,
            AppendToInputDirective], imports: [i1.CommonModule,
            i4.FormsModule,
            i4.ReactiveFormsModule], exports: [NgxMaterialTimepickerComponent,
            NgxMaterialTimepickerToggleComponent,
            NgxTimepickerFieldComponent,
            TimepickerDirective,
            NgxMaterialTimepickerToggleIconDirective,
            NgxMaterialTimepickerThemeDirective] });
    NgxMaterialTimepickerModule.ɵinj = i0__namespace.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerModule, imports: [[
                i1.CommonModule,
                i4.FormsModule,
                i4.ReactiveFormsModule,
            ]] });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0__namespace, type: NgxMaterialTimepickerModule, decorators: [{
                type: i0.NgModule,
                args: [{
                        imports: [
                            i1.CommonModule,
                            i4.FormsModule,
                            i4.ReactiveFormsModule,
                        ],
                        exports: [
                            NgxMaterialTimepickerComponent,
                            NgxMaterialTimepickerToggleComponent,
                            NgxTimepickerFieldComponent,
                            TimepickerDirective,
                            NgxMaterialTimepickerToggleIconDirective,
                            NgxMaterialTimepickerThemeDirective,
                        ],
                        declarations: [
                            NgxMaterialTimepickerComponent,
                            NgxMaterialTimepicker24HoursFaceComponent,
                            NgxMaterialTimepicker12HoursFaceComponent,
                            NgxMaterialTimepickerMinutesFaceComponent,
                            NgxMaterialTimepickerFaceComponent,
                            NgxMaterialTimepickerToggleComponent,
                            NgxMaterialTimepickerButtonComponent,
                            NgxMaterialTimepickerDialComponent,
                            NgxMaterialTimepickerDialControlComponent,
                            NgxMaterialTimepickerPeriodComponent,
                            TimeFormatterPipe,
                            TimepickerDirective,
                            OverlayDirective,
                            NgxMaterialTimepickerToggleIconDirective,
                            AutofocusDirective,
                            MinutesFormatterPipe,
                            NgxMaterialTimepickerThemeDirective,
                            NgxTimepickerFieldComponent,
                            NgxTimepickerTimeControlComponent,
                            NgxTimepickerPeriodSelectorComponent,
                            TimeLocalizerPipe,
                            TimeParserPipe,
                            ActiveHourPipe,
                            ActiveMinutePipe,
                            NgxMaterialTimepickerContainerComponent,
                            NgxMaterialTimepickerContentComponent,
                            AppendToInputDirective
                        ],
                    }]
            }] });

    /**
     * Generated bundle index. Do not edit.
     */

    exports.NUMBERING_SYSTEM = NUMBERING_SYSTEM;
    exports.NgxMaterialTimepickerComponent = NgxMaterialTimepickerComponent;
    exports.NgxMaterialTimepickerModule = NgxMaterialTimepickerModule;
    exports.NgxMaterialTimepickerThemeDirective = NgxMaterialTimepickerThemeDirective;
    exports.NgxMaterialTimepickerToggleComponent = NgxMaterialTimepickerToggleComponent;
    exports.NgxMaterialTimepickerToggleIconDirective = NgxMaterialTimepickerToggleIconDirective;
    exports.NgxTimepickerFieldComponent = NgxTimepickerFieldComponent;
    exports.TIME_LOCALE = TIME_LOCALE;
    exports.TimepickerDirective = TimepickerDirective;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=ngx-material-timepicker.umd.js.map
