"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultLang = exports.getTranslationEntryPaths = exports.getTranslationFiles = exports.getTranslationsRoot = exports.getTranslationKey = exports.hasFiles = exports.hasSubdirs = exports.setFileContent = exports.getJsonFileContent = exports.updateConfig = exports.createConfig = void 0;
const schematics_consts_1 = require("../schematics.consts");
const array_1 = require("./array");
const projects_1 = require("./projects");
const p = require("path");
const config_1 = require("./config");
function createConfig(host, langs, rootTranslationsPath = 'assets/i18n/') {
    if (!host.get(schematics_consts_1.CONFIG_FILE)) {
        const config = `module.exports = {
  rootTranslationsPath: '${rootTranslationsPath}',
  langs: [${(0, array_1.stringifyList)(langs)}],
  keysManager: {}
};`;
        host.create(schematics_consts_1.CONFIG_FILE, config);
    }
}
exports.createConfig = createConfig;
function updateConfig(host, config) {
    const originalConfig = (0, config_1.getConfig)();
    if (!originalConfig || Object.keys(originalConfig).length === 0) {
        return createConfig(host, config.langs, config.rootTranslationsPath);
    }
    const stringifyConfig = JSON.stringify(Object.assign(Object.assign({}, config), originalConfig), null, 2);
    const content = `module.exports = ${stringifyConfig};`;
    host.overwrite(schematics_consts_1.CONFIG_FILE, content);
}
exports.updateConfig = updateConfig;
function getJsonFileContent(fileName, dir, parser = JSON.parse) {
    return parser(dir.file(fileName).content.toString('utf-8'));
}
exports.getJsonFileContent = getJsonFileContent;
function setFileContent(host, dirPath, fileName, content) {
    return host.overwrite(p.join(dirPath, fileName), JSON.stringify(content, null, 2));
}
exports.setFileContent = setFileContent;
function hasSubdirs(dir) {
    return dir.subdirs && dir.subdirs.length;
}
exports.hasSubdirs = hasSubdirs;
function hasFiles(dir) {
    return dir.subfiles && dir.subfiles.length;
}
exports.hasFiles = hasFiles;
function getTranslationKey(prefix = '', key) {
    return prefix ? `${prefix}.${key}` : key;
}
exports.getTranslationKey = getTranslationKey;
function getTranslationsRoot(host, options) {
    const translocoConfig = (0, config_1.getConfig)();
    if (options.translationPath) {
        return options.translationPath;
    }
    else if (translocoConfig && translocoConfig.rootTranslationsPath) {
        return translocoConfig.rootTranslationsPath;
    }
    else {
        const project = (0, projects_1.getProject)(host, options.project);
        const rootPath = (project && project.sourceRoot) || 'src';
        return p.join(rootPath, 'assets', 'i18n');
    }
}
exports.getTranslationsRoot = getTranslationsRoot;
function getTranslationFiles(host, root, parser) {
    const rootDir = host.getDir(root);
    return rootDir.subfiles.map((fileName) => ({
        lang: fileName.split('.')[0],
        translation: getJsonFileContent(fileName, rootDir, parser),
    }));
}
exports.getTranslationFiles = getTranslationFiles;
function getTranslationEntryPaths(host, rootDirPath) {
    const translocoConfig = (0, config_1.getConfig)();
    if (translocoConfig.scopePathMap &&
        Object.keys(translocoConfig.scopePathMap).length) {
        return Object.entries(translocoConfig.scopePathMap).map(([scope, path]) => ({
            scope,
            path,
        }));
    }
    const rootDir = host.getDir(rootDirPath);
    return rootDir.subdirs.map((subDir) => ({
        scope: subDir,
        path: p.join(rootDirPath, subDir),
    }));
}
exports.getTranslationEntryPaths = getTranslationEntryPaths;
function getDefaultLang(options) {
    return options.defaultLang || (0, config_1.getConfig)().defaultLang;
}
exports.getDefaultLang = getDefaultLang;
//# sourceMappingURL=transloco.js.map