"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTranslateFiles = exports.createTranslateFilesFromOptions = exports.checkIfTranslationFilesExist = exports.typescriptTranslationFileCreator = exports.jsonTranslationFileCreator = void 0;
const schematics_1 = require("@angular-devkit/schematics");
const schema_1 = require("../ng-add/schema");
const p = require("path");
const fs = require("fs");
function jsonTranslationFileCreator(source, lang, path) {
    return source.create(p.join(path, `${lang}.json`), `{
  "title": "transloco ${lang}",
  "dynamic": "transloco {{value}}"
}
`);
}
exports.jsonTranslationFileCreator = jsonTranslationFileCreator;
function typescriptTranslationFileCreator(source, lang, path) {
    return source.create(p.join(path, `${lang}.ts`), `export default {
  title: "transloco ${lang}",
  dynamic: "transloco {{value}}"
};
`);
}
exports.typescriptTranslationFileCreator = typescriptTranslationFileCreator;
function checkIfTranslationFilesExist(path, langs, extension, skipThrow) {
    for (const lang of langs) {
        const filePath = p.resolve(`${path}/${lang}${extension}`);
        if (fs.existsSync(filePath)) {
            if (skipThrow) {
                return true;
            }
            throw new schematics_1.SchematicsException(`Translation file ${filePath} is already exist, please use --skip-creation`);
        }
    }
    return false;
}
exports.checkIfTranslationFilesExist = checkIfTranslationFilesExist;
function createTranslateFilesFromOptions(host, options, translationFilePath) {
    const extension = options.translateType === schema_1.TranslationFileTypes.Typescript ? '.ts' : '.json';
    const translationCreator = options.translateType === schema_1.TranslationFileTypes.Typescript
        ? typescriptTranslationFileCreator
        : jsonTranslationFileCreator;
    checkIfTranslationFilesExist(translationFilePath, options.langs, extension);
    return createTranslateFiles(options.langs, translationCreator, translationFilePath);
}
exports.createTranslateFilesFromOptions = createTranslateFilesFromOptions;
function createTranslateFiles(langs, creator, path) {
    const treeSource = new schematics_1.EmptyTree();
    langs.forEach((lang) => {
        creator(treeSource, lang, path);
    });
    return treeSource;
}
exports.createTranslateFiles = createTranslateFiles;
//# sourceMappingURL=translations.js.map