"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addScriptToPackageJson = exports.addPackageToPackageJson = void 0;
/**
 * Adds a package to the package.json
 */
function addPackageToPackageJson(host, type, pkg, version) {
    if (host.exists('package.json')) {
        const sourceText = host.read('package.json').toString('utf-8');
        const json = JSON.parse(sourceText);
        if (!json[type]) {
            json[type] = {};
        }
        if (!json[type][pkg]) {
            json[type][pkg] = version;
        }
        host.overwrite('package.json', JSON.stringify(json, null, 2));
    }
    return host;
}
exports.addPackageToPackageJson = addPackageToPackageJson;
/**
 * Adds a script to the package.json
 */
function addScriptToPackageJson(host, scriptName, script) {
    if (host.exists('package.json')) {
        const sourceText = host.read('package.json').toString('utf-8');
        const json = JSON.parse(sourceText);
        if (!json['scripts']) {
            json['scripts'] = {};
        }
        json['scripts'][scriptName] = script;
        host.overwrite('package.json', JSON.stringify(json, null, 2));
    }
    return host;
}
exports.addScriptToPackageJson = addScriptToPackageJson;
//# sourceMappingURL=package.js.map