"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWorkspace = exports.defaultAppOptions = exports.defaultWorkspaceOptions = void 0;
const rxjs_1 = require("rxjs");
exports.defaultWorkspaceOptions = {
    name: 'workspace',
    newProjectRoot: 'projects',
    version: '12.1.3',
    minimal: true,
};
exports.defaultAppOptions = {
    name: 'bar',
    inlineStyle: false,
    inlineTemplate: false,
    viewEncapsulation: 'Emulated',
    routing: false,
    style: 'css',
    skipTests: false,
};
const defaultLibOptions = {
    name: 'baz',
};
function createWorkspace(schematicRunner, appTree, workspaceOptions = exports.defaultWorkspaceOptions, appOptions = exports.defaultAppOptions, libOptions = defaultLibOptions) {
    const angularSchematic = '@schematics/angular';
    return schematicRunner
        .runExternalSchematicAsync(angularSchematic, 'workspace', workspaceOptions)
        .pipe((0, rxjs_1.switchMap)((tree) => schematicRunner.runExternalSchematicAsync(angularSchematic, 'application', appOptions, tree)), (0, rxjs_1.switchMap)((tree) => schematicRunner.runExternalSchematicAsync(angularSchematic, 'library', libOptions, tree)))
        .toPromise();
}
exports.createWorkspace = createWorkspace;
//# sourceMappingURL=create-workspace.js.map