export declare type HashMap<T = any> = Record<string, T>;
export interface LoadedEvent {
    type: 'translationLoadSuccess';
    wasFailure: boolean;
    payload: {
        scope: string | null;
        langName: string;
    };
}
export interface FailedEvent {
    type: 'translationLoadFailure';
    payload: LoadedEvent['payload'];
}
export interface LangChangedEvent {
    type: 'langChanged';
    payload: LoadedEvent['payload'];
}
export declare type TranslocoEvents = LoadedEvent | FailedEvent | LangChangedEvent;
export declare type Translation = HashMap;
export declare type PersistStorage = Pick<Storage, 'getItem' | 'setItem' | 'removeItem'>;
export declare type TranslateParams = string | string[];
export declare type TranslateObjectParams = TranslateParams | HashMap | Map<string, HashMap>;
export interface LangDefinition {
    id: string;
    label: string;
}
export declare type AvailableLangs = string[] | LangDefinition[];
export interface SetTranslationOptions {
    merge?: boolean;
    emitChange?: boolean;
}
export interface ProviderScope {
    scope: string;
    loader?: InlineLoader;
    alias?: string;
}
export declare type MaybeArray<T> = T | T[];
export declare type TranslocoScope = ProviderScope | string | undefined;
export declare type InlineLoader = HashMap<() => Promise<Translation>>;
export interface LoadOptions {
    fallbackLangs?: string[] | null;
    /** @internal */
    failedCounter?: number;
    inlineLoader?: InlineLoader;
}
