import { ChangeDetectorRef, ElementRef, EmbeddedViewRef, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, TemplateRef, Type, ViewContainerRef } from '@angular/core';
import { Subscription } from 'rxjs';
import { TranslocoService } from './transloco.service';
import { HashMap, MaybeArray, TranslocoScope } from './types';
import * as i0 from "@angular/core";
declare type TranslateFn = (key: string, params?: HashMap) => any;
interface ViewContext {
    $implicit: TranslateFn;
    currentLang: string;
}
export declare class TranslocoDirective implements OnInit, OnDestroy, OnChanges {
    private translocoService;
    private tpl;
    private providerScope;
    private providerLang;
    private providedLoadingTpl;
    private vcr;
    private cdr;
    private host;
    private renderer;
    subscription: Subscription | null;
    view: EmbeddedViewRef<ViewContext> | undefined;
    private translationMemo;
    key: string | undefined;
    params: HashMap;
    inlineScope: string | undefined;
    inlineRead: string | undefined;
    inlineLang: string | undefined;
    inlineTpl: TemplateRef<unknown> | undefined;
    private currentLang;
    private loaderTplHandler;
    private initialized;
    private path;
    private langResolver;
    private scopeResolver;
    private readonly strategy;
    static ngTemplateContextGuard(dir: TranslocoDirective, ctx: unknown): ctx is ViewContext;
    constructor(translocoService: TranslocoService, tpl: TemplateRef<ViewContext>, providerScope: MaybeArray<TranslocoScope>, providerLang: string | undefined, providedLoadingTpl: Type<unknown> | string, vcr: ViewContainerRef, cdr: ChangeDetectorRef, host: ElementRef, renderer: Renderer2);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    private attributeStrategy;
    private structuralStrategy;
    protected getTranslateFn(lang: string, read: string | undefined): TranslateFn;
    private getLoadingTpl;
    ngOnDestroy(): void;
    private detachLoader;
    private resolveScope;
    static ɵfac: i0.ɵɵFactoryDeclaration<TranslocoDirective, [null, { optional: true; }, { optional: true; }, { optional: true; }, { optional: true; }, null, null, null, null]>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<TranslocoDirective, "[transloco]", never, { "key": "transloco"; "params": "translocoParams"; "inlineScope": "translocoScope"; "inlineRead": "translocoRead"; "inlineLang": "translocoLang"; "inlineTpl": "translocoLoadingTpl"; }, {}, never>;
}
export {};
