import { InjectionToken } from '@angular/core';
import { AvailableLangs } from './types';
export interface TranslocoConfig {
    defaultLang: string;
    reRenderOnLangChange?: boolean;
    prodMode?: boolean;
    fallbackLang?: string | string[];
    failedRetries?: number;
    availableLangs?: AvailableLangs;
    flatten?: {
        aot?: boolean;
    };
    missingHandler?: {
        logMissingKey?: boolean;
        useFallbackTranslation?: boolean;
        allowEmpty?: boolean;
    };
    interpolation?: [string, string];
}
export declare const TRANSLOCO_CONFIG: InjectionToken<TranslocoConfig>;
export declare const defaultConfig: Omit<Required<TranslocoConfig>, 'scopeMapping' | 'fallbackLang'>;
/**
 * Sets up TranslocoConfig object.
 *
 * @param config The partial config object to load, this is optional,
 * will be spread after defaultConfig.
 */
export declare function translocoConfig(config?: Partial<TranslocoConfig>): TranslocoConfig;
