import { ChangeDetectorRef, Inject, Optional, Pipe, } from '@angular/core';
import { TranslocoService } from './transloco.service';
import { switchMap } from 'rxjs/operators';
import { forkJoin } from 'rxjs';
import { TRANSLOCO_SCOPE } from './transloco-scope';
import { TRANSLOCO_LANG } from './transloco-lang';
import { listenOrNotOperator, resolveInlineLoader, shouldListenToLangChanges, } from './shared';
import { LangResolver } from './lang-resolver';
import { ScopeResolver } from './scope-resolver';
import * as i0 from "@angular/core";
import * as i1 from "./transloco.service";
export class TranslocoPipe {
    constructor(translocoService, providerScope, providerLang, cdr) {
        this.translocoService = translocoService;
        this.providerScope = providerScope;
        this.providerLang = providerLang;
        this.cdr = cdr;
        this.subscription = null;
        this.lastValue = '';
        this.langResolver = new LangResolver();
        this.scopeResolver = new ScopeResolver(this.translocoService);
    }
    // null is for handling strict mode + async pipe types https://github.com/ngneat/transloco/issues/311
    // null is for handling strict mode + optional chaining types https://github.com/ngneat/transloco/issues/488
    transform(key, params, inlineLang) {
        if (!key) {
            return key;
        }
        const keyName = params ? `${key}${JSON.stringify(params)}` : key;
        if (keyName === this.lastKey) {
            return this.lastValue;
        }
        this.lastKey = keyName;
        this.subscription?.unsubscribe();
        const listenToLangChange = shouldListenToLangChanges(this.translocoService, this.providerLang || inlineLang);
        this.subscription = this.translocoService.langChanges$
            .pipe(switchMap((activeLang) => {
            const lang = this.langResolver.resolve({
                inline: inlineLang,
                provider: this.providerLang,
                active: activeLang,
            });
            return Array.isArray(this.providerScope)
                ? forkJoin(this.providerScope.map((providerScope) => this.resolveScope(lang, providerScope)))
                : this.resolveScope(lang, this.providerScope);
        }), listenOrNotOperator(listenToLangChange))
            .subscribe(() => this.updateValue(key, params));
        return this.lastValue;
    }
    ngOnDestroy() {
        if (this.subscription) {
            this.subscription.unsubscribe();
            // Caretaker note: it's important to clean up references to subscriptions since they save the `next`
            // callback within its `destination` property, preventing classes from being GC'd.
            this.subscription = null;
        }
    }
    updateValue(key, params) {
        const lang = this.langResolver.resolveLangBasedOnScope(this.path);
        this.lastValue = this.translocoService.translate(key, params, lang);
        this.cdr.markForCheck();
    }
    resolveScope(lang, providerScope) {
        const resolvedScope = this.scopeResolver.resolve({
            inline: undefined,
            provider: providerScope,
        });
        this.path = this.langResolver.resolveLangPath(lang, resolvedScope);
        const inlineLoader = resolveInlineLoader(providerScope, resolvedScope);
        return this.translocoService._loadDependencies(this.path, inlineLoader);
    }
}
TranslocoPipe.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoPipe, deps: [{ token: i1.TranslocoService }, { token: TRANSLOCO_SCOPE, optional: true }, { token: TRANSLOCO_LANG, optional: true }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Pipe });
TranslocoPipe.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoPipe, name: "transloco", pure: false });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoPipe, decorators: [{
            type: Pipe,
            args: [{
                    name: 'transloco',
                    pure: false,
                }]
        }], ctorParameters: function () { return [{ type: i1.TranslocoService }, { type: undefined, decorators: [{
                    type: Optional
                }, {
                    type: Inject,
                    args: [TRANSLOCO_SCOPE]
                }] }, { type: undefined, decorators: [{
                    type: Optional
                }, {
                    type: Inject,
                    args: [TRANSLOCO_LANG]
                }] }, { type: i0.ChangeDetectorRef }]; } });
//# sourceMappingURL=data:application/json;base64,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