import { NgModule } from '@angular/core';
import { TranslocoLoaderComponent } from './loader-component.component';
import { TranslocoDirective } from './transloco.directive';
import { DefaultTranspiler, TRANSLOCO_TRANSPILER, } from './transloco.transpiler';
import { TranslocoPipe } from './transloco.pipe';
import { DefaultHandler, TRANSLOCO_MISSING_HANDLER, } from './transloco-missing-handler';
import { DefaultInterceptor, TRANSLOCO_INTERCEPTOR, } from './transloco.interceptor';
import { DefaultFallbackStrategy, TRANSLOCO_FALLBACK_STRATEGY, } from './transloco-fallback-strategy';
import { TRANSLOCO_CONFIG } from './transloco.config';
import * as i0 from "@angular/core";
export const defaultProviders = [
    {
        provide: TRANSLOCO_TRANSPILER,
        useClass: DefaultTranspiler,
        deps: [TRANSLOCO_CONFIG],
    },
    {
        provide: TRANSLOCO_MISSING_HANDLER,
        useClass: DefaultHandler,
    },
    {
        provide: TRANSLOCO_INTERCEPTOR,
        useClass: DefaultInterceptor,
    },
    {
        provide: TRANSLOCO_FALLBACK_STRATEGY,
        useClass: DefaultFallbackStrategy,
        deps: [TRANSLOCO_CONFIG],
    },
];
export class TranslocoModule {
}
TranslocoModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
TranslocoModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoModule, declarations: [TranslocoDirective, TranslocoPipe, TranslocoLoaderComponent], exports: [TranslocoDirective, TranslocoPipe] });
TranslocoModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoModule, providers: [defaultProviders] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [TranslocoDirective, TranslocoPipe, TranslocoLoaderComponent],
                    providers: [defaultProviders],
                    exports: [TranslocoDirective, TranslocoPipe]
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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