import { InjectionToken } from '@angular/core';
export const TRANSLOCO_CONFIG = new InjectionToken('TRANSLOCO_CONFIG', {
    providedIn: 'root',
    factory: () => {
        return { defaultLang: 'en' };
    },
});
export const defaultConfig = {
    defaultLang: 'en',
    reRenderOnLangChange: false,
    prodMode: false,
    failedRetries: 2,
    availableLangs: [],
    missingHandler: {
        logMissingKey: true,
        useFallbackTranslation: false,
        allowEmpty: false,
    },
    flatten: {
        aot: false,
    },
    interpolation: ['{{', '}}'],
};
/**
 * Sets up TranslocoConfig object.
 *
 * @param config The partial config object to load, this is optional,
 * will be spread after defaultConfig.
 */
export function translocoConfig(config = defaultConfig) {
    return { ...defaultConfig, ...config };
}
//# sourceMappingURL=data:application/json;base64,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