import { APP_INITIALIZER, Inject, Injectable, InjectionToken, NgModule, } from '@angular/core';
import { TRANSLOCO_LOADER } from './transloco.loader';
import { of } from 'rxjs';
import { defaultProviders, TranslocoModule } from './transloco.module';
import { TRANSLOCO_CONFIG, translocoConfig, } from './transloco.config';
import { TranslocoService } from './transloco.service';
import * as i0 from "@angular/core";
const TRANSLOCO_TEST_LANGS = new InjectionToken('TRANSLOCO_TEST_LANGS - Available testing languages');
const TRANSLOCO_TEST_OPTIONS = new InjectionToken('TRANSLOCO_TEST_OPTIONS - Testing options');
export class TestingLoader {
    constructor(langs) {
        this.langs = langs;
    }
    getTranslation(lang) {
        return of(this.langs[lang]);
    }
}
TestingLoader.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TestingLoader, deps: [{ token: TRANSLOCO_TEST_LANGS }], target: i0.ɵɵFactoryTarget.Injectable });
TestingLoader.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TestingLoader });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TestingLoader, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [TRANSLOCO_TEST_LANGS]
                }] }]; } });
export function initTranslocoService(service, langs = {}, options) {
    const preloadAllLangs = () => options.preloadLangs
        ? Promise.all(Object.keys(langs).map((lang) => service.load(lang).toPromise()))
        : Promise.resolve();
    return preloadAllLangs;
}
export class TranslocoTestingModule {
    static forRoot(options) {
        return {
            ngModule: TranslocoTestingModule,
            providers: [
                {
                    provide: TRANSLOCO_TEST_LANGS,
                    useValue: options.langs,
                },
                {
                    provide: TRANSLOCO_TEST_OPTIONS,
                    useValue: options,
                },
                {
                    provide: APP_INITIALIZER,
                    useFactory: initTranslocoService,
                    deps: [
                        TranslocoService,
                        TRANSLOCO_TEST_LANGS,
                        TRANSLOCO_TEST_OPTIONS,
                    ],
                    multi: true,
                },
                {
                    provide: TRANSLOCO_LOADER,
                    useClass: TestingLoader,
                },
                defaultProviders,
                {
                    provide: TRANSLOCO_CONFIG,
                    useValue: translocoConfig({
                        prodMode: true,
                        missingHandler: { logMissingKey: false },
                        ...options.translocoConfig,
                    }),
                },
            ],
        };
    }
}
TranslocoTestingModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoTestingModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
TranslocoTestingModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoTestingModule, exports: [TranslocoModule] });
TranslocoTestingModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoTestingModule, imports: [TranslocoModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: TranslocoTestingModule, decorators: [{
            type: NgModule,
            args: [{
                    exports: [TranslocoModule],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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