import { Inject, Injectable, InjectionToken } from '@angular/core';
import { TRANSLOCO_CONFIG } from './transloco.config';
import * as i0 from "@angular/core";
export const TRANSLOCO_FALLBACK_STRATEGY = new InjectionToken('TRANSLOCO_FALLBACK_STRATEGY');
export class DefaultFallbackStrategy {
    constructor(userConfig) {
        this.userConfig = userConfig;
    }
    getNextLangs() {
        const fallbackLang = this.userConfig.fallbackLang;
        if (!fallbackLang) {
            throw new Error('When using the default fallback, a fallback language must be provided in the config!');
        }
        return Array.isArray(fallbackLang) ? fallbackLang : [fallbackLang];
    }
}
DefaultFallbackStrategy.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: DefaultFallbackStrategy, deps: [{ token: TRANSLOCO_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
DefaultFallbackStrategy.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: DefaultFallbackStrategy });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.10", ngImport: i0, type: DefaultFallbackStrategy, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [TRANSLOCO_CONFIG]
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,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