import { TemplateRef, ComponentFactoryResolver, } from '@angular/core';
import { isString } from './helpers';
import { TranslocoLoaderComponent } from './loader-component.component';
export class TemplateHandler {
    constructor(view, vcr) {
        this.view = view;
        this.vcr = vcr;
        this.injector = this.vcr.injector;
    }
    attachView() {
        if (this.view instanceof TemplateRef) {
            this.vcr.createEmbeddedView(this.view);
        }
        else if (isString(this.view)) {
            const componentRef = this.createComponent(TranslocoLoaderComponent);
            componentRef.instance.html = this.view;
            componentRef.hostView.detectChanges();
        }
        else {
            this.createComponent(this.view);
        }
    }
    detachView() {
        this.vcr.clear();
    }
    createComponent(cmp) {
        const cfr = this.injector.get(ComponentFactoryResolver);
        const factory = cfr.resolveComponentFactory(cmp);
        return this.vcr.createComponent(factory);
    }
}
//# sourceMappingURL=data:application/json;base64,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