import { hasInlineLoader, isString } from './helpers';
import { take } from 'rxjs/operators';
/*
 * @example
 *
 * given: lazy-page/en => lazy-page
 *
 */
export function getScopeFromLang(lang) {
    if (!lang) {
        return '';
    }
    const split = lang.split('/');
    split.pop();
    return split.join('/');
}
/*
 * @example
 *
 * given: lazy-page/en => en
 *
 */
export function getLangFromScope(lang) {
    if (!lang) {
        return '';
    }
    return lang.split('/').pop();
}
/**
 * @example
 *
 * getPipeValue('todos|scoped', 'scoped') [true, 'todos']
 * getPipeValue('en|static', 'static') [true, 'en']
 * getPipeValue('en', 'static') [false, 'en']
 */
export function getPipeValue(str, value, char = '|') {
    if (isString(str)) {
        const splitted = str.split(char);
        const lastItem = splitted.pop();
        return lastItem === value ? [true, splitted.toString()] : [false, lastItem];
    }
    return [false, ''];
}
export function shouldListenToLangChanges(service, lang) {
    const [hasStatic] = getPipeValue(lang, 'static');
    if (!hasStatic) {
        // If we didn't get 'lang|static' check if it's set in the global level
        return !!service.config.reRenderOnLangChange;
    }
    // We have 'lang|static' so don't listen to lang changes
    return false;
}
export function listenOrNotOperator(listenToLangChange) {
    return listenToLangChange ? (source) => source : take(1);
}
function prependScope(inlineLoader, scope) {
    return Object.keys(inlineLoader).reduce((acc, lang) => {
        acc[`${scope}/${lang}`] = inlineLoader[lang];
        return acc;
    }, {});
}
export function resolveInlineLoader(providerScope, scope) {
    return hasInlineLoader(providerScope)
        ? prependScope(providerScope.loader, scope)
        : undefined;
}
export function getEventPayload(lang) {
    return {
        scope: getScopeFromLang(lang) || null,
        langName: getLangFromScope(lang),
    };
}
//# sourceMappingURL=data:application/json;base64,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