import { isScopeObject, toCamelCase } from './helpers';
export class ScopeResolver {
    constructor(translocoService) {
        this.translocoService = translocoService;
    }
    // inline => provider
    resolve({ inline, provider } = {
        inline: undefined,
        provider: undefined,
    }) {
        if (inline) {
            return inline;
        }
        if (provider) {
            if (isScopeObject(provider)) {
                const { scope, alias = toCamelCase(scope) } = provider;
                this.translocoService._setScopeAlias(scope, alias);
                return scope;
            }
            return provider;
        }
        return undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,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