import { flatten as _flatten, unflatten as _unflatten } from 'flat';
export function getValue(obj, path) {
    if (!obj) {
        return obj;
    }
    /* For cases where the key is like: 'general.something.thing' */
    if (Object.prototype.hasOwnProperty.call(obj, path)) {
        return obj[path];
    }
    return path.split('.').reduce((p, c) => p?.[c], obj);
}
export function setValue(obj, prop, val) {
    obj = { ...obj };
    const split = prop.split('.');
    const lastIndex = split.length - 1;
    split.reduce((acc, part, index) => {
        if (index === lastIndex) {
            acc[part] = val;
        }
        else {
            acc[part] = Array.isArray(acc[part])
                ? acc[part].slice()
                : { ...acc[part] };
        }
        return acc && acc[part];
    }, obj);
    return obj;
}
export function size(collection) {
    if (!collection) {
        return 0;
    }
    if (Array.isArray(collection)) {
        return collection.length;
    }
    if (isObject(collection)) {
        return Object.keys(collection).length;
    }
    return collection ? collection.length : 0;
}
export function isEmpty(collection) {
    return size(collection) === 0;
}
export function isFunction(val) {
    return typeof val === 'function';
}
export function isString(val) {
    return typeof val === 'string';
}
export function isNumber(val) {
    return typeof val === 'number';
}
export function isObject(item) {
    return !!item && typeof item === 'object' && !Array.isArray(item);
}
export function coerceArray(value) {
    return Array.isArray(value) ? value : [value];
}
/*
 * @example
 *
 * given: path-to-happiness => pathToHappiness
 * given: path_to_happiness => pathToHappiness
 * given: path-to_happiness => pathToHappiness
 *
 */
export function toCamelCase(str) {
    return str
        .replace(/(?:^\w|[A-Z]|\b\w)/g, (word, index) => index == 0 ? word.toLowerCase() : word.toUpperCase())
        .replace(/\s+|_|-|\//g, '');
}
export function isBrowser() {
    return typeof window !== 'undefined';
}
export function isNil(value) {
    return value === null || value === undefined;
}
export function isDefined(value) {
    return isNil(value) === false;
}
export function toNumber(value) {
    if (isNumber(value))
        return value;
    if (isString(value) && !isNaN(Number(value) - parseFloat(value))) {
        return Number(value);
    }
    return null;
}
export function isScopeObject(item) {
    return item && typeof item.scope === 'string';
}
export function hasInlineLoader(item) {
    return item && isObject(item.loader);
}
export function unflatten(obj) {
    return _unflatten(obj);
}
export function flatten(obj) {
    return _flatten(obj, { safe: true });
}
//# sourceMappingURL=data:application/json;base64,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