import { from } from 'rxjs';
import { map } from 'rxjs/operators';
import { resolveLoader } from './resolve-loader';
export function getFallbacksLoaders({ mainLoader, path, data, fallbackPath, inlineLoader, }) {
    const paths = fallbackPath ? [path, fallbackPath] : [path];
    return paths.map((path) => {
        const loader = resolveLoader({ path, mainLoader, inlineLoader, data });
        return from(loader).pipe(map((translation) => ({
            translation,
            lang: path,
        })));
    });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0LWZhbGxiYWNrcy1sb2FkZXJzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vbGlicy90cmFuc2xvY28vc3JjL2xpYi9nZXQtZmFsbGJhY2tzLWxvYWRlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLElBQUksRUFBRSxNQUFNLE1BQU0sQ0FBQztBQUM1QixPQUFPLEVBQUUsR0FBRyxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDckMsT0FBTyxFQUFFLGFBQWEsRUFBRSxNQUFNLGtCQUFrQixDQUFDO0FBWWpELE1BQU0sVUFBVSxtQkFBbUIsQ0FBQyxFQUNsQyxVQUFVLEVBQ1YsSUFBSSxFQUNKLElBQUksRUFDSixZQUFZLEVBQ1osWUFBWSxHQUNKO0lBQ1IsTUFBTSxLQUFLLEdBQUcsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksRUFBRSxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUUzRCxPQUFPLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtRQUN4QixNQUFNLE1BQU0sR0FBRyxhQUFhLENBQUMsRUFBRSxJQUFJLEVBQUUsVUFBVSxFQUFFLFlBQVksRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO1FBRXZFLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FDdEIsR0FBRyxDQUFDLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1lBQ3BCLFdBQVc7WUFDWCxJQUFJLEVBQUUsSUFBSTtTQUNYLENBQUMsQ0FBQyxDQUNKLENBQUM7SUFDSixDQUFDLENBQUMsQ0FBQztBQUNMLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBmcm9tIH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBtYXAgfSBmcm9tICdyeGpzL29wZXJhdG9ycyc7XG5pbXBvcnQgeyByZXNvbHZlTG9hZGVyIH0gZnJvbSAnLi9yZXNvbHZlLWxvYWRlcic7XG5pbXBvcnQgeyBUcmFuc2xvY29Mb2FkZXIsIFRyYW5zbG9jb0xvYWRlckRhdGEgfSBmcm9tICcuL3RyYW5zbG9jby5sb2FkZXInO1xuaW1wb3J0IHsgSW5saW5lTG9hZGVyIH0gZnJvbSAnLi90eXBlcyc7XG5cbmludGVyZmFjZSBPcHRpb25zIHtcbiAgcGF0aDogc3RyaW5nO1xuICBmYWxsYmFja1BhdGg/OiBzdHJpbmc7XG4gIGlubGluZUxvYWRlcj86IElubGluZUxvYWRlcjtcbiAgbWFpbkxvYWRlcjogVHJhbnNsb2NvTG9hZGVyO1xuICBkYXRhPzogVHJhbnNsb2NvTG9hZGVyRGF0YTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldEZhbGxiYWNrc0xvYWRlcnMoe1xuICBtYWluTG9hZGVyLFxuICBwYXRoLFxuICBkYXRhLFxuICBmYWxsYmFja1BhdGgsXG4gIGlubGluZUxvYWRlcixcbn06IE9wdGlvbnMpIHtcbiAgY29uc3QgcGF0aHMgPSBmYWxsYmFja1BhdGggPyBbcGF0aCwgZmFsbGJhY2tQYXRoXSA6IFtwYXRoXTtcblxuICByZXR1cm4gcGF0aHMubWFwKChwYXRoKSA9PiB7XG4gICAgY29uc3QgbG9hZGVyID0gcmVzb2x2ZUxvYWRlcih7IHBhdGgsIG1haW5Mb2FkZXIsIGlubGluZUxvYWRlciwgZGF0YSB9KTtcblxuICAgIHJldHVybiBmcm9tKGxvYWRlcikucGlwZShcbiAgICAgIG1hcCgodHJhbnNsYXRpb24pID0+ICh7XG4gICAgICAgIHRyYW5zbGF0aW9uLFxuICAgICAgICBsYW5nOiBwYXRoLFxuICAgICAgfSkpXG4gICAgKTtcbiAgfSk7XG59XG4iXX0=