import { isBrowser } from './helpers';
/**
 * Returns the language code name from the browser, e.g. "en"
 */
export function getBrowserLang() {
    let browserLang = getBrowserCultureLang();
    if (!browserLang || !isBrowser()) {
        return undefined;
    }
    if (browserLang.indexOf('-') !== -1) {
        browserLang = browserLang.split('-')[0];
    }
    if (browserLang.indexOf('_') !== -1) {
        browserLang = browserLang.split('_')[0];
    }
    return browserLang;
}
/**
 * Returns the culture language code name from the browser, e.g. "en-US"
 */
export function getBrowserCultureLang() {
    if (!isBrowser()) {
        return '';
    }
    const navigator = window.navigator;
    let browserCultureLang = navigator.languages ? navigator.languages[0] : null;
    browserCultureLang =
        browserCultureLang ||
            navigator.language ||
            navigator.browserLanguage ||
            navigator.userLanguage;
    return browserCultureLang;
}
//# sourceMappingURL=data:application/json;base64,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