import { OnChanges, OnDestroy, OnInit, AfterViewInit, ChangeDetectorRef, EventEmitter, TemplateRef, ElementRef, SimpleChanges, QueryList, InjectionToken } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { Subject } from 'rxjs';
import { ConsoleService } from './console.service';
import { ItemsList } from './items-list';
import { NgOption, DropdownPosition } from './ng-select.types';
import { NgDropdownPanelComponent } from './ng-dropdown-panel.component';
import { NgOptionComponent } from './ng-option.component';
import { SelectionModelFactory } from './selection-model';
import { NgSelectConfig } from './config.service';
import * as i0 from "@angular/core";
export declare const SELECTION_MODEL_FACTORY: InjectionToken<SelectionModelFactory>;
export type AddTagFn = ((term: string) => any | Promise<any>);
export type CompareWithFn = (a: any, b: any) => boolean;
export type GroupValueFn = (key: string | any, children: any[]) => string | any;
export declare class NgSelectComponent implements OnDestroy, OnChanges, OnInit, AfterViewInit, ControlValueAccessor {
    classes: string;
    private autoFocus;
    config: NgSelectConfig;
    private _cd;
    private _console;
    bindLabel: string;
    bindValue: string;
    markFirst: boolean;
    placeholder: string;
    notFoundText: string;
    typeToSearchText: string;
    addTagText: string;
    loadingText: string;
    clearAllText: string;
    appearance: string;
    dropdownPosition: DropdownPosition;
    appendTo: string;
    loading: boolean;
    closeOnSelect: boolean;
    hideSelected: boolean;
    selectOnTab: boolean;
    openOnEnter: boolean;
    maxSelectedItems: number;
    groupBy: string | ((value: any) => any);
    groupValue: GroupValueFn;
    bufferAmount: number;
    virtualScroll: boolean;
    selectableGroup: boolean;
    selectableGroupAsModel: boolean;
    searchFn: any;
    trackByFn: any;
    clearOnBackspace: boolean;
    labelForId: any;
    inputAttrs: {
        [key: string]: string;
    };
    tabIndex: number;
    readonly: boolean;
    searchWhileComposing: boolean;
    minTermLength: number;
    editableSearchTerm: boolean;
    keyDownFn: (_: KeyboardEvent) => boolean;
    typeahead: Subject<string>;
    multiple: boolean;
    addTag: boolean | AddTagFn;
    searchable: boolean;
    clearable: boolean;
    isOpen: boolean;
    get items(): readonly any[] | null;
    set items(value: readonly any[] | null);
    get compareWith(): CompareWithFn;
    set compareWith(fn: CompareWithFn);
    get clearSearchOnAdd(): boolean;
    set clearSearchOnAdd(value: boolean);
    get deselectOnClick(): boolean;
    set deselectOnClick(value: boolean);
    blurEvent: EventEmitter<any>;
    focusEvent: EventEmitter<any>;
    changeEvent: EventEmitter<any>;
    openEvent: EventEmitter<any>;
    closeEvent: EventEmitter<any>;
    searchEvent: EventEmitter<{
        term: string;
        items: any[];
    }>;
    clearEvent: EventEmitter<any>;
    addEvent: EventEmitter<any>;
    removeEvent: EventEmitter<any>;
    scroll: EventEmitter<{
        start: number;
        end: number;
    }>;
    scrollToEnd: EventEmitter<any>;
    optionTemplate: TemplateRef<any>;
    optgroupTemplate: TemplateRef<any>;
    labelTemplate: TemplateRef<any>;
    multiLabelTemplate: TemplateRef<any>;
    headerTemplate: TemplateRef<any>;
    footerTemplate: TemplateRef<any>;
    notFoundTemplate: TemplateRef<any>;
    typeToSearchTemplate: TemplateRef<any>;
    loadingTextTemplate: TemplateRef<any>;
    tagTemplate: TemplateRef<any>;
    loadingSpinnerTemplate: TemplateRef<any>;
    dropdownPanel: NgDropdownPanelComponent;
    searchInput: ElementRef<HTMLInputElement>;
    clearButton: ElementRef<HTMLSpanElement>;
    ngOptions: QueryList<NgOptionComponent>;
    useDefaultClass: boolean;
    get disabled(): boolean;
    get filtered(): boolean;
    get single(): boolean;
    itemsList: ItemsList;
    viewPortItems: NgOption[];
    searchTerm: string;
    dropdownId: string;
    element: HTMLElement;
    focused: boolean;
    escapeHTML: boolean;
    private _items;
    private _itemsAreUsed;
    private _defaultLabel;
    private _primitive;
    private _manualOpen;
    private _disabled;
    private _pressedKeys;
    private _compareWith;
    private _clearSearchOnAdd;
    private _deselectOnClick;
    private _isComposing;
    private get _editableSearchTerm();
    private readonly _destroy$;
    private readonly _keyPress$;
    private _onChange;
    private _onTouched;
    clearItem: (item: any) => void;
    constructor(classes: string, autoFocus: any, config: NgSelectConfig, newSelectionModel: SelectionModelFactory, _elementRef: ElementRef<HTMLElement>, _cd: ChangeDetectorRef, _console: ConsoleService);
    get selectedItems(): NgOption[];
    get selectedValues(): any[];
    get hasValue(): boolean;
    get currentPanelPosition(): DropdownPosition;
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    handleKeyDown($event: KeyboardEvent): void;
    handleKeyCode($event: KeyboardEvent): void;
    handleKeyCodeInput($event: KeyboardEvent): void;
    handleKeyCodeClear($event: KeyboardEvent): void;
    handleMousedown($event: MouseEvent): void;
    handleArrowClick(): void;
    handleClearClick(): void;
    clearModel(): void;
    writeValue(value: any | any[]): void;
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    setDisabledState(state: boolean): void;
    toggle(): void;
    open(): void;
    close(): void;
    toggleItem(item: NgOption): void;
    select(item: NgOption): void;
    focus(): void;
    blur(): void;
    unselect(item: NgOption): void;
    selectTag(): void;
    showClear(): boolean;
    focusOnClear(): void;
    trackByOption: (_: number, item: NgOption) => any;
    get showAddTag(): boolean;
    showNoItemsFound(): boolean;
    showTypeToSearch(): boolean;
    onCompositionStart(): void;
    onCompositionEnd(term: string): void;
    filter(term: string): void;
    onInputFocus($event: any): void;
    onInputBlur($event: any): void;
    onItemHover(item: NgOption): void;
    detectChanges(): void;
    private _setSearchTermFromItems;
    private _setItems;
    private _setItemsFromNgOptions;
    private _isValidWriteValue;
    private _handleWriteValue;
    private _handleKeyPresses;
    private _setInputAttributes;
    private _updateNgModel;
    private _clearSearch;
    private _changeSearch;
    private _scrollToMarked;
    private _scrollToTag;
    private _onSelectionChanged;
    private _handleTab;
    private _handleEnter;
    private _handleSpace;
    private _handleArrowDown;
    private _handleArrowUp;
    private _nextItemIsTag;
    private _handleBackspace;
    private get _isTypeahead();
    private get _validTerm();
    private _mergeGlobalConfig;
    static ɵfac: i0.ɵɵFactoryDeclaration<NgSelectComponent, [{ attribute: "class"; }, { attribute: "autofocus"; }, null, null, null, null, null]>;
    static ɵcmp: i0.ɵɵComponentDeclaration<NgSelectComponent, "ng-select", never, { "bindLabel": { "alias": "bindLabel"; "required": false; }; "bindValue": { "alias": "bindValue"; "required": false; }; "markFirst": { "alias": "markFirst"; "required": false; }; "placeholder": { "alias": "placeholder"; "required": false; }; "notFoundText": { "alias": "notFoundText"; "required": false; }; "typeToSearchText": { "alias": "typeToSearchText"; "required": false; }; "addTagText": { "alias": "addTagText"; "required": false; }; "loadingText": { "alias": "loadingText"; "required": false; }; "clearAllText": { "alias": "clearAllText"; "required": false; }; "appearance": { "alias": "appearance"; "required": false; }; "dropdownPosition": { "alias": "dropdownPosition"; "required": false; }; "appendTo": { "alias": "appendTo"; "required": false; }; "loading": { "alias": "loading"; "required": false; }; "closeOnSelect": { "alias": "closeOnSelect"; "required": false; }; "hideSelected": { "alias": "hideSelected"; "required": false; }; "selectOnTab": { "alias": "selectOnTab"; "required": false; }; "openOnEnter": { "alias": "openOnEnter"; "required": false; }; "maxSelectedItems": { "alias": "maxSelectedItems"; "required": false; }; "groupBy": { "alias": "groupBy"; "required": false; }; "groupValue": { "alias": "groupValue"; "required": false; }; "bufferAmount": { "alias": "bufferAmount"; "required": false; }; "virtualScroll": { "alias": "virtualScroll"; "required": false; }; "selectableGroup": { "alias": "selectableGroup"; "required": false; }; "selectableGroupAsModel": { "alias": "selectableGroupAsModel"; "required": false; }; "searchFn": { "alias": "searchFn"; "required": false; }; "trackByFn": { "alias": "trackByFn"; "required": false; }; "clearOnBackspace": { "alias": "clearOnBackspace"; "required": false; }; "labelForId": { "alias": "labelForId"; "required": false; }; "inputAttrs": { "alias": "inputAttrs"; "required": false; }; "tabIndex": { "alias": "tabIndex"; "required": false; }; "readonly": { "alias": "readonly"; "required": false; }; "searchWhileComposing": { "alias": "searchWhileComposing"; "required": false; }; "minTermLength": { "alias": "minTermLength"; "required": false; }; "editableSearchTerm": { "alias": "editableSearchTerm"; "required": false; }; "keyDownFn": { "alias": "keyDownFn"; "required": false; }; "typeahead": { "alias": "typeahead"; "required": false; }; "multiple": { "alias": "multiple"; "required": false; }; "addTag": { "alias": "addTag"; "required": false; }; "searchable": { "alias": "searchable"; "required": false; }; "clearable": { "alias": "clearable"; "required": false; }; "isOpen": { "alias": "isOpen"; "required": false; }; "items": { "alias": "items"; "required": false; }; "compareWith": { "alias": "compareWith"; "required": false; }; "clearSearchOnAdd": { "alias": "clearSearchOnAdd"; "required": false; }; "deselectOnClick": { "alias": "deselectOnClick"; "required": false; }; }, { "blurEvent": "blur"; "focusEvent": "focus"; "changeEvent": "change"; "openEvent": "open"; "closeEvent": "close"; "searchEvent": "search"; "clearEvent": "clear"; "addEvent": "add"; "removeEvent": "remove"; "scroll": "scroll"; "scrollToEnd": "scrollToEnd"; }, ["optionTemplate", "optgroupTemplate", "labelTemplate", "multiLabelTemplate", "headerTemplate", "footerTemplate", "notFoundTemplate", "typeToSearchTemplate", "loadingTextTemplate", "tagTemplate", "loadingSpinnerTemplate", "ngOptions"], never, false, never>;
}
