import { NgSelectComponent } from './ng-select.component';
import { NgOption } from './ng-select.types';
import { SelectionModel } from './selection-model';
export declare class ItemsList {
    private _ngSelect;
    private _selectionModel;
    private _groups;
    constructor(_ngSelect: NgSelectComponent, _selectionModel: SelectionModel);
    private _items;
    get items(): NgOption[];
    private _filteredItems;
    get filteredItems(): NgOption[];
    private _markedIndex;
    get markedIndex(): number;
    get selectedItems(): NgOption[];
    get markedItem(): NgOption;
    get noItemsToSelect(): boolean;
    get maxItemsSelected(): boolean;
    get lastSelectedItem(): NgOption;
    setItems(items: readonly any[]): void;
    select(item: NgOption): void;
    unselect(item: NgOption): void;
    findItem(value: any): NgOption;
    addItem(item: any): NgOption;
    clearSelected(keepDisabled?: boolean): void;
    findByLabel(term: string): NgOption;
    filter(term: string): void;
    resetFilteredItems(): void;
    unmarkItem(): void;
    markNextItem(): void;
    markPreviousItem(): void;
    markItem(item: NgOption): void;
    markSelectedOrDefault(markDefault?: boolean): void;
    resolveNested(option: any, key: string): any;
    mapItem(item: any, index: number): NgOption;
    mapSelectedItems(): void;
    private _showSelected;
    private _hideSelected;
    private _defaultSearchFn;
    private _getNextItemIndex;
    private _stepToItem;
    private _getLastMarkedIndex;
    private _groupBy;
    private _flatten;
}
