/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Re-export TransferState to the public API of the `platform-browser` for backwards-compatibility.
import { makeStateKey as makeStateKeyFromCore, TransferState as TransferStateFromCore } from '@angular/core';
/**
 * Create a `StateKey<T>` that can be used to store value of type T with `TransferState`.
 *
 * Example:
 *
 * ```
 * const COUNTER_KEY = makeStateKey<number>('counter');
 * let value = 10;
 *
 * transferState.set(COUNTER_KEY, value);
 * ```
 *
 * @publicApi
 * @deprecated `makeStateKey` has moved, please import `makeStateKey` from `@angular/core` instead.
 */
// The below is a workaround to add a deprecated message.
export const makeStateKey = makeStateKeyFromCore;
// The below type is needed for G3 due to JSC_CONFORMANCE_VIOLATION.
export const TransferState = TransferStateFromCore;
export { bootstrapApplication, BrowserModule, createApplication, platformBrowser, provideProtractorTestingSupport } from './browser';
export { Meta } from './browser/meta';
export { Title } from './browser/title';
export { disableDebugTools, enableDebugTools } from './browser/tools/tools';
export { By } from './dom/debug/by';
export { REMOVE_STYLES_ON_COMPONENT_DESTROY } from './dom/dom_renderer';
export { EVENT_MANAGER_PLUGINS, EventManager } from './dom/events/event_manager';
export { HAMMER_GESTURE_CONFIG, HAMMER_LOADER, HammerGestureConfig, HammerModule } from './dom/events/hammer_gestures';
export { DomSanitizer } from './security/dom_sanitization_service';
export { provideClientHydration, withNoDomReuse, withNoHttpTransferCache } from './hydration';
export * from './private_export';
export { VERSION } from './version';
//# sourceMappingURL=data:application/json;base64,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