/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/**
 * Injection token that can be used for a `MatSlider` to provide itself as a
 * parent to the `MatSliderThumb` and `MatSliderRangeThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER = new InjectionToken('_MatSlider');
/**
 * Injection token that can be used to query for a `MatSliderThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_THUMB = new InjectionToken('_MatSliderThumb');
/**
 * Injection token that can be used to query for a `MatSliderRangeThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_RANGE_THUMB = new InjectionToken('_MatSliderRangeThumb');
/**
 * Injection token that can be used to query for a `MatSliderVisualThumb`.
 * Used primarily to avoid circular imports.
 * @docs-private
 */
export const MAT_SLIDER_VISUAL_THUMB = new InjectionToken('_MatSliderVisualThumb');
/**
 * A simple change event emitted by the MatSlider component.
 * @deprecated Use event bindings directly on the MatSliderThumbs for `change` and `input` events. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
export class MatSliderChange {
}
//# sourceMappingURL=data:application/json;base64,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