/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/**
 * Injection token to be used to override the default options for `mat-slide-toggle`
 * @deprecated Use `MAT_SLIDE_TOGGLE_DEFAULT_OPTIONS` from `@angular/material/slide-toggle` instead. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
export const MAT_LEGACY_SLIDE_TOGGLE_DEFAULT_OPTIONS = new InjectionToken('mat-slide-toggle-default-options', {
    providedIn: 'root',
    factory: () => ({ disableToggleValue: false }),
});
//# sourceMappingURL=data:application/json;base64,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