/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Returns an exception to be thrown when attempting to change a select's `multiple` option
 * after initialization.
 * @docs-private
 * @deprecated Use `getMatSelectDynamicMultipleError` from `@angular/material/select` instead. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
export function getMatSelectDynamicMultipleError() {
    return Error('Cannot change `multiple` mode of select after initialization.');
}
/**
 * Returns an exception to be thrown when attempting to assign a non-array value to a select
 * in `multiple` mode. Note that `undefined` and `null` are still valid values to allow for
 * resetting the value.
 * @docs-private
 * @deprecated Use `getMatSelectNonArrayValueError` from `@angular/material/select` instead. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
export function getMatSelectNonArrayValueError() {
    return Error('Value must be an array in multiple-selection mode.');
}
/**
 * Returns an exception to be thrown when assigning a non-function value to the comparator
 * used to determine if a value corresponds to an option. Note that whether the function
 * actually takes two values and returns a boolean is not checked.
 * @deprecated Use `getMatSelectNonFunctionValueError` from `@angular/material/select` instead. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
export function getMatSelectNonFunctionValueError() {
    return Error('`compareWith` must be a function.');
}
//# sourceMappingURL=data:application/json;base64,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