/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { MatLegacyFormFieldHarness } from './form-field-harness';
export { MatLegacyErrorHarness } from './error-harness';
// Re-export the base control harness from the "form-field/testing/control" entry-point. To
// avoid circular dependencies, harnesses for form-field controls (i.e. input, select)
// need to import the base form-field control harness through a separate entry-point.
export { 
/**
 * @deprecated Use `MatFormFieldControlHarness` from `@angular/material/form-field/testing` instead. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
MatFormFieldControlHarness as MatLegacyFormFieldControlHarness, } from '@angular/material/form-field/testing/control';
//# sourceMappingURL=data:application/json;base64,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