/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var MatTestLegacyDialogOpener_1;
import { __decorate, __metadata } from "tslib";
import { ChangeDetectionStrategy, Component, NgModule, ViewEncapsulation } from '@angular/core';
import { MatLegacyDialog, MatLegacyDialogModule, } from '@angular/material/legacy-dialog';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { _MatTestDialogOpenerBase } from '@angular/material/dialog/testing';
/**
 * Test component that immediately opens a dialog when created.
 * @deprecated Use `MatTestDialogOpener` from `@angular/material/dialog/testing` instead. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
let MatTestLegacyDialogOpener = MatTestLegacyDialogOpener_1 = class MatTestLegacyDialogOpener extends _MatTestDialogOpenerBase {
    constructor(dialog) {
        super(dialog);
    }
    /** Static method that prepares this class to open the provided component. */
    static withComponent(component, config) {
        _MatTestDialogOpenerBase.component = component;
        _MatTestDialogOpenerBase.config = config;
        return MatTestLegacyDialogOpener_1;
    }
};
MatTestLegacyDialogOpener = MatTestLegacyDialogOpener_1 = __decorate([
    Component({
        selector: 'mat-test-dialog-opener',
        template: '',
        changeDetection: ChangeDetectionStrategy.OnPush,
        encapsulation: ViewEncapsulation.None,
    }),
    __metadata("design:paramtypes", [MatLegacyDialog])
], MatTestLegacyDialogOpener);
export { MatTestLegacyDialogOpener };
/**
 * @deprecated Use `MatTestDialogOpenerModule` from `@angular/material/dialog/testing` instead. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
let MatTestLegacyDialogOpenerModule = class MatTestLegacyDialogOpenerModule {
};
MatTestLegacyDialogOpenerModule = __decorate([
    NgModule({
        declarations: [MatTestLegacyDialogOpener],
        imports: [MatLegacyDialogModule, NoopAnimationsModule],
    })
], MatTestLegacyDialogOpenerModule);
export { MatTestLegacyDialogOpenerModule };
//# sourceMappingURL=data:application/json;base64,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