/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { HarnessPredicate } from '@angular/cdk/testing';
import { _MatDialogHarnessBase } from '@angular/material/dialog/testing';
/**
 * Harness for interacting with a standard `MatDialog` in tests.
 * @deprecated Use `MatDialogHarness` from `@angular/material/dialog/testing` instead. See https://material.angular.io/guide/mdc-migration for information about migrating.
 * @breaking-change 17.0.0
 */
class MatLegacyDialogHarness extends _MatDialogHarnessBase {
    constructor() {
        super(...arguments);
        this._title = this.locatorForOptional(".mat-dialog-title" /* MatLegacyDialogSection.TITLE */);
        this._content = this.locatorForOptional(".mat-dialog-content" /* MatLegacyDialogSection.CONTENT */);
        this._actions = this.locatorForOptional(".mat-dialog-actions" /* MatLegacyDialogSection.ACTIONS */);
    }
    // Developers can provide a custom component or template for the
    // dialog. The canonical dialog parent is the "MatDialogContainer".
    /** The selector for the host element of a `MatDialog` instance. */
    static { this.hostSelector = '.mat-dialog-container'; }
    /**
     * Gets a `HarnessPredicate` that can be used to search for a `MatDialogHarness` that meets
     * certain criteria.
     * @param options Options for filtering which dialog instances are considered a match.
     * @return a `HarnessPredicate` configured with the given options.
     */
    static with(options = {}) {
        return new HarnessPredicate(MatLegacyDialogHarness, options);
    }
}
export { MatLegacyDialogHarness };
//# sourceMappingURL=data:application/json;base64,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