/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var _MatTestDialogOpenerBase_1, MatTestDialogOpener_1;
import { __decorate, __metadata } from "tslib";
import { ChangeDetectionStrategy, Component, Directive, NgModule, ViewEncapsulation, } from '@angular/core';
import { MatDialog, MatDialogModule, _MatDialogBase, } from '@angular/material/dialog';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
/** Base class for a component that immediately opens a dialog when created. */
let _MatTestDialogOpenerBase = _MatTestDialogOpenerBase_1 = class _MatTestDialogOpenerBase {
    constructor(dialog) {
        this.dialog = dialog;
        if (!_MatTestDialogOpenerBase_1.component) {
            throw new Error(`MatTestDialogOpener does not have a component provided.`);
        }
        this.dialogRef = this.dialog.open(_MatTestDialogOpenerBase_1.component, _MatTestDialogOpenerBase_1.config || {});
        this._afterClosedSubscription = this.dialogRef.afterClosed().subscribe(result => {
            this.closedResult = result;
        });
    }
    ngOnDestroy() {
        this._afterClosedSubscription.unsubscribe();
        _MatTestDialogOpenerBase_1.component = undefined;
        _MatTestDialogOpenerBase_1.config = undefined;
    }
};
_MatTestDialogOpenerBase = _MatTestDialogOpenerBase_1 = __decorate([
    Directive(),
    __metadata("design:paramtypes", [_MatDialogBase])
], _MatTestDialogOpenerBase);
export { _MatTestDialogOpenerBase };
/** Test component that immediately opens a dialog when bootstrapped. */
let MatTestDialogOpener = MatTestDialogOpener_1 = class MatTestDialogOpener extends _MatTestDialogOpenerBase {
    constructor(dialog) {
        super(dialog);
    }
    /** Static method that prepares this class to open the provided component. */
    static withComponent(component, config) {
        _MatTestDialogOpenerBase.component = component;
        _MatTestDialogOpenerBase.config = config;
        return MatTestDialogOpener_1;
    }
};
MatTestDialogOpener = MatTestDialogOpener_1 = __decorate([
    Component({
        selector: 'mat-test-dialog-opener',
        template: '',
        changeDetection: ChangeDetectionStrategy.OnPush,
        encapsulation: ViewEncapsulation.None,
    }),
    __metadata("design:paramtypes", [MatDialog])
], MatTestDialogOpener);
export { MatTestDialogOpener };
let MatTestDialogOpenerModule = class MatTestDialogOpenerModule {
};
MatTestDialogOpenerModule = __decorate([
    NgModule({
        declarations: [MatTestDialogOpener],
        imports: [MatDialogModule, NoopAnimationsModule],
    })
], MatTestDialogOpenerModule);
export { MatTestDialogOpenerModule };
//# sourceMappingURL=data:application/json;base64,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