/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { Injectable, InjectionToken, Optional, SkipSelf } from '@angular/core';
import { DateAdapter } from '@angular/material/core';
import { DateRange } from './date-selection-model';
import * as i0 from "@angular/core";
import * as i1 from "@angular/material/core";
/** Injection token used to customize the date range selection behavior. */
export const MAT_DATE_RANGE_SELECTION_STRATEGY = new InjectionToken('MAT_DATE_RANGE_SELECTION_STRATEGY');
/** Provides the default date range selection behavior. */
class DefaultMatCalendarRangeStrategy {
    constructor(_dateAdapter) {
        this._dateAdapter = _dateAdapter;
    }
    selectionFinished(date, currentRange) {
        let { start, end } = currentRange;
        if (start == null) {
            start = date;
        }
        else if (end == null && date && this._dateAdapter.compareDate(date, start) >= 0) {
            end = date;
        }
        else {
            start = date;
            end = null;
        }
        return new DateRange(start, end);
    }
    createPreview(activeDate, currentRange) {
        let start = null;
        let end = null;
        if (currentRange.start && !currentRange.end && activeDate) {
            start = currentRange.start;
            end = activeDate;
        }
        return new DateRange(start, end);
    }
    createDrag(dragOrigin, originalRange, newDate) {
        let start = originalRange.start;
        let end = originalRange.end;
        if (!start || !end) {
            // Can't drag from an incomplete range.
            return null;
        }
        const adapter = this._dateAdapter;
        const isRange = adapter.compareDate(start, end) !== 0;
        const diffYears = adapter.getYear(newDate) - adapter.getYear(dragOrigin);
        const diffMonths = adapter.getMonth(newDate) - adapter.getMonth(dragOrigin);
        const diffDays = adapter.getDate(newDate) - adapter.getDate(dragOrigin);
        if (isRange && adapter.sameDate(dragOrigin, originalRange.start)) {
            start = newDate;
            if (adapter.compareDate(newDate, end) > 0) {
                end = adapter.addCalendarYears(end, diffYears);
                end = adapter.addCalendarMonths(end, diffMonths);
                end = adapter.addCalendarDays(end, diffDays);
            }
        }
        else if (isRange && adapter.sameDate(dragOrigin, originalRange.end)) {
            end = newDate;
            if (adapter.compareDate(newDate, start) < 0) {
                start = adapter.addCalendarYears(start, diffYears);
                start = adapter.addCalendarMonths(start, diffMonths);
                start = adapter.addCalendarDays(start, diffDays);
            }
        }
        else {
            start = adapter.addCalendarYears(start, diffYears);
            start = adapter.addCalendarMonths(start, diffMonths);
            start = adapter.addCalendarDays(start, diffDays);
            end = adapter.addCalendarYears(end, diffYears);
            end = adapter.addCalendarMonths(end, diffMonths);
            end = adapter.addCalendarDays(end, diffDays);
        }
        return new DateRange(start, end);
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.0.0", ngImport: i0, type: DefaultMatCalendarRangeStrategy, deps: [{ token: i1.DateAdapter }], target: i0.ɵɵFactoryTarget.Injectable }); }
    static { this.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "16.0.0", ngImport: i0, type: DefaultMatCalendarRangeStrategy }); }
}
export { DefaultMatCalendarRangeStrategy };
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.0.0", ngImport: i0, type: DefaultMatCalendarRangeStrategy, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.DateAdapter }]; } });
/** @docs-private */
export function MAT_CALENDAR_RANGE_STRATEGY_PROVIDER_FACTORY(parent, adapter) {
    return parent || new DefaultMatCalendarRangeStrategy(adapter);
}
/** @docs-private */
export const MAT_CALENDAR_RANGE_STRATEGY_PROVIDER = {
    provide: MAT_DATE_RANGE_SELECTION_STRATEGY,
    deps: [[new Optional(), new SkipSelf(), MAT_DATE_RANGE_SELECTION_STRATEGY], DateAdapter],
    useFactory: MAT_CALENDAR_RANGE_STRATEGY_PROVIDER_FACTORY,
};
//# sourceMappingURL=data:application/json;base64,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