/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export function mixinErrorState(base) {
    return class extends base {
        /** Updates the error state based on the provided error state matcher. */
        updateErrorState() {
            const oldState = this.errorState;
            const parent = this._parentFormGroup || this._parentForm;
            const matcher = this.errorStateMatcher || this._defaultErrorStateMatcher;
            const control = this.ngControl ? this.ngControl.control : null;
            const newState = matcher.isErrorState(control, parent);
            if (newState !== oldState) {
                this.errorState = newState;
                this.stateChanges.next();
            }
        }
        constructor(...args) {
            super(...args);
            /** Whether the component is in an error state. */
            this.errorState = false;
        }
    };
}
//# sourceMappingURL=data:application/json;base64,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