/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { Inject, NgModule, PLATFORM_ID } from '@angular/core';
import { isPlatformServer } from '@angular/common';
import { SERVER_TOKEN, LAYOUT_CONFIG, DEFAULT_CONFIG, BREAKPOINT, } from '@angular/flex-layout/core';
import { ExtendedModule } from '@angular/flex-layout/extended';
import { FlexModule } from '@angular/flex-layout/flex';
import { GridModule } from '@angular/flex-layout/grid';
import * as i0 from "@angular/core";
/**
 * FlexLayoutModule -- the main import for all utilities in the Angular Layout library
 * * Will automatically provide Flex, Grid, and Extended modules for use in the application
 * * Can be configured using the static withConfig method, options viewable on the Wiki's
 *   Configuration page
 */
export class FlexLayoutModule {
    constructor(serverModuleLoaded, platformId) {
        if (isPlatformServer(platformId) && !serverModuleLoaded) {
            console.warn('Warning: Flex Layout loaded on the server without FlexLayoutServerModule');
        }
    }
    /**
     * Initialize the FlexLayoutModule with a set of config options,
     * which sets the corresponding tokens accordingly
     */
    static withConfig(configOptions, 
    // tslint:disable-next-line:max-line-length
    breakpoints = []) {
        return {
            ngModule: FlexLayoutModule,
            providers: configOptions.serverLoaded ?
                [
                    { provide: LAYOUT_CONFIG, useValue: { ...DEFAULT_CONFIG, ...configOptions } },
                    { provide: BREAKPOINT, useValue: breakpoints, multi: true },
                    { provide: SERVER_TOKEN, useValue: true },
                ] : [
                { provide: LAYOUT_CONFIG, useValue: { ...DEFAULT_CONFIG, ...configOptions } },
                { provide: BREAKPOINT, useValue: breakpoints, multi: true },
            ]
        };
    }
}
FlexLayoutModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.0.2", ngImport: i0, type: FlexLayoutModule, deps: [{ token: SERVER_TOKEN }, { token: PLATFORM_ID }], target: i0.ɵɵFactoryTarget.NgModule });
FlexLayoutModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "15.0.2", ngImport: i0, type: FlexLayoutModule, imports: [FlexModule, ExtendedModule, GridModule], exports: [FlexModule, ExtendedModule, GridModule] });
FlexLayoutModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "15.0.2", ngImport: i0, type: FlexLayoutModule, imports: [FlexModule, ExtendedModule, GridModule, FlexModule, ExtendedModule, GridModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.0.2", ngImport: i0, type: FlexLayoutModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [FlexModule, ExtendedModule, GridModule],
                    exports: [FlexModule, ExtendedModule, GridModule]
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [SERVER_TOKEN]
                }] }, { type: Object, decorators: [{
                    type: Inject,
                    args: [PLATFORM_ID]
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,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