/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** HOF to sort the breakpoints by descending priority */
export function sortDescendingPriority(a, b) {
    const priorityA = a ? a.priority || 0 : 0;
    const priorityB = b ? b.priority || 0 : 0;
    return priorityB - priorityA;
}
/** HOF to sort the breakpoints by ascending priority */
export function sortAscendingPriority(a, b) {
    const pA = a.priority || 0;
    const pB = b.priority || 0;
    return pA - pB;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic29ydC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL2xpYnMvZmxleC1sYXlvdXQvY29yZS91dGlscy9zb3J0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQU1ILHlEQUF5RDtBQUN6RCxNQUFNLFVBQVUsc0JBQXNCLENBQXlCLENBQVcsRUFBRSxDQUFXO0lBQ3JGLE1BQU0sU0FBUyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLFFBQVEsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUMxQyxNQUFNLFNBQVMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxRQUFRLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDMUMsT0FBTyxTQUFTLEdBQUcsU0FBUyxDQUFDO0FBQy9CLENBQUM7QUFFRCx3REFBd0Q7QUFDeEQsTUFBTSxVQUFVLHFCQUFxQixDQUF5QixDQUFJLEVBQUUsQ0FBSTtJQUN0RSxNQUFNLEVBQUUsR0FBRyxDQUFDLENBQUMsUUFBUSxJQUFJLENBQUMsQ0FBQztJQUMzQixNQUFNLEVBQUUsR0FBRyxDQUFDLENBQUMsUUFBUSxJQUFJLENBQUMsQ0FBQztJQUMzQixPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUM7QUFDakIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbnRlcmZhY2UgV2l0aFByaW9yaXR5IHtcbiAgcHJpb3JpdHk/OiBudW1iZXI7XG59XG5cbi8qKiBIT0YgdG8gc29ydCB0aGUgYnJlYWtwb2ludHMgYnkgZGVzY2VuZGluZyBwcmlvcml0eSAqL1xuZXhwb3J0IGZ1bmN0aW9uIHNvcnREZXNjZW5kaW5nUHJpb3JpdHk8VCBleHRlbmRzIFdpdGhQcmlvcml0eT4oYTogVCB8IG51bGwsIGI6IFQgfCBudWxsKTogbnVtYmVyIHtcbiAgY29uc3QgcHJpb3JpdHlBID0gYSA/IGEucHJpb3JpdHkgfHwgMCA6IDA7XG4gIGNvbnN0IHByaW9yaXR5QiA9IGIgPyBiLnByaW9yaXR5IHx8IDAgOiAwO1xuICByZXR1cm4gcHJpb3JpdHlCIC0gcHJpb3JpdHlBO1xufVxuXG4vKiogSE9GIHRvIHNvcnQgdGhlIGJyZWFrcG9pbnRzIGJ5IGFzY2VuZGluZyBwcmlvcml0eSAqL1xuZXhwb3J0IGZ1bmN0aW9uIHNvcnRBc2NlbmRpbmdQcmlvcml0eTxUIGV4dGVuZHMgV2l0aFByaW9yaXR5PihhOiBULCBiOiBUKTogbnVtYmVyIHtcbiAgY29uc3QgcEEgPSBhLnByaW9yaXR5IHx8IDA7XG4gIGNvbnN0IHBCID0gYi5wcmlvcml0eSB8fCAwO1xuICByZXR1cm4gcEEgLSBwQjtcbn1cbiJdfQ==