/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
export const DEFAULT_CONFIG = {
    addFlexToParent: true,
    addOrientationBps: false,
    disableDefaultBps: false,
    disableVendorPrefixes: false,
    serverLoaded: false,
    useColumnBasisZero: true,
    printWithBreakpoints: [],
    mediaTriggerAutoRestore: true,
    ssrObserveBreakpoints: [],
    // This is disabled by default because otherwise the multiplier would
    // run for all users, regardless of whether they're using this feature.
    // Instead, we disable it by default, which requires this ugly cast.
    multiplier: undefined,
    defaultUnit: 'px',
    detectLayoutDisplay: false,
};
export const LAYOUT_CONFIG = new InjectionToken('Flex Layout token, config options for the library', {
    providedIn: 'root',
    factory: () => DEFAULT_CONFIG
});
//# sourceMappingURL=data:application/json;base64,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