const MULTIPLIER_SUFFIX = 'x';
export function multiply(value, multiplier) {
    if (multiplier === undefined) {
        return value;
    }
    const transformValue = (possibleValue) => {
        const numberValue = +(possibleValue.slice(0, -MULTIPLIER_SUFFIX.length));
        if (value.endsWith(MULTIPLIER_SUFFIX) && !isNaN(numberValue)) {
            return `${numberValue * multiplier.value}${multiplier.unit}`;
        }
        return value;
    };
    return value.includes(' ') ?
        value.split(' ').map(transformValue).join(' ') : transformValue(value);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibXVsdGlwbGllci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL2xpYnMvZmxleC1sYXlvdXQvY29yZS9tdWx0aXBseS9tdWx0aXBsaWVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUtBLE1BQU0saUJBQWlCLEdBQUcsR0FBRyxDQUFDO0FBRTlCLE1BQU0sVUFBVSxRQUFRLENBQUMsS0FBYSxFQUFFLFVBQXVCO0lBQzdELElBQUksVUFBVSxLQUFLLFNBQVMsRUFBRTtRQUM1QixPQUFPLEtBQUssQ0FBQztLQUNkO0lBRUQsTUFBTSxjQUFjLEdBQUcsQ0FBQyxhQUFxQixFQUFFLEVBQUU7UUFDL0MsTUFBTSxXQUFXLEdBQUcsQ0FBQyxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztRQUV6RSxJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsRUFBRTtZQUM1RCxPQUFPLEdBQUcsV0FBVyxHQUFHLFVBQVUsQ0FBQyxLQUFLLEdBQUcsVUFBVSxDQUFDLElBQUksRUFBRSxDQUFDO1NBQzlEO1FBRUQsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDLENBQUM7SUFFRixPQUFPLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztRQUMxQixLQUFLLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUMzRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGludGVyZmFjZSBNdWx0aXBsaWVyIHtcbiAgcmVhZG9ubHkgdW5pdDogc3RyaW5nO1xuICByZWFkb25seSB2YWx1ZTogbnVtYmVyO1xufVxuXG5jb25zdCBNVUxUSVBMSUVSX1NVRkZJWCA9ICd4JztcblxuZXhwb3J0IGZ1bmN0aW9uIG11bHRpcGx5KHZhbHVlOiBzdHJpbmcsIG11bHRpcGxpZXI/OiBNdWx0aXBsaWVyKTogc3RyaW5nIHtcbiAgaWYgKG11bHRpcGxpZXIgPT09IHVuZGVmaW5lZCkge1xuICAgIHJldHVybiB2YWx1ZTtcbiAgfVxuXG4gIGNvbnN0IHRyYW5zZm9ybVZhbHVlID0gKHBvc3NpYmxlVmFsdWU6IHN0cmluZykgPT4ge1xuICAgIGNvbnN0IG51bWJlclZhbHVlID0gKyhwb3NzaWJsZVZhbHVlLnNsaWNlKDAsIC1NVUxUSVBMSUVSX1NVRkZJWC5sZW5ndGgpKTtcblxuICAgIGlmICh2YWx1ZS5lbmRzV2l0aChNVUxUSVBMSUVSX1NVRkZJWCkgJiYgIWlzTmFOKG51bWJlclZhbHVlKSkge1xuICAgICAgcmV0dXJuIGAke251bWJlclZhbHVlICogbXVsdGlwbGllci52YWx1ZX0ke211bHRpcGxpZXIudW5pdH1gO1xuICAgIH1cblxuICAgIHJldHVybiB2YWx1ZTtcbiAgfTtcblxuICByZXR1cm4gdmFsdWUuaW5jbHVkZXMoJyAnKSA/XG4gICAgdmFsdWUuc3BsaXQoJyAnKS5tYXAodHJhbnNmb3JtVmFsdWUpLmpvaW4oJyAnKSA6IHRyYW5zZm9ybVZhbHVlKHZhbHVlKTtcbn1cbiJdfQ==