/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/* tslint:disable */
const HANDSET_PORTRAIT = '(orientation: portrait) and (max-width: 599.98px)';
const HANDSET_LANDSCAPE = '(orientation: landscape) and (max-width: 959.98px)';
const TABLET_PORTRAIT = '(orientation: portrait) and (min-width: 600px) and (max-width: 839.98px)';
const TABLET_LANDSCAPE = '(orientation: landscape) and (min-width: 960px) and (max-width: 1279.98px)';
const WEB_PORTRAIT = '(orientation: portrait) and (min-width: 840px)';
const WEB_LANDSCAPE = '(orientation: landscape) and (min-width: 1280px)';
export const ScreenTypes = {
    'HANDSET': `${HANDSET_PORTRAIT}, ${HANDSET_LANDSCAPE}`,
    'TABLET': `${TABLET_PORTRAIT} , ${TABLET_LANDSCAPE}`,
    'WEB': `${WEB_PORTRAIT}, ${WEB_LANDSCAPE} `,
    'HANDSET_PORTRAIT': `${HANDSET_PORTRAIT}`,
    'TABLET_PORTRAIT': `${TABLET_PORTRAIT} `,
    'WEB_PORTRAIT': `${WEB_PORTRAIT}`,
    'HANDSET_LANDSCAPE': `${HANDSET_LANDSCAPE}`,
    'TABLET_LANDSCAPE': `${TABLET_LANDSCAPE}`,
    'WEB_LANDSCAPE': `${WEB_LANDSCAPE}`
};
/**
 * Extended Breakpoints for handset/tablets with landscape or portrait orientations
 */
export const ORIENTATION_BREAKPOINTS = [
    { 'alias': 'handset', priority: 2000, 'mediaQuery': ScreenTypes.HANDSET },
    { 'alias': 'handset.landscape', priority: 2000, 'mediaQuery': ScreenTypes.HANDSET_LANDSCAPE },
    { 'alias': 'handset.portrait', priority: 2000, 'mediaQuery': ScreenTypes.HANDSET_PORTRAIT },
    { 'alias': 'tablet', priority: 2100, 'mediaQuery': ScreenTypes.TABLET },
    { 'alias': 'tablet.landscape', priority: 2100, 'mediaQuery': ScreenTypes.TABLET_LANDSCAPE },
    { 'alias': 'tablet.portrait', priority: 2100, 'mediaQuery': ScreenTypes.TABLET_PORTRAIT },
    { 'alias': 'web', priority: 2200, 'mediaQuery': ScreenTypes.WEB, overlapping: true },
    { 'alias': 'web.landscape', priority: 2200, 'mediaQuery': ScreenTypes.WEB_LANDSCAPE, overlapping: true },
    { 'alias': 'web.portrait', priority: 2200, 'mediaQuery': ScreenTypes.WEB_PORTRAIT, overlapping: true }
];
//# sourceMappingURL=data:application/json;base64,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